<?php
require_once dirname(__FILE__)."/../article.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_article_sqlite is an implementation for SQLite of BD_article business class.
 * @package	BD_sqlite
 * @author	Stphane PETIT <stephane@petit-fr.net>
 * @access	public
 */
class BD_article_sqlite extends BD_article {
    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
	BD_article::_fetchData($row) ;
    }

    // }}}
    
    // {{{ getAllDocumentsLies($id_article, $mode)

    /**
     * Returns an array of Document.
     *
     *
     * @return Array of Document
     * @param $id_article
     * @access public
     */

    function &getAllDocumentsLies($id_article, $mode, $docs_exclus = "", $id_doublons = null) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllDocumentLies()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document AS id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_articles l WHERE l.id_article=$id_article AND l.id_document=docs.id_document ".$docs_exclus." AND docs.mode_spip='$mode'";
        if ($id_doublons) $query .= " AND docs.id_document NOT IN (".$id_doublons.") ";
        $query .= " ORDER BY docs.id_document";

        //echo $query;
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllDocumentLies()] ".$queryResult->getMessage(), null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $documentIds[] = $row['id_document'];
    }
    $queryResult->free();
    return $documentIds;
    }

    // }}}

}
?>
