<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour              |
// +----------------------------------------------------------------------+
//
// SQLite implementation for ArticleListData
//

if (defined("_BD_ARTICLELISTDATASQLITE")) return;
define("_BD_ARTICLELISTDATASQLITE", "1");

require_once dirname(__FILE__)."/../articlelistdata.php";
require_once dirname(__FILE__)."/../inc_listdata_querytypes_constants.php";
/**
 * BD_article_sqlite is an implementation for sqlite of BD_article business class.
 * @package	BD_sqlite
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_articleListData_sqlite extends BD_articleListData {

    // {{{ _getArticleAuthors($articleId)

    /**
     * returns a formatted HTML String representing the article authors
     * This method should be overloaded whenever the SQL request would not
     * be compatible with de DB engine used.
     * this method is "protected"
     * @return String
     * @param int $articleId representing the article id
     * @access private
     */

    function _getArticleAuthors($articleId) {
        global $connect_id_auteur, $connect_statut;

        $returnValue = "";

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die($db->getMessage());
        }

        $query = "SELECT auteurs.id_auteur AS id_auteur, nom, messagerie, login, en_ligne ".
                 "FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
                 "WHERE lien.id_article=$articleId AND auteurs.id_auteur=lien.id_auteur";

        $result = $db->query($query);
        if (DB::isError($result)) {
            die($result->getMessage());
        }

        while ($row = $result->fetchRow()) {
            $id_auteur = $row['id_auteur'];
            $nom_auteur = typo($row['nom']);
            $auteur_messagerie = $row['messagerie'];

            $returnValue .= ", $nom_auteur";
            if ($id_auteur != $connect_id_auteur AND $auteur_messagerie != "non" AND $activer_messagerie != "non") {
                $returnValue .= "&nbsp;".bouton_imessage($id_auteur, $row);
            }
        }

        $returnValue = substr($returnValue, 2);
        $result->free();
        return $returnValue;
    }

    // }}}
    
    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[ARTICLES_ALL_BY_STATE] = "SELECT id_article, titre, id_rubrique, statut, date_heure "
                                          ."FROM spip_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_ALL_BY_STATE] = "SELECT COUNT(id_article) "
                                          ."FROM spip_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!)";

        $this->_queries[ARTICLES_BY_STATE] = "SELECT articles.id_article AS id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
                                        	 "FROM spip_articles articles, spip_auteurs_articles lien ".
                                        	 "WHERE articles.id_article=lien.id_article AND lien.id_auteur=? AND articles.statut=? ORDER BY articles.date_heure DESC";
        $this->_queriesCount[ARTICLES_BY_STATE] = "SELECT count(articles.id_article) ".
                                        	      "FROM spip_articles articles, spip_auteurs_articles lien ".
                                        	      "WHERE articles.id_article=lien.id_article AND lien.id_auteur=? AND articles.statut=?";

        $this->_queries[ARTICLES_BY_AUTHOR] = "SELECT article.id_article AS id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
	                                         "FROM spip_articles article, spip_auteurs_articles lien WHERE lien.id_auteur=? ".
	                                         "AND lien.id_article=article.id_article AND article.statut IN (!) ORDER BY article.date_heure DESC";
        $this->_queriesCount[ARTICLES_BY_AUTHOR] = "SELECT COUNT(article.id_article) ".
    	                                          "FROM spip_articles article, spip_auteurs_articles lien WHERE lien.id_auteur=? ".
    	                                          "AND lien.id_article=article.id_article AND article.statut IN (!)";

        $this->_queries[ARTICLES_TOCOME] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                   "FROM spip_articles WHERE statut='publie' AND date_heure><!spipNOW_DATE_FORMAT_ISOspip!> ORDER BY date_heure";
        $this->_queriesCount[ARTICLES_TOCOME] = "SELECT count(id_article) ".
		                                        "FROM spip_articles WHERE statut='publie' AND date_heure><!spipNOW_DATE_FORMAT_ISOspip!>";

        $this->_queries[ARTICLES_PROPOSED] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                     "FROM spip_articles WHERE statut LIKE 'prop' ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_PROPOSED] = "SELECT count(id_article) ".
		                                          "FROM spip_articles WHERE statut LIKE 'prop'";

        $this->_queries[ARTICLES_PROPOSED_FILTERED] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                              "FROM spip_articles WHERE statut LIKE 'prop' AND id_article NOT IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_PROPOSED_FILTERED] = "SELECT count(id_article) ".
		                                                   "FROM spip_articles WHERE statut LIKE 'prop' AND id_article NOT IN (!)";

        $this->_queries[ARTICLES_BY_KEYWORD] = "SELECT article.* FROM spip_articles article, spip_mots_articles lien WHERE lien.id_mot=? ".
	                                           "AND lien.id_article=article.id_article AND article.statut IN (!) ORDER BY article.date_heure DESC";
        $this->_queriesCount[ARTICLES_BY_KEYWORD] = "SELECT count(article.id_article) FROM spip_articles article, spip_mots_articles lien WHERE lien.id_mot=? ".
	                                                "AND lien.id_article=article.id_article AND article.statut IN (!)";

        $this->_queries[ARTICLES_BY_AUTHOR_STATE_AND_RUBRIQUE] = "SELECT articles.id_article AS id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
                                                                 "FROM spip_articles articles, spip_auteurs_articles lien ".
                                                                "WHERE articles.id_article=lien.id_article AND id_rubrique=? ".
                                                                "AND lien.id_auteur=? AND articles.statut=? ORDER BY articles.date_heure DESC";
        $this->_queriesCount[ARTICLES_BY_AUTHOR_STATE_AND_RUBRIQUE] = "SELECT count(articles.id_article) ".
                                                                    "FROM spip_articles articles, spip_auteurs_articles lien ".
                                                                    "WHERE articles.id_article=lien.id_article AND id_rubrique=? ".
                                                                    "AND lien.id_auteur=? AND articles.statut=?";
        $this->_queries[ARTICLES_BY_STATE_AND_RUBRIQUE] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
                                                          "FROM spip_articles WHERE statut=? AND id_rubrique=? ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_BY_STATE_AND_RUBRIQUE] = "SELECT count(id_article) ".
                                                               "FROM spip_articles WHERE statut=? AND id_rubrique=?";

        $this->_queries[ARTICLES_RECHERCHE] = "SELECT spip_articles.id_article AS id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
                                                    "FROM spip_articles WHERE <!spipARTICLE_CONSTRUCTION_RECHERCHEspip!> ORDER BY maj DESC";
        $this->_queriesCount[ARTICLES_RECHERCHE] = "SELECT count(id_article) ".
                                                    "FROM spip_articles WHERE  <!spipARTICLE_CONSTRUCTION_RECHERCHEspip!>";

        /*
        $this->_queries[ARTICLES_RECHERCHE_INT] = "SELECT objet.*, SUM(idx.points) AS points ".
                                                    "FROM spip_articles objet, spip_index_articles idx ".
                                                    "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!) GROUP BY objet.id_article ORDER BY points DESC ";
        */
        $this->_queries[ARTICLES_RECHERCHE_INT] = "SELECT objet.id_article AS id_article, objet.titre AS titre, objet.date_heure AS date_heure, objet.statut AS status, SUM(idx.points) AS points ".
                                                    "FROM spip_articles objet, spip_index_articles idx ".
                                                    "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!) GROUP BY objet.id_article, objet.titre, objet.date_heure, objet.statut ORDER BY points DESC ";


        $this->_queriesCount[ARTICLES_RECHERCHE_INT] = "SELECT COUNT(*) ".
                                                    "FROM spip_articles objet, spip_index_articles idx ".
                                                    "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!)";
        $this->_queries[ARTICLES_ALL_BY_STATE_NOT_SELECTED] = "SELECT id_article, titre, id_rubrique, statut, date_heure "
                                          ."FROM spip_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!) AND id_article NOT IN(!) ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_ALL_BY_STATE_NOT_SELECTED] = "SELECT COUNT(id_article) "
                                          ."FROM spip_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!) AND id_article NOT IN(!)";


		$this->_queries[ARTICLES_FORUM_MESSAGE] = "SELECT DISTINCT spip_articles.id_article AS id_article, spip_articles.surtitre AS surtitre, spip_articles.titre AS titre, spip_articles.id_rubrique AS id_rubrique, spip_articles.date_heure AS date_heure, spip_articles.statut AS status FROM spip_articles, spip_forum WHERE ( (spip_articles.id_article = spip_forum.id_article) ) ORDER BY spip_articles.date_heure";
        
        //$this->_queriesCount[ARTICLES_FORUM_MESSAGE] = "SELECT count(DISTINCT(spip_forum.id_article)) FROM spip_articles, spip_forum WHERE spip_forum.id_article=spip_articles.id_article GROUP BY spip_forum.id_article";
        $this->_queriesCount[ARTICLES_FORUM_MESSAGE] = "SELECT count(id_article) FROM (SELECT DISTINCT spip_forum.id_article AS id_article FROM spip_articles, spip_forum WHERE spip_forum.id_article=spip_articles.id_article GROUP BY spip_forum.id_article)";
        
		$this->_queries[ARTICLES_VALIDED] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                     "FROM spip_articles WHERE statut='valid' ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_VALIDED] = "SELECT count(id_article) ".
		                                          "FROM spip_articles WHERE statut='valid'";

        $this->_queries[ARTICLES_VALIDED_FILTERED] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                              "FROM spip_articles WHERE statut='valid' AND id_article NOT IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_VALIDED_FILTERED] = "SELECT count(id_article) ".
		                                                   "FROM spip_articles WHERE statut='valid' AND id_article NOT IN (!)";

        $this->_queries[ARTICLES_IN_NL] = "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
		                                              "FROM spip_articles, spip_cm_posts_articles WHERE spip_cm_posts_articles.article_id = spip_articles.id_article AND id_article IN (!) AND pst_id =? ORDER BY art_order ASC";

        $this->_queriesCount[ARTICLES_IN_NL] = "SELECT count(id_article) ".
		                                                   "FROM spip_articles, spip_cm_posts_articles WHERE spip_cm_posts_articles.article_id = spip_articles.id_article AND id_article IN (!) AND pst_id =?";


    }

    // }}}
}
?>
