<?php
require_once dirname(__FILE__)."/../document.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_document_sqlite is an implementation for SQLite of BD_document business class.
 * @package	BD_sqlite
 * @author	Stphane PETIT <stephane@petit-fr.net>
 * @access	public
 */
class BD_document_sqlite extends BD_document {
    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
        BD_document::_fetchData($row) ;
    }

    // }}}
    
    // {{{ getAlldocumentIdsForArticleId($articleId)

    /**
     * This method creates an array of document Ids attached to an article
     *
     * param  $articleId  id of the article which documents must be attached
     * @return  Array   wished array of document Ids
     * @access  public
     */

    function getAlldocumentIdsForArticleId($articleId) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document AS id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_articles lien WHERE lien.id_article=$articleId AND lien.id_document=docs.id_document";
         
        //echo "<br>$query</br>" ;
	$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_document : getAlldocumentIdsForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $documentIds[] = $row['id_document'];}
        $result->free();
        return $documentIds;
    }

    // }}}
}
?>
