<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour             |
// +----------------------------------------------------------------------+
//
// Base class for newsletter business persistence abstraction.
//

require_once dirname(__FILE__)."/../newsletter.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_newsletter_sqlite is an implementation for sqlite of BD_newsletter business class.
 * @package	BD_sqlite
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_newsletter_sqlite extends BD_newsletter {
   // {{{ create()

    function create() {
        $db = &$this->_getDB();
        $newsletterId = $db->nextId('spip_cm_lists', true);
        if (DB::isError($newsletterId)) {
            return $newsletterId;
        }

        $this->_id = $newsletterId;

        $query = 'INSERT INTO spip_cm_lists ('.NEWSLETTER_ALL_FIELDS.') VALUES '
                ."('".$this->_id."', "
                ."'".$db->quoteString($this->_name)."', "
            	."'".$db->quoteString($this->_comment)."', "
            	."'".$this->_moderation."', "
            	."'".$this->_moderatorEmail."', "
                ."'".$db->quoteString($this->_subscribeSubject)."', "
                ."'".$db->quoteString($this->_subscribeText)."', "
                ."'".$db->quoteString($this->_subject)."', "
                ."'".$db->quoteString($this->_unsubscribeSubject)."', "
                ."'".$db->quoteString($this->_unsubscribeText)."', "
                ."'".$db->quoteString($this->_subjectTag)."', "
                ."'".$this->_htmlSkeleton."', "
                ."'".$this->_textSkeleton."', "
                ."'".$this->_nbArticles."') ";

        $query = $this->_traiteQuery($query);

        $result = $db->query($query);
        if (DB::isError($result)) {
            die($result->getMessage());
            return $result;
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
        $query = "UPDATE spip_cm_lists SET "
				."lst_name = '".$db->quoteString($this->_name)."'"
				.", lst_comment= '".$db->quoteString($this->_comment)."'"
            	.", lst_moderation= '".$this->_moderation."'"
            	.", lst_moderator_email= '".$this->_moderatorEmail."'"
                .", lst_subscribe_subject= '".$db->quoteString($this->_subscribeSubject)."'"
                .", lst_subscribe_text= '".$db->quoteString($this->_subscribeText)."'"
                .", lst_subject= '".$db->quoteString($this->_subject)."'"
                .", lst_unsubscribe_subject= '".$db->quoteString($this->_unsubscribeSubject)."'"
                .", lst_unsubscribe_text= '".$db->quoteString($this->_unsubscribeText)."'"
                .", lst_subject_tag= '".$db->quoteString($this->_subjectTag)."'"
                .", lst_html_skeleton= '".$this->_htmlSkeleton."'"
                .", lst_text_skeleton= '".$this->_textSkeleton."'"
                .", lst_nb_articles= '".$this->_nbArticles."'"
				." WHERE lst_id = ".$this->_id;

        $query = $this->_traiteQuery($query);

		//echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            die($result->getMessage());
        }

    }

    // }}}
    
    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
	BD_newsletter::_fetchData($row) ;
    }

    // }}}
}
?>
