<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                |
// +----------------------------------------------------------------------+
//
// Base class for Referer business persistence abstraction.
//
require_once dirname(__FILE__)."/../referer.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_referer_sqlite is an implementation for sqlite of BD_referer business class.
 * @package	BD_sqlite
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_referer_sqlite extends BD_referer {
     // {{{ howManyArticleId()

    function howManyArticleId() {
        $howManyArticleId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : howManyArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		//$query = "SELECT COUNT(DISTINCT id_article) AS count FROM spip_referers_articles";
        $query = "SELECT DISTINCT id_article AS count FROM (SELECT DISTINCT id_article FROM spip_referers_articles)";
        $query = $this->_traiteQuery($query);
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : howManyArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticleId = intval($row["count"]);
        }
        $result->free();
        return $howManyArticleId;
    }


    // }}}
    
    
    // {{{ getAllTempReferersForTypeAndReferer($type, $referer_vus)

    function getAllTempReferersForTypeAndReferer($type, $referer_vus) {
        $referers = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllTempReferersForTypeAndReferer()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$where = (is_array($referer_vus)) ? "AND referer_md5 IN (".join(',',$referer_vus).")" : "";

	    //$query = 'SELECT COUNT(DISTINCT ip) AS visites, id_objet, referer, referer_md5 AS md5 '.
		  //  'FROM spip_referers_temp WHERE type_referer=\'' . $type . '\'' . $where . ' GROUP BY id_objet, referer, referer_md5';
          
          $query = 'SELECT COUNT(ip) as visites, id_objet, referer, referer_md5 AS md5 FROM 
                (SELECT DISTINCT ip as visites, id_objet, referer, referer_md5 AS md5 FROM spip_referers_temp WHERE type_referer=\'' . $type . '\'' . $where . ' GROUP BY id_objet, referer, referer_md5)';
          
	    /*
	    $query = "SELECT COUNT(DISTINCT ip) AS visites, id_objet, referer, HEX(referer_md5) AS md5 ".
		    "FROM spip_referers_temp WHERE type='$type' $where GROUP BY id_objet, referer_md5";
	    */
        $query = $this->_traiteQuery($query);
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_referer : getAllTempReferersForTypeAndReferer()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $row['md5'] = $row['md5'];
            $referers[] = $row;
        }
        $result->free();
        return $referers;
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
	BD_referer::_fetchData($row) ;
    }

    // }}}
}
?>
