<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour
// +----------------------------------------------------------------------+
//
// Base class for Rubrique business persistence abstraction.
//
require_once dirname(__FILE__)."/../rubrique.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_rubrique_sqlite is an implementation for SQLite of BD_rubrique business class.
 * @package	BD_sqlite
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_rubrique_sqlite extends BD_rubrique {

    // {{{ getAllForParentId($leparent, $critere)

    /**
     * Returns an array of Rubrique depending
     * on $leparent order by $order.
     *
     *
     * @return Array of Rubrique
     * @param $leparent
     * @param $critere
     * @access public
     */

    function &getAllForParentId($leparent, $critere = null) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForParentId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".RUBRIQUE_ALL_FIELDS." FROM spip_rubriques WHERE id_parent=$leparent";
        if($critere != null) $query .= " ORDER BY $critere";

        //echo "$query<br>";

        $query = $this->_traiteQuery($query);
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_rubrique : getAllForParentId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultRubrique = &BD_rubrique::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultRubrique->_fetchData($row);
            $result[] = &$resultRubrique;

    	}
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
	BD_rubrique::_fetchData($row) ;
    }

    // }}}
}
?>
