<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour             |
// +----------------------------------------------------------------------+
//
// Base class for Visite business persistence abstraction.
//
require_once dirname(__FILE__)."/../visite.php";
require_once dirname(__FILE__)."/SQLite_functions.php";

/**
 * BD_visite_sqlite is an implementation for sqlite of BD_visite business class.
 * @package	BD_sqlite
 * @author 	Olivier Mansour
 * @access	public
 */
class BD_visite_sqlite extends BD_visite {
    // {{{ howManyDistinctVisite()

    function howManyDistinctVisite() {
        $howManyVisite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisite()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		//$query = "SELECT COUNT(DISTINCT ip) AS total_visites FROM spip_visites_temp";
        // adaptation aux contraintes de sqlite 
        $query = "SELECT COUNT(ip) AS total_visites FROM (SELECT DISTINCT ip from spip_visites_temp)";
        $query = $this->_traiteQuery($query);
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisite()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyVisite = intval($row["total_visites"]);
        }
        $result->free();
        return $howManyVisite;
    }

    // }}}
    
    
    
    // {{{ howManyDistinctVisiteForAnArticle($id_article = null)

    function howManyDistinctVisiteForAnArticle($id_article = null) {
        $howManyVisite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisiteForAnArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		//$query = "SELECT COUNT(DISTINCT ip) AS c FROM spip_visites_temp";
        $query = "SELECT COUNT(ip) AS total_visites FROM (SELECT DISTINCT ip from spip_visites_temp)";
		if($id_article != null) {
            $query .= " WHERE type='article' AND id_objet=$id_article";
        }
        $query = $this->_traiteQuery($query);
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisiteForAnArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyVisite = intval($row["c"]);
        }
        $result->free();
        return $howManyVisite;
    }


    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   array $row content of fetched data
     */

    function _fetchData($row) {
        SQLite_CleanName($row) ;
	BD_visite::_fetchData($row) ;
    }

    // }}}
}
?>
