<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for squel builder business persistence abstraction.
//

if (defined("_BD_SQUEL_BUILDER")) return;
define("_BD_SQUEL_BUILDER", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

/**
 * BD_squel_builder is a base class for squel builder business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_squel_builder extends BD_metier {
    // {{{ properties
    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/squel_builder_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/squel_builder_common.php");
            $classname = "BD_squel_builder_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/squel_builder_".$dbParameters->_dbEngine.".php");
            $classname = "BD_squel_builder_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_squel_builder constructor.
     *
     * @access public
     */

    function BD_squel_builder() {
    }

    // }}}
}
?>