<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Subscriber business persistence abstraction.
//
if (defined("_BD_SUBSCRIBER")) return;
    define("_BD_SUBSCRIBER", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";
require_once dirname(__FILE__)."/../../inc_meta.php3";

define("SUBSCRIBER_ALL_FIELDS", ' sub_id, sub_email, sub_first_name, sub_middle_name, sub_last_name, sub_title, sub_profile ');

/**
 * BD_newsletter is a base class for newsletter business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_subscriber extends BD_metier {

    // {{{ properties

	var $_id;
	var $_email;
	var $_firstName;
	var $_middleName;
	var $_lastName;
	var $_title;
	var $_profile;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/subscriber_common.php");
            $classname = "BD_subscriber_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_".$dbParameters->_dbEngine.".php");
            $classname = "BD_subscriber_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_subscriber constructor.
     *
     * @access public
     */

    function BD_subscriber() {
    }

    // }}}

    // {{{ getId()

    function getId() {
        return $this->_id;
    }

    // }}}

    // {{{ setId()

    function setId($id) {
        $this->_id = $id;
    }

    // }}}

    // {{{ getEmail()

    function getEmail() {
        return stripslashes($this->_email);
    }

    // }}}

    // {{{ setEmail()

    function setEmail($email) {
         $this->_email = addslashes(corriger_caracteres($email));
    }

    // }}}

    // {{{ getFirstName()

    function getFirstName() {
        return stripslashes($this->_firstName);
    }

    // }}}

    // {{{ setFirstName()

    function setFirstName($firstName) {
         $this->_firstName = addslashes(corriger_caracteres($firstName));
    }

    // }}}

    // {{{ getMiddleName()

    function getMiddleName() {
        return stripslashes($this->_middleName);
    }

    // }}}

    // {{{ setMiddleName()

    function setMiddleName($middleName) {
         $this->_middleName = addslashes(corriger_caracteres($middleName));
    }

    // }}}

    // {{{ getLastName()

    function getLastName() {
        return stripslashes($this->_lastName);
    }

    // }}}

    // {{{ setLastName()

    function setLastName($lastName) {
         $this->_lastName = addslashes(corriger_caracteres($lastName));
    }

    // }}}

    // {{{ getTitle()

    function getTitle() {
        return stripslashes($this->_title);
    }

    // }}}

    // {{{ setTitle()

    function setTitle($title) {
         $this->_title = addslashes(corriger_caracteres($title));
    }

    // }}}

    // {{{ getProfile()

    function getProfile() {
        return stripslashes($this->_profile);
    }

    // }}}

    // {{{ setProfile()

    function setProfile($profile) {
         $this->_profile = addslashes(corriger_caracteres($profile));
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $string_prefix = $GLOBALS['table_prefix']."_cm_subscribers";
        $subscriberId = $db->nextId($string_prefix, true);

        $this->_id = $subscriberId;

        $query = 'INSERT INTO '.$GLOBALS['table_prefix'].'_cm_subscribers ('.SUBSCRIBER_ALL_FIELDS.') VALUES '
                ."('".$this->_id."', "
                ."'".$this->_email."', "
            	."'".$this->_firstName."', "
            	."'".$this->_middleName."', "
            	."'".$this->_lastName."', "
                ."'".$this->_title."', "
                ."'".$this->_profile."') ";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_subscribers SET "
				."sub_email = '".$this->_email."'"
				.", sub_first_name= '".$this->_firstName."'"
            	.", sub_middle_name= '".$this->_middleName."'"
            	.", sub_last_name= '".$this->_lastName."'"
                .", sub_title= '".$this->_title."'"
                .", sub_profile= '".$this->_profile."'"
				." WHERE sub_id = ".$this->_id;

         

		//echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idSubscriber) {
        $db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".SUBSCRIBER_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id = $idSubscriber";
		//echo '<br>' . $query .  '<br>';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return $result;
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_newsletter : load($idSubscriber)] Aucun inscrit ne correspond  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($id) {
        $db = &$this->_getDB();

		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id = $id";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_newsletter : delete($i)] Aucun inscrit ne correspond  cet ID!", null,
                                    null, null, null, null, false);
        }

    }

    // }}}

    // {{{ getSubscriberForEmail($email)

    function getSubscriberForEmail($email) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : getSubscriberForEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT ".SUBSCRIBER_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_email='$email'";



         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : getSubscriberForEmail()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        } else {
        	$mySubscriber == 0;
			if ($row = $queryResult->fetchRow()) {
        		$mySubscriber = &BD_subscriber::factory($this->getDbParameters(), $this->getDbOptions());
        		$mySubscriber->_fetchData($row);
	    	}
	    	$queryResult->free();
        }
    	return $mySubscriber;
    }

    // }}}

    // {{{ isSubscribing($myNewsletter)

    function isSubscribing($myNewsletter) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : isSubscribing()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = ".$myNewsletter->getId()." AND sub_id = ".$this->_id;

         

        $nb = $db->getOne($query);

        if (DB::isError($nb)) {
			die("[".get_class($this)." BD_subscriber : isSubscribing()] ".$nb->getMessage());
        }

        if ($nb >= 1) return true;
        else return false;
    }

    // }}}

    // {{{ isPending($myNewsletter)

    function isPending($myNewsletter) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : isPending()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = ".$myNewsletter->getId()." AND sub_id = ".$this->_id;

         

        $nb = $db->getOne($query);

        if (DB::isError($nb)) {
			die("[".get_class($this)." BD_subscriber : isPending()] ".$nb->getMessage());
        }


        if ($nb == 0) return false;
        else return true;
    }

    // }}}

    // {{{ changeModeForList($myNewsletter, $mode)

    function changeModeForList($myNewsletter, $mode) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : changeModeForList()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_lists_subscribers SET lsr_mode=$mode WHERE lst_id = ".$myNewsletter->getId()." AND sub_id = ".$this->_id;

		//echo '<br>' . $query . '<br>';

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : changeModeForList()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ suspend($newsletterMetier, $action, $mode, $actionId)

    function suspend($myNewsletter, $action, $mode, $actionId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : suspend()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_pending (lst_id, sub_id, pnd_action, pnd_mode, pnd_action_date, pnd_action_id) VALUES (" . $myNewsletter->getid() . ", " . $this->getId() . ", '$action', $mode, ".time().", '$actionId')";

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : suspend()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

	// {{{ getActionForId($actionId)

    function getActionForId($actionId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : getActionForId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT lst_id, sub_id, pnd_action, pnd_mode, pnd_action_date, pnd_action_id FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE pnd_action_id='$actionId'";

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : getActionForId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        return $queryResult->fetchRow();
    }

    // }}}

	// {{{ deleteActionPending($actionId)

    function deleteActionPending($actionId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteActionPending()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE pnd_action_id='$actionId'";

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteActionPending()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

	// {{{ deleteAllPendingForSubId($sub_id)

    function deleteAllPendingForSubId($newsletter) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteAllPendingForSubId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id = ".$this->_id;

		//echo $query; 

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteAllPendingForSubId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_posts_queued WHERE id_sub = ".$this->_id;

         //echo $query.'<br />';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteAllPendingForSubId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = ".$newsletter->getId()." AND sub_id = ".$this->_id;

        //echo $query.'<br />';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : deleteAllPendingForSubId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

	// {{{ getSubscriberForLstIdAndSubId()

    function getSubscriberForLstIdAndSubId($lst_id, $sub_id) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : getSubscriberForLstIdAndSubId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = ".$lst_id." AND sub_id = ".$sub_id;

         

        $nb = $db->getOne($query);

        if (DB::isError($nb)) {
			die("[".get_class($this)." BD_subscriber : getSubscriberForLstIdAndSubId()] ".$nb->getMessage());
        }

        return $nb;
    }

    // }}}

	// {{{ getDataForLsrId($lsr_id)

    function getDataForLsrId($lsr_id) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : getDataForLsrId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT lst_id, sub_id, lsr_mode, lsr_id FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lsr_id = '".$lsr_id."'";

         

        //echo '<br>' . $query . '<br>';

        $result = $db->query($query);

        if (DB::isError($result)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : getDataForLsrId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        return $result->fetchRow();
    }

    // }}}

	// {{{ updateListSubscriberForLstIdAndSubId($pnd_mode, $pnd_action_id, $lst_id, $sub_id)

    function updateListSubscriberForLstIdAndSubId($pnd_mode, $pnd_action_id, $lst_id, $sub_id) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : updateListSubscriberForLstIdAndSubId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_lists_subscribers SET lsr_mode = ".$pnd_mode.", lsr_id = '".$pnd_action_id."' WHERE lst_id = ".$lst_id." AND sub_id = ".$sub_id;

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : updateListSubscriberForLstIdAndSubId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

	// {{{ createListSubscriber($pnd_mode, $pnd_action_id, $lst_id, $sub_id)

    function createListSubscriber($pnd_mode, $pnd_action_id, $lst_id, $sub_id) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : createListSubscriber()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_lists_subscribers (lst_id, sub_id, lsr_mode, lsr_id) VALUES (".$lst_id.", ".$sub_id.", ".$pnd_mode.", '".$pnd_action_id."')";

		//echo '<br>' . $query . '<br>';

         

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : createListSubscriber()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ getSubscribersForLstId($newsletter)

    function getSubscribersForLstId($lstId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." BD_subscriber : getSubscribersForLstId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = 'SELECT '.$GLOBALS['table_prefix'].'_cm_subscribers.sub_id, sub_email, lsr_mode FROM '.$GLOBALS['table_prefix'].'_cm_subscribers, '.$GLOBALS['table_prefix'].'_cm_lists_subscribers WHERE lst_id =' . $lstId . ' AND '.$GLOBALS['table_prefix'].'_cm_subscribers.sub_id='.$GLOBALS['table_prefix'].'_cm_lists_subscribers.sub_id';

		 

		//echo '<br> recup des inscription FRONT :   ' . $query . '<br>';

        $queryResult = $db->query($query);

		$auteurs = array();
        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_subscriber : getSubscribersForLstId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        } else {
        	while ($row = $queryResult->fetchRow()) {
        		$email = $row['sub_email'];
        		$auteurs[$email] = array(	'id_auteur' => 0,
        							'id_sub' => $row['sub_id'],
        							'email' => $row['sub_email'],
        							'mode' => $row['lsr_mode']);        		
	    	}
	    	$queryResult->free();
        }
    	return $auteurs;
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setId($row['sub_id']);
        $this->setEmail($row['sub_email']);
        $this->setFirstName($row['sub_first_name']);
        $this->setMiddleName($row['sub_middle_name']);
        $this->setLastName($row['sub_last_name']);
        $this->setTitle($row['sub_title']);
        $this->setProfile($row['sub_profile']);
    }

    // }}}

}
?>