<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for ".$GLOBALS['table_prefix']."_cm_subscribers
//

if (defined("_BD_SUBSCRIBE")) return;
    define("_BD_SUBSCRIBE", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("SUBSCRIBERS_ALL_FIELDS", "sub_id, sub_email, sub_first_name, sub_middle_name, sub_last_name, sub_title ,sub_profile");

/**
 * Gestion des membres inscrits  la NewsLetter
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */
 

 class BD_subscriber_cm extends BD_metier {
 
    /**
     * subscriber id.
     * @var    int
     * @access  private
     */
    var $_sub_id ;

    /**
     * email.
     * @var     String
     * @access  private
     */
    var $_sub_email ;

    /**
     * First name of the subscriber
     * @var     String
     * @access  private
     */
    var $_sub_first_name;

    /**
     * middle name of the subscriber
     * @var     string
     * @access  private
     */
    var $_sub_middle_name;

    /**
     * Last name of subscriber
     * @var     String
     * @access  private
     */
    var $_sub_last_name;

    /**
     * titre
     * @var     string
     * @access  private
     */
    var $_sub_title;

    /**
     * clef de validation
     * @var     int
     * @access  private
     */
    var $_sub_profile;

  /**
     * DB_article constructor.
     *
     * @access public
     */

    function bdSubscriberCm() {
    }

    // }}}

    // {{{ subscriberCm()

    function getIdNewsletter() {
        return $this->_id_newsletter;
    }

    // }}}

    // {{{ getIdNewsletter()

    function setIdNewsletter($id) {
        $this->_id_newsletter = $id;
    }

    // }}}

    // {{{ setIdNewsletter()



    function getSubId() {
        return $this->_sub_id;
    }

    // }}}

    // {{{ getSubId()

    function setSubId($id) {
        $this->_sub_id = $id;
    }

    // }}}

    // {{{ setSubId()

    function getSubEmail() {
        return $this->_sub_email;
    }

    // }}}

    // {{{ getSubEmail()

    function setSubEmail($mail) {
        $this->_sub_email = $mail;
    }

    // }}}

    // {{{ setSubEmail()
 
    function getSubFirstName() {
        return $this->_sub_first_name;
    }

    // }}}

    // {{{ getSubFirstName()

    function setSubFirstName($fname) {
        $this->_sub_first_name = $fname;
    }

    // }}}

    // {{{ setSubFirstName()

    function getSubMiddleName() {
        return $this->_sub_middle_name;
    }

    // }}}

    // {{{ getSubMiddleName()

    function setSubMiddleName($Mname) {
        $this->_sub_middle_name = $Mname;
    }

    // }}}

    // {{{ setSubMiddleName()


   function getSubLastName() {
        return $this->_sub_last_name;
    }

    // }}}

    // {{{ getSubLastName()

    function setSubLastName($Mname) {
        $this->_sub_last_name = $Mname;
    }

    // }}}

    // {{{ setSubLastName()


   function getSubTitle() {
        return $this->_sub_title;
    }

    // }}}

    // {{{ getSubTitle()

    function setSubTitle($title) {
        $this->_sub_title = $title;
    }

    // }}}

    // {{{ setSubTitle()


   function getSubProfile() {
        return $this->_sub_profile;
    }

    // }}}

    // {{{ getSubProfile()

    function setSubProfile($profile) {
        $this->_sub_profile = $profile;
    }

    // }}}

    // {{{ setSubProfile()


    //La fonction de cration d'un objet dans la table des subscriber_cm

    function create($idnewsletter=0) {
       
       //print_r($this);
       
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
         
        $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_email =  '$this->_sub_email'";
         
        $result = $db->query($query);
        //die(var_dump($result));
         if ($row = $result->fetchRow()) {
             $id_sub=$row['sub_id'];
             return($id_sub);
         }
           else{
            $string_prefix = $GLOBALS['table_prefix']."_cm_subscribers";
            if($this->_sub_id == null) $id_sub = $this->_sub_id = $db->nextId($string_prefix, true);
            if($this->_sub_email == null) $this->_sub_email = "";
            if($this->_sub_first_name == null) $this->_sub_first_name = "";
            if($this->_sub_middle_name == null) $this->_sub_middle_name = "";
            if($this->_sub_last_name == null) $this->_sub_last_name = "";
            if($this->_sub_title == null) $this->_sub_title = "";
            if($this->_sub_profile == null){
                $actionId = md5('subscribe#'.$idnewsletter.'#'.$id_sub.'#'.time());
                $this->_sub_profile = $actionId;
                }

            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_subscribers (".SUBSCRIBERS_ALL_FIELDS.") VALUES "
                     ."('".$this->_sub_id."', "
                     ."'".$this->_sub_email."', "
                     ."'".$this->_sub_first_name."', "
                     ."'".$this->_sub_middle_name."', "
                     ."'".$this->_sub_last_name."', "
                     ."'".$this->_sub_title."', "
                     ."'".$this->_sub_profile."')";
        
             
            //echo"<br />$query<br><br />";
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : create()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
                }
        }
        return($id_sub);
    }
    // }}}

    // {{{ create()
    
    //La fonction de load() de la table ".$GLOBALS['table_prefix']."_cm_subscriber vers l'objet appelant
    
    function load($sub_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id = $sub_id";

        $result = $db->query($query);
  
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                
               
        $this->_sub_id = $row['sub_id'];
        $this->_sub_email = $row['sub_email'];
        $this->_sub_first_name = $row['sub_first_name'];
        $this->_sub_middle_name = $row['sub_middle_name'];
        $this->_sub_last_name = $row['sub_last_name'];
        $this->_sub_title = $row['sub_title'];
        $this->_sub_profile = $row['sub_profile'];


            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : load($idArticle)] Aucuns utilisateurs associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        
    
    }
    
    // }}}
    // {{{ load()
    
    
    //Charge un objet dans l'objet appelant  partir de son identifiant Email
        function loadEmail($mail) {

        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : loadEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_email = '$mail'";
        
        
        
         
        $result = $db->query($query);
  
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : loadEmail()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                         
               
        $this->_sub_id = $row['sub_id'];
        $this->_sub_email = $row['sub_email'];
        $this->_sub_first_name = $row['sub_first_name'];
        $this->_sub_middle_name = $row['sub_middle_name'];
        $this->_sub_last_name = $row['sub_last_name'];
        $this->_sub_title = $row['sub_title'];
        $this->_sub_profile = $row['sub_profile'];


            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : loadEmail()] Aucuns utilisateurs associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        
    
    }
    
    // }}}
    // {{{ loadEmail()
    
    
    
    //La fonction de suppression d'un objet de la base  partir de l'objet appelant ou de l'id sub_id fournit par l'entre
    
    function delete($sub_id='') {
        if($sub_id=='')$sub_id=$this->get_sub_id();
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id = $sub_id";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
    
       // }}}

    // {{{ delete()
    
    //La fonction verif() est une fonction de suppression des subscribers dans la table ".$GLOBALS['table_prefix']."_cm_subscriber
    
    function verif(){
     $db = &$this->_getDB();
     if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : verif()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id = $sub_id";
      
     $result = $db->query($query);
     if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : verif()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
     else{
        $count=0;
         while ($row = $result->fetchRow()){
            if($this->_sub_email==$row['sub_email'])
                $count++;
            } 
        }
    return($count);
    }
    
     // }}}

    // {{{ verif()
  
     //La fonction exist_update() est une mthode qui vrifie avant d'ajouer l'objet dans la table,
     //cette mthode permet d'updater un objet au lieu de l'ajouter et d'avoir par exemple
     //une liste d'e-mail semblable
    
   //function exist_update($mail){
        
        
        
        
    //}
  // }}}

    // {{{ exist_update()
    
  
    /*function last_num(){
    
     $db = &$this->_getDB();
     if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : verif()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
    $query = "SELECT id FROM ".$GLOBALS['table_prefix']."_cm_subscribers_seq";

         
        $result = $db->query($query);
  
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_cm : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                
                $id = $row['id'];
                $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_subscribers_seq SET id=id+1";
                 
                $result = $db->query($query);
                return($id);
            }
      }   
    }*/
  

  
  
  
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_cm_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/subscriber_cm_common.php");
            $classname = "BD_subscriber_cm";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_cm_".$dbParameters->_dbEngine.".php");
            $classname = "BD_subscriber_cm_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }
        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
 }
   // }}}

    // {{{ factory()
    
    
    