<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
// $Id$
// Base class for the table  ".$GLOBALS['table_prefix']."_cm_lists_subscribers
//

if (defined("_BD_SUBSCRIBE_LINK")) return;
    define("_BD_SUBSCRIBE_LINK", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_subscriber_cm_factory.php";
require_once dirname(__FILE__)."/inc_subscriber_pending_factory.php";

define("TIMEMAX",2592000); //Nombre de seconde dans un mois
define("SUBSCRIBERS_LINK", "lst_id, sub_id, lsr_mode, lsr_id");
define("NEWSLETTER_ALL_LIST", "lst_id, lst_name, lst_comment, lst_moderation, lst_moderator_email, lst_subscribe_subject, lst_subscribe_text, lst_subject, lst_unsubscribe_subject, lst_unsubscribe_text, lst_subject_tag, lst_html_skeleton, lst_text_skeleton, lst_nb_articles");
define("SUBSCRIBERS_ALL_FIELDS", "sub_id, sub_email, sub_first_name, sub_middle_name, sub_last_name, sub_title ,sub_profile");        
define("SUBSCRIBERS_PENDING", "lst_id, sub_id, pnd_action, pnd_mode, pnd_action_date, pnd_action_id");
/**
 * Gestion des membres inscrits  la NewsLetter
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */
 

 class BD_subscriber_link extends BD_metier {
 
    /**
     * subscriber id.
     * @var    int
     * @access  private
     */
    var $_lst_id ;

    /**
     * sub_id.
     * @var     int
     * @access  private
     */
    var $_sub_id ;

    /**
     * lsr_mode
     * @var     int
     * @access  private
     */
    var $_lsr_mode;

    /**
     * lsr_id
     * @var     string
     * @access  private
     */
    var $_lsr_id;

  /**
     * DB_subscriber link constructor.
     *
     * @access public
     */
    // {{{ bdSubscriberLink
    function bdSubscriberLink() {
    }

    // }}}


    // {{{ getLstId()
    function getLstId() {
        return $this->_lst_id;
    }

    // }}}


    // {{{ setLstId()
    function setLstId($id) {
        $this->_lst_id = $id;
    }

    // }}}




    // {{{ getSubId()
    function getSubId() {
        return $this->_sub_id;
    }

    // }}}


    // {{{ setSubId()
    function setSubId($id) {
        $this->_sub_id = $id;
    }

    // }}}


    // {{{ getLsrMode()
    function getLsrMode() {
        return $this->_lsr_mode;
    }

    // }}}


    // {{{ setLsrMode()
    function setLsrMode($id) {
        $this->_lsr_mode = $id;
    }

    // }}}


     // {{{ getLsrId()
    function getLsrId() {
        return $this->_lsr_id;
    }

    // }}}


    // {{{ setLsrId()
    function setLsrId($id) {
        $this->_lsr_id = $id;
    }

    // }}}
    


    // {{{ Create()
    //Fonction de cration d'un objet dans la table ".$GLOBALS['table_prefix']."_cm_lists_subscribers

    function create() {
       
       //print_r($this);
       
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_lst_id == null) $this->_lst_id = 0;
        if($this->_sub_id == null) $this->_sub_id = 0;
        if($this->_lsr_mode == null) $this->_lsr_mode = 0;
        
          if($this->_lsr_id == null){
                $actionId = md5('subscribe#'.$id_newsletter.'#'.$id_sub.'#'.time());
                $this->_lsr_id = $actionId;
                }

         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_lists_subscribers (".SUBSCRIBERS_LINK.") VALUES "
                ."('".$this->_lst_id."', "
                ."'".$this->_sub_id."', "
                ."'".$this->_lsr_mode."', "
                ."'".$this->_lsr_id."')";
        
        //echo"<br />$query<br><br />";
        $result = $db->query($query);
         
		if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

           // {{{ load_sub() 
    //Load_sub() charge un objet de la base par son identifiant sub_id
    
    function loadSub($sub_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadSub()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
       
        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id = $sub_id";
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadSub()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_lsr_mode = $row['lsr_mode'];
                $this->_lsr_id = $row['lsr_id'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadSub($idArticle)] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }
    
    
        // }}}

    
        // {{{ load_lst()
        //load_lst() charge un objet de la base par son identifiant lst_id
    
     function loadLst($lst_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLst()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $lst_id";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLst()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_lsr_mode = $row['lsr_mode'];
                $this->_lsr_id = $row['lsr_id'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLst()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    
     // }}}
     
    
            // {{{ LoadLstSub()
        //loadLstSub() charge un objet de la base par son identifiant lst_id
    
     function loadLstSub($lst_id='', $sub_id='') {
        
       
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLstSub()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $lst_id AND sub_id=$sub_id";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLstSub()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_lsr_mode = $row['lsr_mode'];
                $this->_lsr_id = $row['lsr_id'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : loadLstSub()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    
     // }}}
     

    
    
            // {{{ deleteSub()
    //La fonction delete sub() supprimer un objet de la base par son sub_id
    //Si le sub est en entre, alors la mthode supprimer l'objet identifi par cette valeur d'entre
    //Sinon la fonction supprime l'lment associ  l'objet appelant
    
    function deleteSub($sub_id='') {
        
        if($sub_id==null){
             $sub_id=$this->get_sub_id();
        }
        //echo $sub_id." <br>".$query;
        
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteSub() by sub] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id = $sub_id";
     
     
        //echo $query;
     
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteSub() by sub] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
    
    
     // }}}
     

    
        // {{{ deleteLst()
    //La fonction delete_lst() supprimer un objet de la base par son lst_id
    //Si le sub est en entre, alors la mthode supprimer l'objet identifi par cette valeur d'entre
    //Sinon la fonction supprime l'lment associ  l'objet appelant
    
     function deleteLst($lst_id ='') {
        
        if($lst_id =='') $lst_id =$this->get_lst_id();

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteLst() by lst] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $lst_id";
     
     //echo $query;
     
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteLst() by lst] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
  
   // }}}
   
  
          // {{{ deleteUserList()
    //La fonction delete user_list fait intervenir la classe link & ".$GLOBALS['table_prefix']."_cm_lists_subscribers
    //En premier lieu, il supprime l'lment dans la table link correspondant au id lst_id & sub_id
    //Puis il verifie que l'utilisateur est inscrit  une autre list de newsletter
    //Si il ne trouve pas d'autres inscription, la mthode supprime le subscriber
  
    function deleteUserList($lst_id,$sub_id) {
  
    $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteUserList()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $lst_id AND sub_id=$sub_id";
     
    $result = $db->query($query);
    
    if (DB::isError($result)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteUserList()] ".$result->getMessage()."", null,
            null, null, null, null, false);
        }
    else{     
        $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id=$sub_id";
         
        $result = $db->query($query);
        
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteUserList()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if (!($row = $result->fetchRow())) {
                 $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id=$sub_id";
                  
                 $result = $db->query($query);
        
                if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : deleteUserList()] ".$result->getMessage()."", null,
                        null, null, null, null, false);
                } else {
                    if (!($row = $result->fetchRow())) {
                        $sub = &recuperer_instance_subscriber_cm();
                        $sub->load($sub_id);
                        $retour = $sub->getSubEmail();
                        $sub->delete($sub_id);
                        unset($sub);
                        return($retour);
                    }
                    else
                $sub = &recuperer_instance_subscriber_cm();
                $sub->load($sub_id);
                $retour = $sub->getSubEmail();
                unset($sub);
                return($retour);
                }
                
            }
            else
                $sub = &recuperer_instance_subscriber_cm();
                $sub->load($sub_id);
                $retour = $sub->getSubEmail();
                unset($sub);
                return($retour);
            }      
        }
    }
    
     // }}}

      
        // {{{ factory()  
    //Fonction factory pour l'instanciation de l'objet
    
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_link_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/subscriber_link_common.php");
            $classname = "BD_subscriber_link";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_link_".$dbParameters->_dbEngine.".php");
            $classname = "BD_subscriber_link_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
  
   // }}}

        // {{{ nbUserHtmlText()  HTML / TEXT
  //La fonction nbuser retourne le nombre de users pour une lettre id de la table link
  
  function nbUserHtmlText($id){
  
  $tabmode2 = array();
  $db = &$this->_getDB();
  if (DB::isError($db)) {
       return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : nbUser()] ".$db->getMessage()."", null,
                null, null, null, null, false);
       }
 $query = "SELECT COUNT(*) compteur, lsr_mode FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $id GROUP BY lsr_mode";
   
  $result = $db->query($query);
  if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : nbUser()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $iHtml = 0;
            $iTxt = 0;
            while ($row = $result->fetchRow()) {
                if($row['lsr_mode']==0) {
                    $iHtml = $row['compteur'];
                } else {
                    $iTxt = $row['compteur'];
                }
                
            }
        }
    $tabmode2[0]=  $iTxt;
    $tabmode2[1]=  $iHtml;
  return($tabmode2);
  }
        // }}}

    
  
  
  
       // {{{ verification()
  //Fonction de vrification si les users ne sont pas et dans pending et dans link
  //Supprimer les utilisateurs qui ne sont pas dans la tables des subscribers mais
  //dans la table des pending et des link
    
  function verification(){
  
    $db = &$this->_getDB();
    if (DB::isError($db)) {
    return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$db->getMessage()."", null,
        null, null, null, null, false);
    }
  
    $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers";
     
    $result1 = $db->query($query);
       
    if (DB::isError($result1)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result1->getMessage()."", null,
            null, null, null, null, false);
    } else {
        $i=0;
        while ($row = $result1->fetchRow()) {
            $id = $row['lst_id'];
            $sub = $row['sub_id'];     
            $sub_pend = &recuperer_instance_subscriber_pending();
            if ($sub_pend->loadLstSub($id,$sub)){
                $sub_pend->deleteLstSub($id,$sub);
                $i++;
            }
            unset($sub_pend);
        }
  
    }
        
    $result1->free();
        
    $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers";
     
    $result2 = $db->query($query);
    if (DB::isError($result2)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result2->getMessage()."", null,
            null, null, null, null, false);
    } else {
        $tab = "";
        while ($row = $result2->fetchRow()) {
            $tab[] = $row['sub_id'];
        }
    }
        
    $result2->free();
        
    $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending";
     
    $result3 = $db->query($query);
    if (DB::isError($result3)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result3->getMessage()."", null,
            null, null, null, null, false);
    } else {
        while ($row = $result3->fetchRow()) {
            $tab[] = $row['sub_id'];
        }
    }
    $result3->free();
    if($tab)  
        foreach($tab as $t){
            $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id=$t";
             
            $result4 = $db->query($query);            
            if (DB::isError($result4)) {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result4->getMessage()."", null,
                    null, null, null, null, false);
            } else {
                if(!($row = $result4->fetchRow())) { 
                    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id=$t";
                     
                    $result = $db->query($query);  
                    
                    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id=$t";
                     
                    $result = $db->query($query);
                    //$result->free();
                    $i++;
                 }
             }
        $result4->free();                
        }

      
    $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers";
     
    $result5 = $db->query($query);
    if (DB::isError($result5)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result5->getMessage()."", null,
            null, null, null, null, false);
    } else {
        $tab = "";
        while ($row = $result5->fetchRow()) {
            $tab[] = $row['sub_id'];
        }
    }  
    $result5->free();       
    if($tab){
        foreach($tab as $t){
            $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id=$t";
             
            $result6 = $db->query($query);            
            if (DB::isError($result6)) {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result6->getMessage()."", null,
                    null, null, null, null, false);
            } else {
                if(!($row = $result6->fetchRow())) {
                    $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers";
                     
                    $result7 = $db->query($query);
                    if (DB::isError($result7)) {
                        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result7->getMessage()."", null,
                            null, null, null, null, false);
                    } else {
                        if(!($row = $result7->fetchRow())) {
                            $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id=$t";
                             
                            $result = $db->query($query);
                            if (DB::isError($result)) {
                                return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result7->getMessage()."", null,
                                    null, null, null, null, false);
                            }
                             
                            $i++;                             
                        }
                        $result7->free();
                    }
                 }
            }
            $result6->free();            
        } 
    }
    
    
    $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending";
     
    //echo '<br />' . $query . '<br />';
    $result8 = $db->query($query);
    if (DB::isError($result8)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : verification()] ".$result8->getMessage()."", null,
            null, null, null, null, false);
    } else {
        while ($row=$result8->fetchRow()) {
            $tab = $row['pnd_action_date'];
            if(time()-$tab>TIMEMAX){
                $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id=".$row['sub_id']." AND lst_id=".$row['lst_id'];
                 
                $result = $db->query($query);
                $i++;
            }
        }
        $result8->free();

        return $i;
    }
    
    // }}}
    

     
  
     
       // {{{ vider()
     //La mthode vider supprimer tous les utilisateurs de la liste correspondante
     
       function vider($id){
    
      $db = &$this->_getDB();
      if (DB::isError($db)) {
           return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : vider()] ".$db->getMessage()."", null,
                    null, null, null, null, false);
           }
      $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE lst_id = $id";
       
      $result = $db->query($query);
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : vider()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
              while ($row = $result->fetchRow()){
                $this->deleteUserList($id,$row['sub_id']);
              }
            }
         }     
     }  
     
      // }}}
 }