<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>           |
// +----------------------------------------------------------------------+
//
// Base class for Document business persistence abstraction.
//

if (defined("_BD_SUBSCRIBE_PENDING")) return;
    define("_BD_SUBSCRIBE_PENDING", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/inc_subscriber_pending_factory.php";

define("SUBSCRIBERS_PENDING", "lst_id, sub_id, pnd_action, pnd_mode, pnd_action_date, pnd_action_id");
define("SUBSCRIBERS_LINK", "lst_id, sub_id, lsr_mode, lsr_id");
define("NEWSLETTER_ALL_LIST", "lst_id, lst_name, lst_comment, lst_moderation, lst_moderator_email, lst_subscribe_subject, lst_subscribe_text, lst_subject, lst_unsubscribe_subject, lst_unsubscribe_text, lst_subject_tag, lst_html_skeleton, lst_text_skeleton, lst_nb_articles");
define("SUBSCRIBERS_ALL_FIELDS", "sub_id, sub_email, sub_first_name, sub_middle_name, sub_last_name, sub_title ,sub_profile");        

/**
 * Gestion des membres en attente de validation par un mail de confirmation
  * @author  Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access  public
 */

 class BD_subscriber_pending extends BD_metier {
 
    /**
     * subscriber id.
     * @var    int
     * @access  private
     */
    var $_lst_id ;

    /**
     * sub_id.
     * @var     int
     * @access  private
     */
    var $_sub_id ;

    /**        
     * lsr_mode
     * @var     int
     * @access  private
     */
    var $_pnd_action;

    /**
     * lsr_id
     * @var     int
     * @access  private
     */
    var $_pnd_mode;

     /**
     * lsr_id
     * @var     int
     * @access  private
     */
    var $_pnd_action_date;
    
     /**
     * lsr_id
     * @var     int
     * @access  private
     */
    var $_pnd_action_id;


  /**
     * DB_subscriber pending constructor.
     *
     * @access public
     */

    function bdSubscriberPending() {
    }

    // }}}

    // {{{ bdSubscriberPending

    function getLstId() {
        return $this->_lst_id;
    }

    // }}}

    // {{{ getLstId()

    function setLstId($id) {
        $this->_lst_id = $id;
    }

    // }}}

    // {{{ setLstId()



    function getSubId() {
        return $this->_sub_id;
    }

    // }}}

    // {{{ getSubId()

    function setSubId($id) {
        $this->_sub_id = $id;
    }

    // }}}

    // {{{ setSubId()

    function getPndAction() {
        return $this->_pnd_action;
    }

    // }}}

    // {{{ getPndAction()

    function setPndAction($id) {
        $this->_pnd_action = $id;
    }

    // }}}

    // {{{ setPndAction()
 
    function getPndMode () {
        return $this->_pnd_mode ;
    }

    // }}}

    // {{{ getPndMode ()

    function setPndMode ($id) {
        $this->_pnd_mode  = $id;
    }

    // }}}
    
    // {{{ setPndMode ()


    function getPndActionDate() {
        return $this->_pnd_action;
    }

    // }}}

    // {{{ getPndActionDate()

    function setPndActionDate($id) {
        $this->_pnd_action = $id;
    }

    // }}}

    // {{{ setPndActionDate()
 
    function getPndActionId  () {
        return $this->_pnd_action_id ;
    }

    // }}}

    // {{{ getPndActionId  ()

    function setPndActionId  ($id) {
        $this->_pnd_action_id  = $id;
    }

    // }}}
    
    // {{{ setPndActionId  ()



    //Fonction de cration d'un objet dans la table ".$GLOBALS['table_prefix']."_cm_pending : les utilisateurs en attente de confirmation

    function create() {
       
       //print_r($this);
       
        $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_lst_id == null) $this->_lst_id = 0;
        if($this->_sub_id == null) $this->_sub_id = 0;
        if($this->_pnd_action == null) $this->_pnd_action = 0;
        if($this->_pnd_mode == null) $this->_pnd_mode = "";
        if($this->_pnd_action_date == null) $this->_pnd_action_date = time();
        if($this->_pnd_action_id == null) $this->_pnd_action_id = md5('subscribe#'.$idnewsletter.'#'.$id_sub.'#'.time());
       
         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_pending (".SUBSCRIBERS_PENDING.") VALUES "
                ."('".$this->_lst_id."', "
                ."'".$this->_sub_id."', "
                ."'".$this->_pnd_action."', "
                 ."'".$this->_pnd_mode."', "
                ."'".$this->_pnd_action_date."', "
                ."'".$this->_pnd_action_id."')";

          
        //echo"<br />$query<br><br />";

        $result = $db->query($query);
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}
    // {{{ Create()
    
    //LoadSub() charge un objet de la base subscriber_cm_pending par son identifiant sub_id
    
    function loadSub($sub_id='',$list_id='') {
        
        
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id = $sub_id";

         
        $result = $db->query($query);
      
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_pnd_action = $row['pnd_action'];
                $this->_pnd_mode = $row['pnd_mode'];
                $this->_pnd_action_date = $row['pnd_action_date'];
                $this->_pnd_action_id = $row['pnd_action_id'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load($idArticle)] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }
        // }}}
        // {{{ loadSub()
        
        
        //loadLst() charge un objet de ".$GLOBALS['table_prefix']."_cm_subscriber_pending de la base, par son identifiant lst_id
    
     function loadLst($lst_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }

        $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id";
         
        $result = $db->query($query);
            
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_pnd_action = $row['pnd_action'];
                $this->_pnd_mode = $row['pnd_mode'];
                $this->_pnd_action_date = $row['pnd_action_date'];
                $this->_pnd_action_id = $row['pnd_action_id'];

            } else {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending: load()] Aucuns liens associs!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }

    }
    
     // }}}
        // {{{ loadLst()
        
        
            //loadLsSubt() charge un objet de ".$GLOBALS['table_prefix']."_cm_subscriber_pending de la base, par son identifiant lst_id et SubId
    
     function loadLstSub($lst_id,$sub_id) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
            }
        $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id AND sub_id=$sub_id";
         
        $result = $db->query($query);
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_lst_id = $row['lst_id'];
                $this->_sub_id = $row['sub_id'];
                $this->_pnd_action = $row['pnd_action'];
                $this->_pnd_mode = $row['pnd_mode'];
                $this->_pnd_action_date = $row['pnd_action_date'];
                $this->_pnd_action_id = $row['pnd_action_id'];
            } else {
                return 0;
            }
            $result->free();
            return 1;
        }
    }
    
     // }}}
        // {{{ loadLst()
           

    //La fonction delete sub() supprimer un objet de la base ".$GLOBALS['table_prefix']."_cm_subscribr_cm_pending par son sub_id
    //Si le sub est en entre, alors la mthode supprimer l'objet identifi par cette valeur d'entre
    //Sinon la fonction supprime l'lment associ  l'objet appelant
    
    function deleteSub($sub_id='') {
        
        if($sub_id==null){
             $sub_id=$this->getSubId();
        }

        //echo $sub_id." <br>".$query;
        
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by sub] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id = $sub_id";
      
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by sub] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
    
    
     // }}}
        // {{{ deleteSub()
    
    //La fonction delete_lst() supprimer un objet de la base par son lst_id
    //Si le sub est en entre, alors la mthode supprimer l'objet identifi par cette valeur d'entre
    //Sinon la fonction supprime l'lment associ  l'objet appelant
    
     function deleteLst($lst_id ='') {
        
        if($lst_id =='') $lst_id =$this->get_lst_id();
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by lst] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id";
     
     //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by lst] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
  
   // }}}
   // {{{ deleteLst()
  
    
    //La fonction delete_lstSub() supprimer un objet de la base par son lst_id et son Subid

    
     function deleteLstSub($lst_id ,$sub_id) {
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by lst] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
     $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id AND sub_id=$sub_id";
     
     //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete() by lst] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
  
   // }}}
   // {{{ deleteLstSub()
  
    //La fonction delete user_list fait intervenir la classe pending & ".$GLOBALS['table_prefix']."_cm_lists_pending
    //En premier lieu, il supprime l'lment dans la table link correspondant au id lst_id & sub_id
    //Puis il verifie que l'utilisateur est inscrit  une autre list de newsletter
    //Alors la mthode supprime l'lment en cas de non trouv
  
    function deleteUserList($lst_id,$sub_id) {
  
    $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id AND sub_id=$sub_id";
     
    $result = $db->query($query);
    
    if (DB::isError($result)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$result->getMessage()."", null,
            null, null, null, null, false);
        }
    else{
         $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE sub_id=$sub_id AND lst_id = $lst_id";
         
        $result = $db->query($query);
        
         if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if (!($row = $result->fetchRow())) {

            $query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id=$sub_id";
             
            $result = $db->query($query);
            
             if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            } else {
                if (!($row = $result->fetchRow())) {
                    $sub = &recuperer_instance_subscriber_cm();
                    $sub->load($sub_id);
                    $retour = $sub->getSubEmail();
                    $sub->delete($sub_id);
                    unset($sub);
                    return($retour);
                    }
                   
                }      
            }
         }
    }
    $sub = &recuperer_instance_subscriber_cm();
    $sub->load($sub_id);
    $retour = $sub->getSubEmail();
    unset($sub);
    return($retour);
    }
    
    // }}}
    // {{{ deleteUserList()
    
    
    
    //La fonction deleteUserAction supprime un utilisateur dans la base a partir de son actionID
    
  
    function deleteUserAction($lst_id,$action_id) {
  
    $db = &$this->_getDB();
    if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $lst_id AND pnd_action_id =$action_id";
     
    $result = $db->query($query);
    
    if (DB::isError($result)) {
        return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$result->getMessage()."", null,
            null, null, null, null, false);
        }
    else{     
        //$query = "SELECT ".SUBSCRIBERS_LINK." FROM ".$GLOBALS['table_prefix']."_cm_lists_subscribers WHERE sub_id=$sub_id";
        // 
      //  $result = $db->query($query);
        
      //   if (DB::isError($result)) {
         //   return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : delete_user()] ".$result->getMessage()."", null,
       //         null, null, null, null, false);
     //   } else {
   //         if (!($row = $result->fetchRow())) {
              //  $sub = &recuperer_instance_subscriber_cm();
            //    $sub->load($sub_id);
          //      $retour = $sub->getSubEmail();
        //        $sub->delete($sub_id);
        //        unset($sub);
        //        return($retour);
        //        }
        //    else
        //        $sub = &recuperer_instance_subscriber_cm();
        //        $sub->load($sub_id);
        //        $retour = $sub->getSubEmail();
        //        unset($sub);
         //       return($retour);
        //    }      
        }
        
    }
    
    // }}}
    // {{{ deleteUserList()
    
    
    //Fonction factory pour l'instanciation de l'objet
    
     function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_pending_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/subscriber_pending_common.php");
            $classname = "BD_subscriber_pending";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/subscriber_pending_".$dbParameters->_dbEngine.".php");
            $classname = "BD_subscriber_pending_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }
  
  // }}}
  // {{{ factory()
  
  //fonction de listage des utilisateurs appartenant  la newsletter ayant l'id spcifi en entre
  //La mthode retourne un tableau contenant la liste des identifiants sub_id concern par la newsletter, et non inscrits
  
  // Ajout Olivier Mansour 
  // 2 argument pour ne rappatrier par dfaut que les personnes en attente d'inscription
  
  function listeUser($id, $id_action = 'subscribe'){

       $this->loadLst($id); 
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : liste_user()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        if ($id_action == '') {
            $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id";
        } else {
            $query =  "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id AND pnd_action = '".$id_action."'";
        }
         
        $result = $db->query($query);
        
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : liste_user()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } 
      else {

            while ($row = $result->fetchRow()){
                $tab_user[]=$row['sub_id'];
            }
            $i=0;
           
            while($tab_user[$i]){
                $query = "SELECT ".SUBSCRIBERS_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_cm_subscribers WHERE sub_id =".$tab_user[$i++];
                
                 
                $result = $db->query($query);   
                
                 if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : liste_user()] ".$result->getMessage()."", null,
                            null, null, null, null, false);
                            } 
                 else {
                    
                    while ($row = $result->fetchRow()){
                        $tab_subscriber[]=$row['sub_id'];
                         //die(var_dump($tab_subscriber));
                        //die("ahahaha");
                        //echo $row['sub_email'];
                        //$num = $row['sub_id'];
                        //$name = $row['sub_email'];
                        //echo "<td><a href='$page?suppress=$num&id_newsletter=$id'><img src='../suppress.gif' height='10' width='10' alt='supprimer $name'></a></td>";
                        //echo "</tr>";                        
                        } 
                  }
             }

          //die(var_dump($tab_user));
          return($tab_subscriber); 
         }
     }
     // }}}
     // {{{ listeUser()


  //La fonction nbuser retourne le nombre de users pour une lettre id
  
  // Ajout Olivier Mansour 
  // 2 argument pour ne rappatrier par dfaut que les personnes en attente d'inscription
  
  function nbUser($id, $id_action = 'subscribe') {
  
  $db = &$this->_getDB();
  if (DB::isError($db)) {
       return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : liste_user()] ".$db->getMessage()."", null,
                null, null, null, null, false);
       }
  if ($id_action == '') {
    $query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id";
  } else {
    $query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id AND pnd_action = '".$id_action."'";
  }
   
  $result = $db->query($query);
  if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
  } else {  // correction Olivier Mansour
    $count=0;
    if ($row = $result->fetchRow()) {
        $count = intval($row["cnt"]);
    }
  }
  return($count);
  }
  
       // }}}
     // {{{ nbUser()
  
 
         // {{{ nbUserHtmlText()  HTML / TEXT
  //La fonction nbuser retourne le nombre de users pour une lettre id de la table pending
  
  function nbUserHtmlText($id){
  
  $db = &$this->_getDB();
  if (DB::isError($db)) {
       return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : nbUser()] ".$db->getMessage()."", null,
                null, null, null, null, false);
       }
  $query = "SELECT COUNT(*) compteur, pnd_mode FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id GROUP BY pnd_mode ";
   
   //echo $query;
   
  $result = $db->query($query);
  if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_link : nbUser()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $iHtml = 0;
            $iTxt = 0;
            while ($row = $result->fetchRow()) {
                if($row['lsr_mode']==0) {
                    $iHtml = $row['compteur'];
                } else {
                    $iTxt = $row['compteur'];
                }
                
            }
        }
    $tabmode2[0]=  $iTxt;
    $tabmode2[1]=  $iHtml;
  return($tabmode2);
  }
        // }}}
 
 
 
  
   //La mthode vider supprimer tous les utilisateurs de la liste correspondante
  
  function vider($id){
    
      $db = &$this->_getDB();
      if (DB::isError($db)) {
           return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : vider()] ".$db->getMessage()."", null,
                    null, null, null, null, false);
           }
      $query = "SELECT ".SUBSCRIBERS_PENDING." FROM ".$GLOBALS['table_prefix']."_cm_pending WHERE lst_id = $id";
       
      $result = $db->query($query);
      if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_subscriber_pending : vider()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
              while ($row = $result->fetchRow()){
                
                //$sub = &recuperer_instance_subscriber_cm();
                //$sub->load($row['sub_id']);
                //$sub->delete($row['sub_id']);
                //unset($sub);
                $this->deleteUserList($id,$row['sub_id']);
              }
         }     
    }
     // }}}
     // {{{ vider()
     
    
}
 
  