<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>  ha ben bravo ! |
// +----------------------------------------------------------------------+
//
// Base class for Syndic business persistence abstraction.
//

if (defined("_BD_SYNDIC")) return;
    define("_BD_SYNDIC", "1");

require_once dirname(__FILE__)."/metier.php";

define("SYNDIC_ALL_FIELDS", " id_syndic, id_rubrique, id_secteur, nom_site, url_site, url_syndic, descriptif, maj, syndication, statut, date_heure, date_syndic, date_index, moderation ");

/**
 * BD_syndic is a base class for syndic business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_syndic extends BD_metier {

    // {{{ properties

    /**
     * Syndication ID.
     * @var     int
     * @access  private
     */
    var $_syndicId;

    /**
     * Heading ID.
     * @var     int
     * @access  private
     */
    var $_rubriqueId;

    /**
     * Sector ID .
     * @var     int
     * @access  private
     */
    var $_secteurId;

    /**
     * Site Name.
     * @var     String
     * @access  private
     */
    var $_nomSite;

    /**
     * Site Url.
     * @var     String
     * @access  private
     */
    var $_urlSite;

    /**
     * Syndication URL.
     * @var     String
     * @access  private
     */
    var $_urlSyndic;

    /**
     * Description.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    /**
     * Update Date.
     * @var     Date
     * @access  private
     */
    var $_majDate;

    /**
     * Syndication.
     * @var     String
     * @access  private
     */
    var $_syndication;

    // }}}

    /**
     * Statut.
     * @var     String
     * @access  private
     */
    var $_statut;

    /**
     * _statutsHisto
     * historique des statuts pour cet instance d'objet
     * @access private
     * @var Array 
     **/
    var $_statutsHisto = array ();

    /**
     * Date.
     * @var     Date
     * @access  private
     */
    var $_date;

    /**
     * Syndication Date.
     * @var     Date
     * @access  private
     */
    var $_dateSyndic;

    /**
     * Index Date.
     * @var     Date
     * @access  private
     */
    var $_dateIndex;

    /**
     * Moderation.
     * @var     String
     * @access  private
     */
    var $_moderation;

    /**
    * _rubriqueIdsHisto
    * historique des rubriques pour cet instance d'objet
    * @access private
    * @var Array 
    **/
    var $_rubriqueIdsHisto = array ();



    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Syndic business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndic_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/syndic_common.php");
            $classname = "BD_syndic_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndic_".$dbParameters->_dbEngine.".php");
            $classname = "BD_syndic_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_syndic constructor.
     *
     * @access public
     */

    function BD_syndic() {
    }

    // }}}

    // {{{ getSyndicId()

    /**
     * Returns the Syndication ID
     * @return  int
     * @access  public
     */

    function getSyndicId() {
        return $this->_syndicId;
    }

    // }}}

    // {{{ setSyndicId()

    /**
     * Sets the Syndication ID
     * @param   int
     * @access  public
     */

    function setSyndicid($syndicId) {
        $this->_syndicId = $syndicId;
    }

    // }}}

    // {{{ getRubriqueID()

    /**
     * Returns the heading ID
     * @return  int
     * @access  public
     */

    function getRubriqueID() {
        return $this->_rubriqueId;
    }

    // }}}

        

    // {{{ setRubriqueId()

    /**
     * Sets the heading ID
     * @param   int
     * @access  public
     */

    function setRubriqueId($rubriqueId) {
        if (isset($this->_rubriqueId) and ($this->_rubriqueId != $rubriqueId) ) {
            // on sauvegarde cette rubrique
            $this->_rubriqueIdsHisto[] = $this->_rubriqueId;
        }
        $this->_rubriqueId = $rubriqueId;
    }

    // }}}

    // {{{ getRubriqueIdsHisto

    function getRubriqueIdsHisto() {
        return $this->_rubriqueIdsHisto;
    }

    // }}}


    // {{{ getSecteurId()

    /**
     * Returns the sector ID
     * @return  int
     * @access  public
     */

    function getSecteurID() {
        return $this->_secteurId;
    }

    // }}}

    // {{{ setSecteurId()

    /**
     * Sets the sector ID
     * @param   int
     * @access  public
     */

    function setSecteurId($secteurId) {
        $this->_secteurId = $secteurId;
    }

    // }}}

    // {{{ getNomSite()

    /**
     * Returns the Site Name
     * @return  String
     * @access  public
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}

    // {{{ setNomSite()

    /**
     * Sets the Site Name
     * @param   String
     * @access  public
     */

    function setNomSite($nomSite) {
        $this->_nomSite = $this->corriger_caracteres($nomSite);
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * Returns Site URL
     * @return  String
     * @access  public
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}

    // {{{ setUrlSite()

    /**
     * Sets Site URL
     * @param   String
     * @access  public
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = $this->corriger_caracteres($urlSite);
    }

    // }}}

    // {{{ getUrlSyndic()

    /**
     * Returns Syndication URL
     * @return  String
     * @access  public
     */

    function getUrlSyndic() {
        return $this->_urlSyndic;
    }

    // }}}

    // {{{ setUrlSyndic()

    /**
     * Sets Syndication URL
     * @param   String
     * @access  public
     */

    function setUrlSyndic($urlSyndic) {
        $this->_urlSyndic = $this->corriger_caracteres($urlSyndic);
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns description
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets description
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the syndication update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the syndication update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ getSyndication()

    /**
     * Returns syndication
     * @return  String
     * @access  public
     */

    function getSyndication() {
        return $this->_syndication;
    }

    // }}}

    // {{{ setSyndication()

    /**
     * Sets syndication
     * @param   String
     * @access  public
     */

    function setSyndication($syndication) {
        $this->_syndication = $this->corriger_caracteres($syndication);
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns statut
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets statut
     * @param   String
     * @access  public
     */
    function setStatut($statut) {
        if (isset($this->_statut) and ($statut != $this->_statut)) {
            // on sauvegarde ce statut
            $this->_statutsHisto[] = $this->_statut;
        }
        $this->_statut = $this->corriger_caracteres($statut);
    }

    // }}}

    // {{{ getDate()

    /**
     * Returns the date ????
     * @return  Date
     * @access  public
     */

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    /**
     * Sets the date ????
     * @param   Date
     * @access  public
     */

    function setDate($date) {
        $this->_date = $date;
    }

    // }}}

    // {{{ getDateSyndic()

    /**
     * Returns Syndication date
     * @return  Date
     * @access  public
     */

    function getDateSyndic() {
        return $this->_dateSyndic;
    }

    // }}}

    // {{{ setDateSyndic()

    /**
     * Sets Syndication date
     * @param   Date
     * @access  public
     */

    function setDateSyndic($dateSyndic) {
        $this->_dateSyndic = $dateSyndic;
    }

    // }}}

    // {{{ getDateIndex()

    /**
     * Returns Index date
     * @return  Date
     * @access  public
     */

    function getDateIndex() {
        return $this->_dateIndex;
    }

    // }}}

    // {{{ setDateIndex()

    /**
     * Sets Index date
     * @param   Date
     * @access  public
     */

    function setDateIndex($dateIndex) {
        $this->_dateIndex = $dateIndex;
    }

    // }}}

    // {{{ getModeration()

    /**
     * Returns moderation
     * @return  String
     * @access  public
     */

    function getModeration() {
        return $this->_moderation;
    }

    // }}}

    // {{{ setModeration()

    /**
     * Sets moderation
     * @param   String
     * @access  public
     */

    function setModeration($moderation) {
        $this->_moderation = $this->corriger_caracteres($moderation);
    }

    // }}}

    // {{{ create()

    /**
     * This method is used to create a new syndication in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $string_prefix =$GLOBALS['table_prefix']."_syndic";
        $syndicId = $db->nextId($string_prefix, true);
        if (DB::isError($syndicId)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : create()] ".$syndicId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_syndicId = $syndicId;

        //if ($this->_date == "NOW()") $date = "NOW()"; else $date = "'".$db->quoteString($this->_date)."'";
        //if ($this->_dateSyndic == "NOW()") $dateSyndic = "NOW()"; else $dateSyndic = "'".$db->quoteString($this->_dateSyndic)."'";

        $maDate = new Date();
        $isoDate = $maDate->getDate(DATE_FORMAT_ISO);
	    $this->setDate($isoDate);
        $this->setDateSyndic($isoDate);
        
        // calcul du secteur ... 
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->_rubriqueId);
        $this->_secteurId = $rubriqueMetier->findSectorId();

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_syndic (".SYNDIC_ALL_FIELDS.") VALUES ("
                ."".$this->_syndicId.", "
                ."".$this->_rubriqueId.", "
                ."".$this->_secteurId.", "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_urlSyndic)."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_majDate)."', "
                ."'".$db->quoteString($this->_syndication)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_date)."', "
                ."'".$db->quoteString($this->_dateSyndic)."', "
                ."'".$db->quoteString($this->_dateIndex)."', "
                ."'".$db->quoteString($this->_moderation)."')";

        //echo "<br>".$this->_nomSite."<br>";
         

        
        //echo $query."<br>";
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        if ($this->getStatut()=='publie') { // il faut mettre  jour la rubrique
            $rubriqueMetier = &recuperer_instance_rubrique();
            $rubriqueMetier->load($this->getRubriqueID());
            $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueID());
            if ($statut != $rubriqueMetier->getStatut()) {
                $rubriqueMetier->setStatut($statut);
                $rubriqueMetier->update();
            }
            // on remet aussi la date  jour
            $dateCalcul = $rubriqueMetier->getDateFromRubrique($rubriqueMetier->getRubriqueID());
            $dateRubrique = new Date ($rubriqueMetier->getDate());
            if (Date::compare($dateCalcul, $dateRubrique) != 0) {
                $rubriqueMetier->setDate($dateCalcul->getDate());
                $rubriqueMetier->update(); // va enclencher la recursivite
                $update_date = true;
            }

            unset ($rubriqueMetier);

        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update a syndication in the database
     * @access public
     */
    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));
        
        // calcul du secteur ...  chaque fois 
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->_rubriqueId);
        $this->_secteurId = $rubriqueMetier->findSectorId();

        $query = "UPDATE ".$GLOBALS['table_prefix']."_syndic "
                ."SET id_syndic = ".$this->_syndicId.", "
                ."id_rubrique = ".$this->_rubriqueId.", id_secteur = ".$this->_secteurId.", "
                ."nom_site = '".$db->quoteString($this->_nomSite)."', url_site = '".$db->quoteString($this->_urlSite)."', "
                ."url_syndic = '".$db->quoteString($this->_urlSyndic)."', descriptif = '".$db->quoteString($this->_descriptif)."', "
                ."maj = '".$db->quoteString($this->_majDate)."', syndication = '".$db->quoteString($this->_syndication)."', "
                ."statut = '".$db->quoteString($this->_statut)."', date_heure = '".$db->quoteString($this->_date)."', "
                ."date_syndic = '".$db->quoteString($this->_dateSyndic)."', date_index = '".$db->quoteString($this->_dateIndex)."', "
                ."moderation = '".$db->quoteString($this->_moderation)."' "
                ."WHERE id_syndic = ".$this->_syndicId;
        //echo $query."<br>";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Mise  jour des rubriques lies
        $this->updateRelatedObjects();
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load a syndication from the database
     * @access  public
     * @param   int $syndicId ID of syndication to load
     */

    function load($idSyndic) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SYNDIC_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_syndic = $idSyndic";

        //echo "<br>" . $query . "<br>";

         



        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_syndic : load($idSyndic)] Aucune syndication ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete a syndication from the database
     * @access  public
     * @param   int $id_syndic ID of syndication to delete
     */

    function delete($idSyndic) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_syndic = $idSyndic";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // mise a jour des statuts et des dates
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->getRubriqueID());
        $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueID());
        if ($statut != $rubriqueMetier->getStatut()) {
            $rubriqueMetier->setStatut($statut);
            $rubriqueMetier->update();
        }
        $rubriqueMetier->load($this->getRubriqueID());
        $dateCalcul = $rubriqueMetier->getDateFromRubrique($rubriqueMetier->getRubriqueID());
        $dateRubrique = new Date ($rubriqueMetier->getDate());
        if (Date::compare($dateCalcul, $dateRubrique) != 0) {
            $rubriqueMetier->setDate($dateCalcul->getDate());
            $rubriqueMetier->update();
        }  
        unset ($rubriqueMetier);
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setSyndicId($row['id_syndic']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setSecteurId($row['id_secteur']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setUrlSyndic($row['url_syndic']);
        $this->setDescriptif($row['descriptif']);
        $this->setMajDate($row['maj']);
        $this->setSyndication($row['syndication']);
        $this->setStatut($row['statut']);
        $this->setDate($row['date_heure']);
        $this->setDateSyndic($row['date_syndic']);
        $this->setDateIndex($row['date_index']);
        $this->setModeration($row['moderation']);
    }

    // }}}

    // {{{ deleteMajDateAndStatut($myDate, $statut = null)

    /**
     * This method is used to delete the update date and the statut of syndication
     * @access  public
     * @param   Date $myDate
     * @param   String $statut
     */

    function deleteMajDateAndStatut($myDate, $statut = null) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : deleteMajDateAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_syndic WHERE maj < '$myDate'";
        if($statut != null) $query .= " AND statut = '$statut'";
         
        //echo '<br><br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : deleteMajDateAndStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllSyndicIds()

    /**
     * This method is used to get all syndication ID
     * @access  public
     */

    function getAllSyndicIds() {
        $syndicIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_syndic FROM ".$GLOBALS['table_prefix']."_syndic";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $syndicIds[] = $row['id_syndic'];}
        $result->free();
        return $syndicIds;
    }

    // }}}

    // {{{ getAllSyndicIdsForStatut($statut)

    /**
     * This method is used to get all syndication ID
     * @access  public
     */

    function getAllSyndicIdsForStatut($statut) {
        $syndicIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicIdsForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_syndic FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut='$statut'";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicIdsForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {    $syndicIds[] = $row['id_syndic'];}
        $result->free();
        return $syndicIds;
    }

    // }}}

    // {{{ getMaxDateHeure($id_rubrique,$statut)

    function getMaxDateHeure($id_rubrique,$statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getMaxDateHeure()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_rubrique='$id_rubrique' AND statut='" . $statut . "'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getMaxDateHeure()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $result->free();
            if ($row["date_h"] == null) {
                return new Date('1970-01-01 00:00:00');
            }
            else {
                return new Date($row["date_h"]);
            }
        }
        $result->free();        
    }

    // }}}

    // {{{ getRubriqueIDsByStatus($statut)

    /**
     * This method is used to get heading ID in the table of syndication for a specific statut
     * @access  public
     * @param   String $statut
     */

    function getRubriqueIDsByStatus($statut) {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getRubriqueIDsByStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut = '$statut'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getRubriqueIDsByStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ howManySyndicIdForStatut($statut)

    /**
     * This method is used to count syndication ID for a specific statut
     * @access  public
     * @param   String $statut
     */

    function howManySyndicIdForStatut($statut)    {
        $howManySyndicId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : howManySyndicIdForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(id_syndic) as cnt FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut='$statut'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : howManySyndicIdForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManySyndicId = intval($row["cnt"]);
        }
        $result->free();
        return $howManySyndicId;
    }

    // }}}

    // {{{ howManySyndicIdForSyndication($syndic)

    /**
     * This method is used to count syndication ID for a specific syndication
     * @access  public
     * @param   String $syndication
     */

    function howManySyndicIdForSyndication($syndic)    {
        $howManySyndicId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : howManySyndicIdForSyndication()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(id_syndic) as cnt FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication='$syndic'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : howManySyndicIdForSyndication()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManySyndicId = intval($row["cnt"]);
        }
        $result->free();
        return $howManySyndicId;
    }

    // }}}

    // {{{ updateSecteursForRubriques()

    /**
     * This method is used to update sector ID for a specific heading ID
     * @access  public
     * @param   int $id_secteur
     * @param   int $rubriques_totales
     */

    function updateSecteursForRubriques($id_secteur,$rubriques_totales) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : updateSecteursForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_syndic SET id_secteur=$id_secteur WHERE id_rubrique IN ($rubriques_totales)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : updateSecteursForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // }}}

    // {{{ getSyndicIdsForStatutAndDateIndex($statut)

    /**
     * Returns an array of Syndic IDS.
     *
     * @return Array of SyndicsIds
     * @param $month
     * @param $year
     * @access public
     */

    function &getSyndicIdsForStatutAndDateIndex($statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicIdsForStatutAndDateIndex()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
        $maDate->subtractSeconds(intval(3600*24*7));

        $query = "SELECT id_syndic FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut='$statut' AND date_index < '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_index";
         
        $queryResult = $db->limitQuery($query,0,1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicIdsForStatutAndDateIndex()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $result[] = $row['id_syndic'];
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForSyndicationAndStatutAndIntervalHour($syndication, $statut, $hour)

    /**
     * Returns an array of Syndication.
     *
     *
     * @return Array of Syndication
     * @param $syndication
     * @param $statut
     * @param $hour
     * @access public
     */

    function &getAllForSyndicationAndStatutAndIntervalHour($syndication, $statut, $hour) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForSyndicationAndStatutAndIntervalHour()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $maDate = new Date();
        $maDate->subtractSeconds(intval(3600*$hour));

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication='$syndication' AND statut='$statut' AND date_syndic < '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
        //$query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication='$syndication' AND statut='$statut' AND date_syndic < DATE_SUB(NOW(), INTERVAL $hour HOUR) ORDER BY date_syndic LIMIT 0,1";
         
        //echo "<br>$query<br>";


        $queryResult = $db->limitQuery($query, 0 ,1);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForSyndicationAndStatutAndIntervalHour()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSyndic->setSyndicId($row['id_syndic']);
            $resultSyndic->setRubriqueId($row['id_rubrique']);
            $resultSyndic->setSecteurId($row['id_secteur']);
            $resultSyndic->setNomSite($row['nom_site']);
            $resultSyndic->setUrlSite($row['url_site']);
            $resultSyndic->setUrlSyndic($row['url_syndic']);
            $resultSyndic->setDescriptif($row['descriptif']);
            $resultSyndic->setMajDate($row['maj']);
            $resultSyndic->setSyndication($row['syndication']);
            $resultSyndic->setStatut($row['statut']);
            $resultSyndic->setDate($row['date_heure']);
            $resultSyndic->setDateSyndic($row['date_syndic']);
            $resultSyndic->setDateIndex($row['date_index']);
            $resultSyndic->setModeration($row['moderation']);
            $result[] = &$resultSyndic;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllSyndicForSyndicIdAndsyndication($id_syndic)

    /**
     * Returns an array of Syndication.
     *
     *
     * @return Array of Syndication
     * @param $id_syndic
     * @access public
     */

    function &getAllSyndicForSyndicIdAndsyndication($id_syndic) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicForSyndicIdAndsyndication()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_syndic=$id_syndic AND syndication='oui' OR syndication='sus' OR syndication='off'";
         
        //echo "<br>$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndicForSyndicIdAndsyndication()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSyndic->setSyndicId($row['id_syndic']);
            $resultSyndic->setRubriqueId($row['id_rubrique']);
            $resultSyndic->setSecteurId($row['id_secteur']);
            $resultSyndic->setNomSite($row['nom_site']);
            $resultSyndic->setUrlSite($row['url_site']);
            $resultSyndic->setUrlSyndic($row['url_syndic']);
            $resultSyndic->setDescriptif($row['descriptif']);
            $resultSyndic->setMajDate($row['maj']);
            $resultSyndic->setSyndication($row['syndication']);
            $resultSyndic->setStatut($row['statut']);
            $resultSyndic->setDate($row['date_heure']);
            $resultSyndic->setDateSyndic($row['date_syndic']);
            $resultSyndic->setDateIndex($row['date_index']);
            $resultSyndic->setModeration($row['moderation']);
            $result[] = &$resultSyndic;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ unlinkAllExceptsyndicIds($syndicId)

    /**
     * This method is used to delete all the syndicated articles exceptfor a specific syndication ID
     * @access  public
     * @param   int $syndicId ID of syndication to delete
     */

    function unlinkAllExceptsyndicIds($syndicId) {
        if ( (is_null($syndicId)) or ($syndicId <= 0 )) return; 
    
    
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : unlinkAllExceptsyndicIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic NOT IN (0,$syndicId)";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : unlinkAllExceptsyndicIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

	    $query = "DELETE FROM ".$GLOBALS['table_prefix']."_mots_syndic WHERE id_syndic NOT IN ($syndicId)";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : unlinkAllExceptsyndicIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_forum WHERE id_syndic NOT IN (0,$syndicId)";
         
        //echo '<br>' . $query . '<br>';
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : unlinkAllExceptsyndicIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Syndic.
     *
     * @return Array of Syndic
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut) {
        $syndics = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut='$statut'";

         
        //echo "<br><br>$query<br><br>";
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultSyndic->_fetchData($row);
            $syndics[] = &$resultSyndic;
        }
        $queryResult->free();
        return $syndics;
    }

    // }}}
    
    // {{{ howManySiteForMot($conf_mot, $aff_articles, $statut)

    function howManySiteForMot($conf_mot, $aff_articles, $statut)    {
        $howManySite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_site : howManySiteForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_syndic lien, ".$GLOBALS['table_prefix']."_syndic syndic WHERE lien.id_mot=$conf_mot AND syndic.id_syndic=lien.id_syndic	AND syndic.statut LIKE '$aff_articles' AND syndic.statut!='$statut'";
		
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_site : howManySiteForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $$howManySite = intval($row["cnt"]);
        }
        $result->free();
        return $howManySite;
    }
    // }}}    
    
    // {{{ getAllSyndics()
    
    function &getAllSyndics() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndics()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic";
         
        //echo "<br>$query<br>";


        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getAllSyndics()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());
            $resultSyndic->setSyndicId($row['id_syndic']);
            $resultSyndic->setRubriqueId($row['id_rubrique']);
            $resultSyndic->setSecteurId($row['id_secteur']);
            $resultSyndic->setNomSite($row['nom_site']);
            $resultSyndic->setUrlSite($row['url_site']);
            $resultSyndic->setUrlSyndic($row['url_syndic']);
            $resultSyndic->setDescriptif($row['descriptif']);
            $resultSyndic->setMajDate($row['maj']);
            $resultSyndic->setSyndication($row['syndication']);
            $resultSyndic->setStatut($row['statut']);
            $resultSyndic->setDate($row['date_heure']);
            $resultSyndic->setDateSyndic($row['date_syndic']);
            $resultSyndic->setDateIndex($row['date_index']);
            $resultSyndic->setModeration($row['moderation']);
            $result[] = &$resultSyndic;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getSyndicsForRubriqueIdAndStatut($rubriqueId, $statut, $orderBy)

    /**
     * Returns an array of Syndic.
     *
     * @return Array of Syndic
     * @param $rubriqueId
     * @param $statut
     * @param $orderBy
     * @access public
     */

    function &getSyndicsForRubriqueIdAndStatut($rubriqueId, $statut, $orderBy) {
        $syndics = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicsForRubriqueIdAndStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . SYNDIC_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_rubrique=$rubriqueId AND statut!='$statut'";

        if ($orderBy != null)   $query .= " ORDER BY $orderBy";
        
        
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic : getSyndicsForRubriqueIdAndStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultSyndic = &BD_syndic::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultSyndic->_fetchData($row);
            $syndics[] = &$resultSyndic;
        }
        $queryResult->free();
        return $syndics;
    }

    // }}}    
    
}
?>