<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Julien Guillot <jguillot@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Syndic Articles business persistence abstraction.
//

if (defined("_BD_SYNDIC_ARTICLES")) return;
    define("_BD_SYNDIC_ARTICLES", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("SYNDIC_ARTICLES_ALL_FIELDS", " id_syndic_article, id_syndic, titre, url, date_heure, lesauteurs, maj, statut, descriptif ");

/**
 * BD_syndic_articles is a base class for syndic articles business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_syndic_articles extends BD_metier {

    // {{{ properties

    /**
     * Syndicated Article ID.
     * @var     int
     * @access  private
     */
    var $_syndicArticleId;

    /**
     * Syndication ID.
     * @var     int
     * @access  private
     */
    var $_syndicId;

    /**
     * Title of syndicated article.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Url of syndicated article.
     * @var     String
     * @access  private
     */
    var $_url;

    /**
     * Date of syndication.
     * @var     Date
     * @access  private
     */
    var $_date;

    /**
     * The authors of the syndicated article.
     * @var     String
     * @access  private
     */
    var $_lesAuteurs;

    /**
     * the syndicated article update date.
     * @var     Date
     * @access  private
     */
    var $_maj;

    /**
     * Statut of the syndicated article.
     * @var     String
     * @access  private
     */
    var $_statut;

    /**
     * Description of the syndicated article.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    // }}}


    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Syndic business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndic_articles_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/syndic_articles_common.php");
            $classname = "BD_syndic_articles_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndic_articles_".$dbParameters->_dbEngine.".php");
            $classname = "BD_syndic_articles_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_syndic_articles constructor.
     *
     * @access public
     */

    function BD_syndic_articles() {
    }

    // }}}

    // {{{ getSyndicArticleId()

    /**
     * Returns the Syndic Article ID
     * @return  int
     * @access  public
     */

    function getSyndicArticleId() {
        return $this->_syndicArticleId;
    }

    // }}}

    // {{{ setSyndicArticleId()

    /**
     * Sets the Syndic Article ID
     * @param   int
     * @access  public
     */

    function setSyndicArticleid($syndicArticleId) {
        $this->_syndicArticleId = $syndicArticleId;
    }

    /**
     * Returns the Syndic ID
     * @param   int
     * @access  public
     */

    function getSyndicid($syndicId) {
        $this->_syndicId = $syndicId;
    }

    /**
     * Sets the Syndic ID
     * @param   int
     * @access  public
     */

    function setSyndicid($syndicId) {
        $this->_syndicId = $syndicId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the title of the syndic article
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the title of the syndic article
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}

    // {{{ getUrl()

    /**
     * Returns url of the syndicated article
     * @return  String
     * @access  public
     */

    function getUrl() {
        return $this->_url;
    }

    // }}}

    // {{{ setUrl()

    /**
     * Sets url of the syndicated article
     * @param   String
     * @access  public
     */

    function setUrl($url) {
        $this->_url = corriger_caracteres($url);
    }

    // }}}

    // {{{ getDate()

    /**
     * Returns the date of syndication
     * @return  Date
     * @access  public
     */

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    /**
     * Sets the date of syndication
     * @param   Date
     * @access  public
     */

    function setDate($date) {
        $this->_date = $date;
    }

    // }}}

    // {{{ getLesAuteurs()

    /**
     * Returns the authors of the syndicated article
     * @return  String
     * @access  public
     */

    function getLesAuteurs() {
        return $this->_lesAuteurs;
    }

    // }}}

    // {{{ setLesAuteurs()

    /**
     * Sets the authors of the syndicated article
     * @param   String
     * @access  public
     */

    function setLesAuteurs($lesAuteurs) {
        $this->_lesAuteurs = corriger_caracteres($lesAuteurs);
    }

    // }}}

    // {{{ getMaj()

    /**
     * Returns the syndicated article update date
     * @return  Date
     * @access  public
     */

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    /**
     * Sets the syndicated article update date
     * @param   Date
     * @access  public
     */

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns statut of the syndicated article
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets statut of the syndicated article
     * @param   String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = corriger_caracteres($statut);
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns the description of the syndicated article
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets the description of the syndicated article
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = corriger_caracteres($descriptif);
    }

    // }}}



    // {{{ create()

    /**
     * This method is used to create a new syndicated article in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $string_prefix = $GLOBALS['table_prefix']."_syndic_articles";
        $syndicArticleId = $db->nextId($string_prefix, true);
        if (DB::isError($syndicArticleId)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : create()] ".$syndicArticleId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_syndicArticleId = $syndicArticleId;

        //if ($this->_date == "NOW()") $date = "NOW()"; else $date = "'".$db->quoteString($this->_date)."'";

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_syndic_articles (".SYNDIC_ARTICLES_ALL_FIELDS.") VALUES ("
                ."".$this->_syndicArticleId.", "
                ."".$this->_syndicId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_url)."', "
                ."'".$db->quoteString($this->_date)."', "
                ."'".$db->quoteString($this->_lesAuteurs)."', "
				."'".$db->quoteString($this->_maj)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_descriptif)."')";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update a syndicated article in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_syndic_articles "
                ."SET id_syndic_article = ".$this->_syndicArticleId.", id_syndic = ".$this->_syndicId.", "
                ."titre = '".$db->quoteString($this->_titre)."', url = '".$db->quoteString($this->_url)."', "
                ."date_heure = '".$db->quoteString($this->_date)."', lesAuteurs = '".$db->quoteString($this->_lesAuteurs)."', "
                ."maj = '".$db->quoteString($this->_maj)."', statut = '".$db->quoteString($this->_statut)."', "
                ."descriptif = '".$db->quoteString($this->_descriptif)."' "
                ."WHERE id_syndic_article = ".$this->_syndicArticleId;

         
        
        //echo '<br />' . $query . '<br />';
        
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load($idSyndic)

    /**
     * This method is used to load a syndicated article from the database
     * @access  public
     * @param   int $syndicId ID of syndication to load
     */

    function load($idSyndic) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SYNDIC_ARTICLES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic_article = $idSyndic";

         

        //echo '<br />' . $query . '<br />';
        
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_syndic_articles : load($idSyndic)] Aucune syndication d'articles ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ getSyndicArticleForUrl($url, $idSyndic)

    /**
     * This method is used to get a syndicated article for a specific url and an ID of syndication
     * @access  public
     * @param   String $url url to get
     * @param   int $idSyndic ID of syndication to get
     */

    function getSyndicArticleForUrl($url, $idSyndic) {
        $syndicArticle = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : getSyndicArticleForUrl()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".SYNDIC_ARTICLES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE url=\"$url\" AND id_syndic = $idSyndic";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : getSyndicArticleForUrl()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $resultSyndicArticle = &BD_syndic_articles::factory($this->getDbParameters(), $this->getDbOptions());

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $resultSyndicArticle->_fetchData($row);
                $syndicArticle[] = &$resultSyndicArticle;
            }
            $result->free();
            return $syndicArticle;
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete a syndicated article from the database
     * @access  public
     * @param   int $id_syndic ID of syndication to delete
     */

    function delete($id_syndic) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic = $id_Syndic";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $row the row to fetch
     */

    function _fetchData($row) {
        $this->setSyndicArticleId($row['id_syndic_article']);
        $this->setSyndicId($row['id_syndic']);
        $this->setTitre($row['titre']);
        $this->setUrl($row['url']);
        $this->setdate($row['date_heure']);
        $this->setLesAuteurs($row['lesauteurs']);
        $this->setMaj($row['maj']);
        $this->setStatut($row['statut']);
        $this->setDescriptif($row['descriptif']);
    }

    // }}}

     // {{{ howManySyndicArticleIdForStatut($id_syndic)

    /**
     * This method is used to count the syndicated articles for a specific syndication ID
     * @access  public
     * @param   int $id_syndic ID of syndication to see
     */

    function howManySyndicArticleIdForSyndicId($id_syndic)    {
        $howManySyndicArticleId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : howManySyndicArticleIdForSyndicId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) as compte FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic=$id_syndic";

		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : howManySyndicArticleIdForSyndicId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManySyndicArticleId = intval($row["compte"]);
        }
        $result->free();
        return $howManySyndicArticleId;
    }

    // }}}

    // {{{ howManySyndicArticleIdForStatut($statut)

    /**
     * This method is used to count the syndicated articles for a specific statut
     * @access  public
     * @param   String $statut the statut to see
     */

    function howManySyndicArticleIdForStatut($statut)    {
        $howManySyndicArticleId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : howManySyndicArticleIdForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) AS compte FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE statut='$statut'";

		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : howManySyndicArticleIdForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManySyndicArticleId = intval($row["compte"]);
        }
        $result->free();
        return $howManySyndicArticleId;
    }

    // }}}

    // {{{ getAllForSyndicId($id_object,$critere)

    /**
     * This method is used to get all syndicated articles for a specific criteria and an ID of syndication
     * @access  public
     * @param   String $url url to get
     * @param   int $idSyndic ID of syndication to get
     */

    function &getAllForSyndicId($id_object, $critere) {
        $syndicArticle = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : getAllForSyndicId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic=$id_object ORDER BY $critere DESC";

        //echo $query;

        $queryResult = $db->limitQuery($query, 0, 100);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_syndic_article : getAllForSyndicId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultSyndicArticle = &BD_syndic_articles::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultSyndicArticle->_fetchData($row);
            $syndicArticle[] = &$resultSyndicArticle;
        }
        $queryResult->free();
        return $syndicArticle;
    }

    // }}}

}
?>