<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Syndic List Data abstraction.
//

/**
 * BD_syndicListData is a base class for syndic lists data database abstraction implementations, and must be
 * inherited by all such.
 */
if (defined("_BD_SYNDICLISTDATA")) return;
    define("_BD_SYNDICLISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once (dirname(__FILE__)."/inc_rubrique_factory.php");
require_once (dirname(__FILE__)."/inc_syndic_articles_factory.php");
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

/**
 * This class implements data lists for Syndic business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_syndicListData extends BD_objectListData {

    /**
     * Create a new syndic list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     *
     * @return mixed a newly created SyndicListData object, or a PEAR error code on
     * error
     *
     * access public
     */

    function &factory($dbParameters = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndiclistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/syndiclistdata_common.php");
            $classname = "BD_syndiclistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/syndiclistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_syndicListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Constructor.
     *
     * @access public
     */

    function BD_syndicListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ displayHTMLList($titre_table, $requete)

    /**
     * returns the HTML List for the various syndic data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $firstElement=0, $lastElement=0) {
        global $couleur_claire;
	    global $connect_id_auteur;

	    $activer_messagerie = lire_meta("activer_messagerie");
	    $activer_statistiques = lire_meta("activer_statistiques");

        $copyParams = $params;

	    $tranches = $this->_getHTMLNavigation($queryType, $params, 3);

	    $requete = $this->_getQuery($queryType, false, $copyParams);

        if ($tranches) {
    		debut_cadre_relief("site-24.gif");

		    echo "<TABLE WIDTH=100% CELLPADDING=3 CELLSPACING=0 BORDER=0>";
		    bandeau_titre_boite_articles($titre_table, true);

	    	echo $tranches;


		    $ifond = 0;
		    $premier = true;

		    $compteur_liste = 0;

		    $db = &$this->_getDB();
            if (DB::isError($db)) {
                die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
            }

		    if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result = $db->limitQuery($requete, $limitStart, $limitCount, $copyParams);
            } else {
                if($lastElement > 0) {
                    $result = $db->limitQuery($requete, $firstElement, $lastElement, $copyParams);
                }
                else {
                    $result = $db->query($requete, $copyParams);
                }
            }

            if (DB::isError($result)) {
                die("la requete a choue! ".$result->getMessage());
            }

		    $table = '';
            while ($row = $result->fetchRow()) {
    			$id_rubrique=$row["id_rubrique"];
                $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                if($authorization->isAuthorizedAction()) {
        			$ifond = $ifond ^ 1;
    			    $couleur = ($ifond) ? '#FFFFFF' : $couleur_claire;

    			    $id_syndic=$row["id_syndic"];
    			    $nom_site=typo($row["nom_site"]);
    			    $url_site=$row["url_site"];
    			    $url_syndic=$row["url_syndic"];
    			    $description=propre($row["description"]);
    			    $syndication=$row["syndication"];
    			    $statut=$row["statut"];
    			    $date=$row["date"];
    			    $moderation=$row['moderation'];

    			    $tous_id[] = $id_syndic;

    			    echo "<tr bgcolor='$couleur'>";

    			    echo "<td class='arial2'>";
    			    $link = new Link("sites.php3?id_syndic=$id_syndic");
    			    $redirect = new Link;
    			    $link->addVar('redirect', $redirect->getUrl());
    			    switch ($statut) {
    			    case 'publie':
        				$authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                        if(!$authorization->isAuthorizedAction())
        				//if (acces_restreint_rubrique($id_rubrique))
    					    $puce = 'puce-verte-anim.gif';
    				    else
        					$puce='puce-verte.gif';
    				    $title = _T('info_site_reference');
    				    break;
    			    case 'prop':
    				    $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                        if(!$authorization->isAuthorizedAction())
        				//if (acces_restreint_rubrique($id_rubrique))
        					$puce = 'puce-blanche-anim.gif';
    				    else
        					$puce='puce-blanche.gif';
    				    $title = _T('info_site_attente');
    				    break;
    			    case 'refuse':
        				$authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                        if(!$authorization->isAuthorizedAction())
        				//if (acces_restreint_rubrique($id_rubrique))
    					    $puce = 'puce-rouge-anim.gif';
    				    else
        					$puce='puce-rouge.gif';
    				    $title = _T('info_site_refuse');
    				    break;
    			    case 'poubelle':
        				$authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                        if(!$authorization->isAuthorizedAction())
        				//if (acces_restreint_rubrique($id_rubrique))
    					    $puce = 'puce-poubelle-anim.gif';
    				    else
        					$puce='puce-poubelle.gif';
    				    $title = _T('info_site_refuse');
    				    break;
    			    }
    			    if ($syndication == "off") {
        				$puce = 'puce-orange-anim.gif';
    				    $title = _T('info_panne_site_syndique');
    			    }

    			    echo "<a href=\"".$link->getUrl()."\" title=\"$title\">";
    			    echo "<img src='img_pack/$puce' width='7' height='7' border='0'>&nbsp;&nbsp;";
    			    if ($moderation == 'oui')
        				echo "<i>".typo($nom_site)."</i>";
    			    else
        				echo typo($nom_site);

    			    echo "</a> &nbsp;&nbsp; <font size='1'>[<a href='$url_site'>"._T('lien_visite_site')."</a>]</font>";
    			    echo "</td>";

    			    echo "<td class='arial1' align='right'> &nbsp;";
    			    if ($syndication == "off") {
        				echo "<font color='red'>"._T('info_probleme_grave')." </font>";
    			    }
    			    if ($syndication == "oui" or $syndication == "off"){
        				echo "<font color='red'>"._T('info_syndication')."</font>";
    			    }
    			    echo "</td>";
    			    echo "<td class='arial1'>";
    			    if ($syndication == "oui" OR $syndication == "off") {
        				$syndicArticleMetier = &recuperer_instance_syndic_articles();
            		    $resultat_art = $syndicArticleMetier->howManySyndicArticleIdForSyndicId($id_syndic);
                        if(PEAR::isError($resultat_art)) {
                            die($resultat_art->getMessage());
                        }
    				    //list($total_art) = each($result_art);
    				    //echo " $total_art article(s)";
    				    echo " $resultat_art article(s)";
    			    } else {
        				echo "&nbsp;";
    			    }
    			    echo "</td>";
    			    echo "</tr></n>";
    			}
		    }
		    echo "</TABLE>";
		    fin_cadre_relief();
	    }
	    return $tous_id;
    }

    // }}}

    // {{{ displaySyndicArticleHTMLList($titre_table, $queryType, $afficher_site = false)

    /**
     * returns the HTML List for the various syndic article data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */
    function displaySyndicArticleHTMLList($titre_table, $queryType, $params = array(), $afficher_site = false, $firstElement=0, $lastElement=0)   {
	    global $couleur_claire;
	    global $connect_statut;
	    global $REQUEST_URI;
	    global $debut_liste_sites;
	    global $flag_editable;

    	static $n_liste_sites;

	    $n_liste_sites++;
	    if (!$debut_liste_sites[$n_liste_sites]) $debut_liste_sites[$n_liste_sites] = 0;

	    $adresse_page = substr($REQUEST_URI, strpos($REQUEST_URI, "/ecrire")+8, strlen($REQUEST_URI));
	    $adresse_page = ereg_replace("\&?debut\_liste\_sites\[$n_liste_sites\]\=[0-9]+","",$adresse_page);
	    $adresse_page = ereg_replace("\&?(ajouter\_lien|supprimer_lien)\=[0-9]+","",$adresse_page);

    	if (ereg("\?",$adresse_page)) $lien_url = "&";
    	else $lien_url = "?";
    	$lien_url .= "debut_liste_sites[".$n_liste_sites."]=".$debut_liste_sites[$n_liste_sites]."&";


    	$nombre_aff = 10;

    	$activer_messagerie = lire_meta("activer_messagerie");
    	$activer_statistiques = lire_meta("activer_statistiques");

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die("Impossible d'obtenir une connexion  la base de donnes! ".$db->getMessage());
        }

        $requete = $this->_getQuery($queryType, false, $params);

        if($lastElement > 0) {
            $queryResult = $db->limitQuery($requete, $firstElement, $lastElement, $params);
        }
        else {
            $queryResult = $db->query($requete, $params);
        }

        if (DB::isError($queryResult)) {
            return $queryResult;
        }
	    $num_rows = $queryResult->numRows();

	    // Ne pas couper pour trop peu
	    if ($num_rows <= 1.5 * $nombre_aff) $nombre_aff = $num_rows;

		if ($num_rows > 0) {
			echo "<P><TABLE WIDTH=100% CELLPADDING=0 CELLSPACING=0 BORDER=0><TR><TD WIDTH=100% BACKGROUND=''>";
			echo "<TABLE WIDTH=100% CELLPADDING=3 CELLSPACING=0 BORDER=0>";

			bandeau_titre_boite_articles($titre_table, true);

			if ($num_rows > $nombre_aff) {
				echo "<tr><td background='' class='arial2' colspan=4>";
				for ($i = 0; $i < $num_rows; $i = $i + $nombre_aff){
					$deb = $i + 1;
					$fin = $i + $nombre_aff;
					if ($fin > $num_rows) $fin = $num_rows;
					if ($debut_liste_sites[$n_liste_sites] == $i) {
						echo "[<B>$deb-$fin</B>] ";
					} else {
						echo "[<A HREF='".$adresse_page.$lien_url."debut_liste_sites[$n_liste_sites]=$i'>$deb-$fin</A>] ";
					}
				}
				echo "</td></tr>";
			}

			$ifond = 0;
			$premier = true;

			$compteur_liste = 0;

	        while($row = $queryResult->fetchRow()) {
                if ($compteur_liste >= $debut_liste_sites[$n_liste_sites] AND $compteur_liste < $debut_liste_sites[$n_liste_sites] + $nombre_aff) {
					$ifond = $ifond ^ 1;
					$couleur = ($ifond) ? '#FFFFFF' : $couleur_claire;

					$id_syndic_article = $row["id_syndic_article"];
					$id_syndic = $row["id_syndic"];
					$titre=typo($row["titre"]);
					$url=$row["url"];
					$date=$row["date"];
					$lesauteurs=propre($row["lesauteurs"]);
					$statut=$row["statut"];
					$descriptif=$row["descriptif"];

					echo "<tr bgcolor='$couleur'>";

					echo "<td class='arial1'>";
					echo "<A HREF='$url'>";
					if ($statut=='publie') {
						if (acces_restreint_rubrique($id_rubrique))
							$puce = 'puce-verte-anim.gif';
						else
							$puce='puce-verte.gif';
					}
					else if ($statut == "refuse") {
							$puce = 'puce-poubelle.gif';
					}

					else if ($statut == "dispo") { // moderation : a valider
							$puce = 'puce-rouge.gif';
					}

					else if ($statut == "off") { // vieillerie
							$puce = 'puce-rouge-anim.gif';
					}

					echo "<img src='img_pack/$puce' width='7' height='7' border='0'>";

					if ($statut == "refuse")
						echo "<font color='black'>&nbsp;&nbsp;" . $titre . "</font>";
					else
						echo "&nbsp;&nbsp;".$titre;

					echo "</A>";

					if (strlen($lesauteurs)>0) echo "<br>"._T('info_auteurs_nombre')." <font color='#336666'>$lesauteurs</font>";
					if (strlen($descriptif)>0) echo "<br>"._T('info_descriptif_nombre')." <font color='#336666'>$descriptif</font>";

					echo "</td>";

					// $my_sites cache les resultats des requetes sur les sites
					if ($afficher_site) {
						    $syndicMetier = &recuperer_instance_syndic();
                            $loadOK = $syndicMetier->load($id_syndic);
                            if (PEAR::isError($loadOK)) {
                                die($loadOK->getMessage());
                            }
                            else {
                                echo "<td class='arial1' align='left'>";
						        $aff = $syndicMetier->getNomSite();
                                if ($syndicMetier->getModeration() == 'oui')
                                    echo "<i>$aff</i>";
                                else
							        echo $aff;
                                echo "</td>";
                            }
                    } else echo "<td></td>";

					echo "<td class='arial1' align='right'>";


					//-----------MODIFICATION CLEVER AGE elebescond@clever-age.com----------
                    $authorization = &recuperer_instance_authorization('supprimerSite', $GLOBALS['connect_id_auteur'], $params);


                    if ($authorization->isAuthorizedAction()) {
                    /*
                    if ($connect_statut == 'minirezo'){
                    */
                    //-----------FIN MODIFICATION CLEVER AGE elebescond@clever-age.com----------

						if ($statut == "publie"){
							echo "[<a href='".$adresse_page.$lien_url."id_syndic=$id_syndic&supprimer_lien=$id_syndic_article'><font color='black'>"._T('info_bloquer_lien')."</font></a>]";

						}
						else if ($statut == "refuse"){
							echo "[<a href='".$adresse_page.$lien_url."id_syndic=$id_syndic&ajouter_lien=$id_syndic_article'>"._T('info_retablir_lien')."</a>]";
						}
						else if ($statut == "dispo") {
							echo "[<a href='".$adresse_page.$lien_url."id_syndic=$id_syndic&ajouter_lien=$id_syndic_article'>"._T('info_valider_lien')."</a>]";
						}
					} else {
						echo "&nbsp;";
					}

					echo "</td>";
					echo "</tr></n>";

			}
			$compteur_liste++;
		}
        
		echo "</TABLE></TD></TR></TABLE>";
	}

}

// }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[SYNDICS_BY_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut=? ORDER BY nom_site";
        $this->_queriesCount[SYNDICS_BY_STATE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic WHERE statut=?";

        $this->_queries[SYNDICS_BY_SYNDICATION_AND_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication=? AND statut=? ORDER BY nom_site";
        $this->_queriesCount[SYNDICS_BY_SYNDICATION_AND_STATE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic WHERE syndication=? AND statut=?";

        $this->_queries[SYNDICS_MOT_BY_MOT_ID] = "SELECT syndic.* FROM ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots_syndic lien WHERE lien.id_mot=? AND lien.id_syndic=syndic.id_syndic ORDER BY syndic.nom_site DESC";
        $this->_queriesCount[SYNDICS_MOT_BY_MOT_ID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic syndic, ".$GLOBALS['table_prefix']."_mots_syndic lien WHERE lien.id_mot=? AND lien.id_syndic=syndic.id_syndic";

        $this->_queries[SYNDICS_MOT_BY_RUBRIQUE_ID_AND_NOT_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_rubrique=? AND statut<>? ORDER BY nom_site";
        $this->_queriesCount[SYNDICS_MOT_BY_RUBRIQUE_ID_AND_NOT_STATE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic WHERE id_rubrique=? AND statut<>?";

        $this->_queries[SYNDICS_BY_SYNDICATIONS_AND_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic WHERE (syndication=? OR syndication=?) AND statut=? ORDER BY nom_site";
        $this->_queriesCount[SYNDICS_BY_SYNDICATIONS_AND_STATE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic WHERE (syndication=? OR syndication=?) AND statut=?";

        $this->_queries[SYNDICS_ARTICLES_BY_SYNDICID] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic=? ORDER BY date_heure DESC";
        $this->_queriesCount[SYNDICS_ARTICLES_BY_SYNDICID] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic_articles WHERE id_syndic=?";

        $this->_queries[SYNDICS_LAST_ARTICLES] = "SELECT * FROM ".$GLOBALS['table_prefix']."_syndic_articles ORDER BY date_heure DESC";
        $this->_queriesCount[SYNDICS_LAST_ARTICLES] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_syndic_articles";

        $this->_queries[SYNDICS_RECHERCHE] = "SELECT * ".
                                                "FROM ".$GLOBALS['table_prefix']."_syndic WHERE <!spipSYNDIC_CONSTRUCTION_RECHERCHEspip!> ORDER BY maj DESC";
        $this->_queriesCount[SYNDICS_RECHERCHE] = "SELECT count(id_syndic) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_syndic WHERE  <!spipSYNDIC_CONSTRUCTION_RECHERCHEspip!>";

        $this->_queries[SYNDICS_RECHERCHE_INT] = "SELECT objet.id_syndic, objet.nom_site, objet.url_site, objet.date_heure, objet.statut, SUM(idx.points) AS points ".
                                                    "FROM ".$GLOBALS['table_prefix']."_syndic objet, ".$GLOBALS['table_prefix']."_index_syndic idx ".
                                                    "WHERE objet.id_syndic = idx.id_syndic AND idx.hash IN (!) AND objet.id_syndic NOT IN (!) GROUP BY objet.id_syndic, objet.nom_site, objet.url_site, objet.date_heure, objet.statut ORDER BY points DESC";
        $this->_queriesCount[SYNDICS_RECHERCHE_INT] = "SELECT COUNT(*) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_syndic objet, ".$GLOBALS['table_prefix']."_index_syndic idx ".
                                                    "WHERE objet.id_syndic = idx.id_syndic AND idx.hash IN (!) AND objet.id_syndic NOT IN (!)";
    }

    // }}}
}
?>