<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Type_document business persistence abstraction.
//
if (defined("_BD_TYPE_DOCUMENT")) return;
    define("_BD_TYPE_DOCUMENT", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("TYPE_DOCUMENT_ALL_FIELDS", " id_type, titre, descriptif, extension, mime_type, inclus, upload, maj");

/**
 * BD_type_document is a base class for forum business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_type_document extends BD_metier {
    // {{{ properties

    /**
    * Type ID.
    * @var     int
    * @access  private
    */
    var $_typeId;

    /**
    * Title.
    * @var     String
    * @access  private
    */
    var $_titre;

    /**
    * Description.
    * @var     String
    * @access  private
    */
    var $_descriptif;

    /**
    * Extension.
    * @var     String
    * @access  private
    */
    var $_extension;

    /**
    * Mime type.
    * @var     String
    * @access  private
    */
    var $_mime_type;

    /**
    * inclus.
    * @var     String
    * @access  private
    */
    var $_inclus;

    /**
    * upload.
    * @var     String
    * @access  private
    */
    var $_upload;

    /**
    *  last Update.
    * @var     Date
    * @access  private
    */
    var $_majDate;


    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/type_document_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/type_document_common.php");
            $classname = "BD_type_document_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/type_document_".$dbParameters->_dbEngine.".php");
            $classname = "BD_type_document_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_type_document constructor.
     *
     * @access public
     */

    function BD_type_document() {
    }

    // }}}

    // {{{ getTypeId()

    function getTypeId() {
        return $this->_typeId;
    }

    // }}}

    // {{{ setTypeId()

    function setTypeId($typeId) {
        $this->_typeId = $typeId;
    }

    // }}}
    
    // {{{ getTitre()

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}
    
    // {{{ getDescriptif()

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    function setDescriptif($descriptif) {
        $this->_descriptif = corriger_caracteres($descriptif);
    }

    // }}}    
    
    // {{{ getExtension()

    function getExtension() {
        return $this->_extension;
    }

    // }}}

    // {{{ setExtension()

    function setExtension($extension) {
        $this->_extension = corriger_caracteres($extension);
    }

    // }}}

    // {{{ getMimeType()

    function getMimeType() {
        return $this->_mimeType;
    }

    // }}}

    // {{{ setMimeType()

    function setMimeType($mimeType) {
        $this->_mimeType = corriger_caracteres($mimeType);
    }

    // }}}
    
    // {{{ getInclus()

    function getInclus() {
        return $this->_inclus;
    }

    // }}}

    // {{{ setInclus()

    function setInclus($inclus) {
        $this->_inclus = $inclus;
    }

    // }}}

    // {{{ getUpload()

    function getUpload() {
        return $this->_upload;
    }

    // }}}

    // {{{ setUpload()

    function setUpload($upload) {
        $this->_upload = $upload;
    }

    // }}}

    // {{{ getMajDate()

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ _setMajDate()

    function setMajDate($majDate) {
        $this->majDate = $majDate;
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_syndic";
        $typeId = $db->nextId($string_prefix, true);
        if (DB::isError($typeId)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : create()] ".$typeId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_typeId = $typeId;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_types_documents (".TYPE_DOCUMENT_ALL_FIELDS.") VALUES "
                ."(".$this->_typeId.", "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_extension)."', "
                ."'".$db->quoteString($this->_mimeType)."', "
                ."'".$db->quoteString($this->_inclus)."', "
                ."'".$db->quoteString($this->_upload)."', "
                ."'".$db->quoteString($this->_majDate)."')";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_types_documents "
                ."SET id_type = ".$this->_typeId.", "
                ."titre = '".$db->quoteString($this->_titre)."', descriptif = '".$db->quoteString($this->_descriptif)."', "
                ."extension = '".$db->quoteString($this->_extension)."', mime_type = '".$this->mimeType."', "
                ."inclus = '".$db->quoteString($this->_inclus)."', upload = '".$db->quoteString($this->_upload)."', "
                ."maj = '".$db->quoteString($this->_majDate)."' WHERE id_type = ".$this->_typeId;

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    function load($idType) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".TYPE_DOCUMENT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_types_documents WHERE id_type = $idType";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_type_document : load($idType)] Aucun type de document ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idType) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_types_documents WHERE id_type = $idType";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all types of document former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_types_documents WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setTypeId($row['id_type']);
        $this->setTitre($row['titre']);
        $this->setDescriptif($row['descriptif']);
        $this->setExtension($row['extension']);
        $this->setMimeType($row['mime_type']);
        $this->setInclus($row['inclus']);
        $this->setUpload($row['upload']);
        $this->setMajDate($row['maj']);
    }

    // }}}

    // {{{ getAllExtension()

    function getAllExtension() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllExtension()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT extension FROM ".$GLOBALS['table_prefix']."_types_documents ORDER BY extension";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllExtension()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $extension = "";
        $chaine = "";
		while ($row = $result->fetchRow()) {
				if ($extension) $chaine .= ", ";
				$extension = $row['extension'];
				$chaine .= $extension;
			}
        $result->free();
        return $chaine;
    }

    // {{{ getTexteUpload($ext, $inclus)

    function getTexteUpload($ext, $inclus){
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getTexteUpload()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT extension FROM ".$GLOBALS['table_prefix']."_types_documents WHERE extension='$ext'";
        if ($inclus)
		    $query .= " AND inclus='$inclus'";
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getTexteUpload()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
		    return $row['extension'];
        }
    }

    // {{{ &getAllExpect($typeIds)

    /**
     * Returns an array of TypeDocument expect
     * $typeIds.
     *
     *
     * @return Array of TypeDocument
     * @param $typeIds
     * @access public
     */

    function &getAllExpect($typeIds) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllExpect()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".TYPE_DOCUMENT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_types_documents WHERE id_type NOT IN ($typeIds)";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllExpect()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultTypeDocument = &BD_type_document::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultTypeDocument->_fetchData($row);
            $result[] = &$resultTypeDocument;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    /**
     * Returns an array of TypeDocument depending
     * on $ext and $upload
     *
     * @return Array of TypeDocument
     * @param $ext
     * @param $upload
     * @param $vignette
     * @param $image
     * @access public
     */

    function &getAllForExtensionAndUploadAndInclus($ext, $upload, $vignette, $inclus) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllForExtensionAndUploadAndInclus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".TYPE_DOCUMENT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_types_documents WHERE extension='$ext' AND upload='$upload'";
        if ($mode == 'vignette')
		$query .= " AND inclus='image'";

        //echo "<br><br>$query<br><br>";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllForExtensionAndUploadAndInclus()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultTypeDocument = &BD_type_document::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultTypeDocument->_fetchData($row);
            $result[] = &$resultTypeDocument;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllType()

    function getAllTypeIds() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllTypeIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

	 	$query = "SELECT ".TYPE_DOCUMENT_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_types_documents";
    	 
    	$result = $db->query($query);

    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : getAllTypeIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    	while ($row = $result->fetchRow())  {
            $types[$row['id_type']] = $row;
        }
        $result->free();
        return $types;
    }

    // }}}

    // {{{ hasExtension($ext)

    function hasExtension($ext, $inclus = null) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : hasExtension()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT extension FROM ".$GLOBALS['table_prefix']."_types_documents WHERE extension='$ext'";

        if ($inclus) {
            $query .= " AND inclus='$inclus'";
        }

        
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : hasExtension()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $hasExtension = ($result->numRows() > 0);
        $result->free();
        return $hasExtension;
    }

    // }}}

    // {{{ updateInclusAndExtension()

    function updateInclusAndExtension($newInclus, $inclus) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : updateInclusAndExtension()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_types_documents SET inclus=$newInclus WHERE inclus!=$inclus AND extension IN ".
			"('aiff', 'asf', 'avi', 'mid', 'mov', 'mp3', 'mpg', 'ogg', 'qt', 'ra', 'ram', 'rm', 'swf', 'wav', 'wmv')";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_type_document : updateInclusAndExtension()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

}
?>