<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// | Copyright (c) 2004 Clever Age Polska                                 |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// | Author: Maciek BOROWKA <mborowka@clever-age.com>                     |
// +----------------------------------------------------------------------+
//
// Base class for Visite business persistence abstraction.
//

if (defined("_BD_VISITE")) return;
define("_BD_VISITE", "1");

//require_once "PEAR.php";
//require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";

define("VISITE_ALL_FIELDS", " date_heure, visites, maj ");


/**
 * BD_visite is a base class for visite business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angenieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_visite extends BD_metier {
    // {{{ properties

    /**
    * Date.
    * @var     Date
    * @access  private
    */
    var $_date;

    /**
    * Visites.
    * @var     int
    * @access  private
    */
    var $_visites;

    /**
    * Last Update.
    * @var    Date
    * @access  private
    */
    var $_maj;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/visite_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/visite_common.php");
            $classname = "BD_visite_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/visite_".$dbParameters->_dbEngine.".php");
            $classname = "BD_visite_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }

        if ($obj->_pearIncluded()) 
        {
            if (PEAR::isError($result)) {
                return $result;
            } else {
                return $obj;
            }
        }
        else
        {
           //no error check, sorry
           return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_visite constructor.
     *
     * @access public
     */

    function BD_visite() {
    }

    // }}}

    // {{{ getDate()

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    function setDate($date) {
        $this->_date = $date;
    }

    // }}}

    // {{{ getVisites()

    function getVisites() {
        return $this->_visites;
    }

    // }}}

    // {{{ setVisites()

    function setVisites($visites) {
        $this->_visites = $visites;
    }

    // }}}

    // {{{ getMaj()

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

   // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));

        /*
         * First we must check if there are any other row for
         * actualization date.
         */
        $query = 'SELECT '.VISITE_ALL_FIELDS.'
                    FROM '.$GLOBALS['table_prefix'].'_visites
                    WHERE date_heure=\''.$this->_date.'\'';


        $result = $db->query($query);
        if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_visite : create()]".$result->getMessage()."",
                        null, null, null, null, null, false);
        }else{
            if($result->numRows() == 0){
                $query = "INSERT INTO ".$GLOBALS['table_prefix']."_visites (".VISITE_ALL_FIELDS.") VALUES "
                        ."('".$db->quoteString($this->_date)."', "
                        ."'".$db->quoteString($this->_visites)."', "
                        ."'".$db->quoteString($this->_maj)."')";
        
                spip_log("Creating a visit $query");
                //echo "<br><br>$query\n\n<br><br>";
                $result = $db->query($query);
                if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_visite : create()]".
                        $result->getMessage()."", null, null, null, null, null, false);
                }
            }else{
                   /**
                    * xxx clever-age xxx
                    * lzachulski@clever-age.com
                    *
                    * Update row
                    */
                    $this->update();
            }
        }
    }

    // }}}

    // {{{ delete()

    function delete($date) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_visites WHERE date_heure = '$date'";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_visites "
                //."SET date_heure = '".$db->quoteString($this->_date)."', "
                ." SET visites = ".$GLOBALS['table_prefix']."_visites.visites + ".
                    $db->quoteString($this->_visites).",
                maj = '".$db->quoteString($this->_maj)."' "
                ."WHERE ".$GLOBALS['table_prefix']."_visites.date_heure = '".
                    $db->quoteString($this->_date)."'";


        $result = $db->query($query);
        spip_log("Updating a visit $query");
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : update()] ".$result->getMessage()."",
                     null, null, null, null, null, false);
        }else{

        }
    }

    // }}}

    // {{{ load()

    function load($date) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".VISITE_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_visites WHERE date_heure = '$date'";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_visite : load(".$date.")] Aucune visite ne correspond pas a cette date!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setDate($row['date_heure']);
        $this->setVisites($row['visites']);
        $this->setMaj($row['maj']);
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all visits former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_visites WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllVisiteTemp()

    function deleteAllVisiteTemp() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : deleteAllVisiteTemp()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_visites_temp";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : deleteAllVisiteTemp()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ howManyDistinctVisite()

    function howManyDistinctVisite() {
        $howManyVisite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisite()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(DISTINCT ip) AS total_visites FROM ".$GLOBALS['table_prefix']."_visites_temp";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisite()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyVisite = intval($row["total_visites"]);
        }
        $result->free();
        return $howManyVisite;
    }

    // }}}

    // {{{ howManyVisite()

    function howManyVisite() {
        $howManyVisite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyVisite()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT SUM(visites) AS total_absolu FROM ".$GLOBALS['table_prefix']."_visites";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyVisite()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyVisite = intval($row["total_absolu"]);
        }
        $result->free();
        return $howManyVisite;
    }


    // }}}

    // {{{ howManyDistinctVisiteForAnArticle($id_article = null)

    function howManyDistinctVisiteForAnArticle($id_article = null) {
        $howManyVisite = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisiteForAnArticle()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(DISTINCT ip) AS c FROM ".$GLOBALS['table_prefix']."_visites_temp";
        if($id_article != null) {
            $query .= " WHERE type='article' AND id_objet=$id_article";
        }

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : howManyDistinctVisiteForAnArticle()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyVisite = intval($row["c"]);
        }
        $result->free();
        return $howManyVisite;
    }


    // }}}

    // {{{ getAllUniqueVisiteForArticleId()

    /**
     * Returns an array of Visite and id_objet.
     *
     * @return an array of Visite and id_objet.
     * @access public
     */

    function getAllUniqueVisiteForArticleId() {
        $visites = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllUniqueVisiteForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(DISTINCT ip) AS visites, id_objet FROM ".$GLOBALS['table_prefix']."_visites_temp WHERE type='article' GROUP BY id_objet";

        //echo '<br>'.$query.'<br>';

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllUniqueVisiteForArticleId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ addArticleVisite($visite_insert)

    function addArticleVisite($visites_insert) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : addArticleVisite()]
                 ".$db->getMessage()."", null, null, null, null, null, false);
        }

        while(list(, $maVisite) = each($visites_insert)) {
            $query = "SELECT date_heure, id_article
                FROM ".$GLOBALS['table_prefix']."_visites_articles
                WHERE date_heure = " . $maVisite['date'] . "
                    AND id_article = " . $maVisite['id_article'] . "";
             
            //echo "<br><br>\n\n$query\n<br><br>";
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_visite : addArticleVisite()]
                    ".$result->getMessage(), null, null, null, null, null, false);
            }

            if($result->numRows() == 0) {
                $query = "INSERT INTO ".$GLOBALS['table_prefix']."_visites_articles
                    (date_heure, id_article, visites, maj)
                    VALUES (".$maVisite['date'].",".$maVisite['id_article'].",".$maVisite['visites'].",
                    '".date("Y-m-d H:i:s")."')";
                //echo "<br><br>\n\n$query\n<br><br>";
                 
                $result = $db->query($query);
                if (DB::isError($result)) {
                    return PEAR::raiseError("[".get_class($this)." DB_visite : addArticleVisite()] ".$result->getMessage()."", null,
                        null, null, null, null, false);
                }
            }
        }


    }

    // }}}

    // }}}

    // {{{ getAllVisiteForTypeSinceXsec($duree, $type)

    function getAllVisiteForTypeSinceXsec($duree, $type) {
        $visites = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllVisiteForTypeSinceXsec()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval($duree));

        $query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_visites_temp WHERE maj > '" . 
                    $maDate->getDate(DATE_FORMAT_ISO) . "' AND type='$type' GROUP BY id_objet";
        //spip_log("Visites since $duree sec: $query");

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllVisiteForTypeSinceXsec()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $visites[] = array('count' => $row['count'], 'id_objet' => $row['id_objet']);
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllForArticleIdAndDate($id_article)

    function getAllForArticleIdAndDate($id_article) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForArticleIdAndDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(89*24*3600));

		$query = "SELECT date_heure AS date_unix, visites FROM ".$GLOBALS['table_prefix']."_visites_articles WHERE id_article=$id_article AND date_heure > '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_heure";
		//$query = "SELECT UNIX_TIMESTAMP(date) AS date_unix, visites FROM ".$GLOBALS['table_prefix']."_visites_articles WHERE id_article=$id_article AND date > DATE_SUB(NOW(),INTERVAL 89 DAY) ORDER BY date";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForArticleIdAndDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $maDate = new Date($row['date_unix']);
            $row['date_unix'] = $maDate->getDate(DATE_FORMAT_UNIXTIME);
            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllForDate()

    function getAllForDate() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(89*24*3600));

        $query = "SELECT date_heure AS date_unix, visites FROM ".$GLOBALS['table_prefix']."_visites WHERE date_heure > '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_heure";
		//$query = "SELECT UNIX_TIMESTAMP(date) AS date_unix, visites FROM ".$GLOBALS['table_prefix']."_visites WHERE date > DATE_SUB(NOW(),INTERVAL 89 DAY) ORDER BY date";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $maDate = new Date($row['date_unix']);
            $row['date_unix'] = $maDate->getDate(DATE_FORMAT_UNIXTIME);

            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllforArticleIdPerMonth($id_article)

    function getAllForArticleIdPerMonth($id_article) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForArticleIdPerMonth()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(2700*24*3600));

        $query = "SELECT date_heure AS date_unix, SUM(visites) AS total_visites  FROM ".$GLOBALS['table_prefix']."_visites_articles WHERE id_article=$id_article AND date_heure > '" . $maDate->getDate(DATE_FORMAT_ISO) . "' GROUP BY date_unix ORDER BY date_heure";
		//$query = "SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(date),'%Y-%m') AS date_unix, SUM(visites) AS total_visites  FROM ".$GLOBALS['table_prefix']."_visites_articles WHERE id_article=$id_article AND date > DATE_SUB(NOW(),INTERVAL 2700 DAY) GROUP BY date_unix ORDER BY date";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllForArticleIdPerMonth()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            //XXX Why, oh why? On prend la date, on la formate et on finit avec la meme?
            $maDate = new Date($row['date_unix']);
            $maDate2 = new Date($maDate->format('%Y-%m-00 00:00:00'));
            $row['date_unix'] = $maDate2->getDate(DATE_FORMAT_UNIXTIME);

            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ getAllPerMonth()

    function getAllPerMonth() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllPerMonth()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(2700*24*3600));

        $query = "SELECT date_heure AS date_unix, SUM(visites) AS total_visites  FROM ".$GLOBALS['table_prefix']."_visites WHERE date_heure > '" . $maDate->getDate(DATE_FORMAT_ISO) . "' GROUP BY date_unix ORDER BY date_heure";
		//$query = "SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(date),'%Y-%m') AS date_unix, SUM(visites) AS total_visites  FROM ".$GLOBALS['table_prefix']."_visites WHERE date > DATE_SUB(NOW(),INTERVAL 2700 DAY) GROUP BY date_unix ORDER BY date";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : getAllPerMonth()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            //XXX Why oh why? On prend la date, on la formate et on finit avec la meme?
            $maDate = new Date($row['date_unix']);
            $maDate2 = new Date($maDate->format('%Y-%m-00 00:00:00'));
            $row['date_unix'] = $maDate2->getDate(DATE_FORMAT_UNIXTIME);

            $visites[] = $row;
        }
        $result->free();
        return $visites;
    }

    // }}}

    // {{{ addVisiteTemp($log_ip, $log_type, $log_id_num)

    function addVisiteTemp($log_ip, $log_type, $log_id_num) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : addVisiteTemp()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ip, type, id_objet FROM ".$GLOBALS['table_prefix']."_visites_temp WHERE ip='$log_ip' AND type='$log_type' AND id_objet=$log_id_num";
        //echo "<br><br>$query\n\n<br><br>";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : addVisiteTemp()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() == 0) {
            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_visites_temp (ip, type, id_objet) VALUES ('$log_ip', '$log_type', $log_id_num)";
            //echo "<br><br>$query\n\n<br><br>";

             
            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_visite : addVisiteTemp()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}
              
    /**
     * Method for updating *_visites_articles table. 
     */
    function updateVisiteArticleForId($articleIds, $visits, $date = '') {

        if(!$date){
           $date = date("Y-m-d", time() - 24 * 3600);
        }

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : updateVisiteArticleForId()]
                    ".$db->getMessage()."", null, null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_visites_articles
                    SET visites = ".$GLOBALS['table_prefix']."_visites_articles.visites + " . $visits . ",
                    maj = '".date("Y-m-d H:i:s")."'
                    WHERE ".$GLOBALS['table_prefix']."_visites_articles.id_article
                        IN (" . join(", ", $articleIds) . ") AND
                        ".$GLOBALS['table_prefix']."_visites_articles.date_heure='".$date."'";


        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_visite : updateVisitesArticleForId()]
                 ".$result->getMessage()."", null, null, null, null, null, false);
        }
    }

}