<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// | Author: Olivier Mansour                                              |
// +----------------------------------------------------------------------+
//
// Base class for Agora CACHE.
//
if (defined("_AGORA_CACHE")) return;
    define("_AGORA_CACHE", "1");

require_once "Cache/Function.php";

/**
 * AgoraCache is a class for article cache.
 * @package	Cache
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @author  Olivier Mansour  <omansour@clever-age.com>
 * @access	public
 */

class AgoraCache {

    // {{{ properties
    
    /**
     * Parameters instance used for PEAR::CACHE factory and Metier subclasses factories.
     *
     * @access private
     */
    var $_cacheParameters;

	var $_objectId;
    
    var $_objectType;
    
    var $_cacheId;
    
    var $_groupId;
    
    var $_cache; // objet PEAR CaCHE
    
    var $_objectMetier;
    
    // }}}
    
	// {{{ getCacheParameters()

    /**
     * Getter method to retreive the instance Parameters object
     *
     * @return      Cache parameters
     * @access      public
     */

    
    function getCacheParameters() {
        return $this->_cacheParameters;
    }
    

    // }}}

    // {{{ setCacheParameters()

    /**
     * Setter method to set the instance Parameters object
     *
     * @param $cacheParameters     new Cache parameters
     */
	
    function setCacheParameters($cacheParameters) {
        if (get_class($cacheParameters) == "CacheParameters") {
            $this->_cacheParameters = $cacheParameters;
        } else {
            return PEAR::raiseError("Erreur! le parametre de la methode setCacheParameters doit etre un objet de la hierarchie CacheParameters !",
                              null, null, null, null, null, false);
        }
    }
	
    // }}}
    
    // {{{ constructor

    /**
     * AgoraCache constructor.
     *
     * @access public
     */

    function AgoraCache($cacheParams) {
        //var_dump($cacheParams);
		//require_once "Cache.php";
		$this->_cache = new Cache ($cacheParams->getContainerType(), $cacheParams->getOptions());
		$this->_cacheParameters = $cacheParams;
		// activation du FileLocking pour le container file
		if ($cacheParams->getContainerType() == 'file') {
			$this->_cache->_fileLocking = true;
		}
    }

    // }}}
    
    // {{
    
    function getCacheId($options = '') {
    
    	return $this->_cache->generateID($options);    	
    
    }    
    
	// }}
	
	// {{
    
    function getCacheGroupId() {
    
    	return $this->_objectType . '-' . $this->_objectId;
    	//return $this->_objectType;
    
    }
    
	// }}
    
    // {{
    
    function getCacheGeneralGroupId() {
        return $this->_objectType;
    }
    
    // }}
	
	// {{
    
    function cacheExist($cacheId) {
    	
    	$isExpired = $this->_cache->isExpired( $cacheId, $this->getCacheGroupId());
    	$isCached = $this->_cache->isCached($cacheId, $this->getCacheGroupId());
    	return (!$isExpired AND $isCached); 
    }
    
    // }}
    
    // {{
    
    function generalCacheExist($cacheId) {
        //echo '<br />cache id: '.$cacheId;
        $isExpired = $this->_cache->isExpired($cacheId, $this->getCacheGeneralGroupId());
        $isCached = $this->_cache->isCached($cacheId, $this->getCacheGeneralGroupId());
        return (!$isExpired AND $isCached);
    }
    
    // }}
    
    // {{
    
    function saveCache ($cacheId, $data) {
		  return $this->_cache->save ($cacheId,  $data, $this->_cacheParameters->getTTL(), $this->getCacheGroupId());
        	
    }

     // }}

    // {{
    
    function saveGeneralCache ($cacheId, $data) {
          return $this->_cache->save ($cacheId,  $data, $this->_cacheParameters->getTTL(), $this->getCacheGeneralGroupId());     
  
    }

     // }}
    
    // {{

    function loadCache ($cacheId) {
          $data = $this->_cache->load ($cacheId, $this->getCacheGroupId());  
    	  return $data;	
    }    
     		
    
	// }}
	
    
    // {{

    function loadGeneralCache ($cacheId) {
          $data = $this->_cache->load ($cacheId, $this->getCacheGeneralGroupId());
          return $data; 
    }    
            
    
    // }}
    
	// {{
    
    function removeCache($cacheId) {
        $this->_cache->remove($cacheId, $this->getCacheGroupId());
    }
    
	// }}
    
    // {{
    
    function removeGeneralCache($cacheId) {
        $this->_cache->remove($cacheId, $this->getCacheGeneralGroupId());     
    }
    
    // }}
    
	
	// {{
    
    function flushCache() {
        @$this->_cache->flush($this->getCacheGroupId());
        // @ solution pourrie : mais le cache n'est pas forcement present donc il risque d'y avoir une remontee d erreur
    	
    }
    
	// }}
	
    // {{
    
    function flushGeneralCache() {
        @$this->_cache->flush($this->getCacheGeneralGroupId());
    }
    
    // }}
    
    // {{
    
    function flushBothCache() {
        //echo 'flush des caches';
        @$this->flushCache();
        @$this->flushGeneralCache();
    }
    
    // }}
    
	// {{
    
    /**
    * purge tout le cache 
    **/
    
    function flushAllCache() {
    	@$this->_cache->flush();
    }
    
	// }}	
	

}
?>