<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Class for defining data source connection parameters
//
if (defined("_CACHE_PARAMS")) return;
define("_CACHE_PARAMS", "1");

/**
 * This class defines parameters for accessing a given cache source
 * @package	CACHE
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class Cacheparameters {

    // {{{ properties

    /**
     * Cache container type (see PEAR::CACHE for more information)
     * @var     String
     * @access  private
     */
    var $_containerType;

    /**
     * Cache TTL
     * @var     Integer
     * @access  private
     */
    var $_ttl;

    /**
     * Optional parameters
     * @var     Array
     * @access  private
     */
    var $_options;
    
    // }}}

	// {{{ getContainerType()

    /**
     * Getter method to retreive Container type
     *
     * @return      Container type
     * @access      public
     */

    function getContainerType() {
        return $this->_containerType;
    }

    // }}}

    // {{{ setContainerType()

    /**
     * Setter method to set Container type
     *
     * @param $dbEngine     new Container type
     * @access      public
     */

    function setContainerType($containerType) {
        $this->_containerType = $containerType;
    }

    // }}}

	// {{{ getTTL()

    /**
     * Getter method to retreive TTL
     *
     * @return      TTL
     * @access      public
     */

    function getTTL() {
        return $this->_ttl;
    }

    // }}}

    // {{{ setTTL()

    /**
     * Setter method to set TTL
     *
     * @param $ttl     new TTL
     * @access      public
     */

    function setTTL($ttl) {
        $this->_ttl = $ttl;
    }

    // }}}

	// {{{ getOptions()

    /**
     * Getter method to retreive Options parameters
     *
     * @return      Options parameters
     * @access      public
     */

    function getOptions() {
        return $this->_options;
    }

    // }}}

    // {{{ setOptions()

    /**
     * Setter method to set Pass var
     *
     * @param $dbPass     new Options parameters
     * @access      public
     */

    function setOptions($options) {
        $this->_options = $options;
    }

    // }}}
	    
    // {{{ constructor

    /**
     * Constructor for CacheParamaters class
     * @param   $containerType String representing the CACHE container type.
     * @param   $ttl String representing the ttl
     * @param   $options String representing array of optional parameters
     * @access  public
     */
    function CacheParameters($containerType, $ttl, $options) {
        
        $this->_containerType = $containerType;
        $this->_ttl = $ttl;
        $this->_options = $options;
                
    }

    // }}}

}

?>