<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// | Author: Olivier Mansour                                              |
// +----------------------------------------------------------------------+
//
// Base class for Article cache business persistence abstraction.
//

require_once dirname(__FILE__)."/AgoraCache.php";

/**
 * BD_article_cache is a class for article cache.
 * @package	Cache
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @author  Olivier Mansour  <omansour@clever-age.com>
 * @access	public
 */

class article_cache extends AgoraCache {

    // {{{ properties
    
    // }}}

    // {{{ constructor

    /**
     * article_cache constructor.
     *
     * @access public
     */

    function article_cache($cacheParams) {
        
		$this->_objectMetier = &recuperer_instance_article(true);
		$this->_objectType = 'article';
    	
		$par = get_parent_class($this);
        $res = $this->$par($cacheParams);

    }

    // }}}

    // {{{ getArticleId()

    function getArticleId() {
        return $this->_objectMetier->getArticleId();
    }

    // }}}

    // {{{ setArticleId()

    function setArticleId($articleId) {
        $this->_objectMetier->setArticleId($articleId);
    }

    // }}}

    // {{{ getSurtitre()

    function getSurtitre() {
        return $this->_objectMetier->getSurtitre();
    }

    // }}}

    // {{{ setSurtitre()

    function setSurtitre($surtitre) {
         $this->_objectMetier->setSurtitre($surtitre);
    }

    // }}}

    // {{{ getTitre()

    function getTitre() {
        return $this->_objectMetier->getTitre();
    }

    // }}}

    // {{{ setTitre()

    function setTitre($titre) {
        $this->_objectMetier->setTitre($titre);
    }

    // }}}

    // {{{ getSoustitre()

    function getSoustitre() {
        return $this->_objectMetier->getSoustitre();
    }

    // }}}

    // {{{ setSoustitre()

    function setSoustitre($soustitre) {
        $this->_objectMetier->setSoustitre($soustitre);
    }

    // }}}

    // {{{ getRubriqueId

    function getRubriqueId() {
        return $this->_objectMetier->getRubriqueId();
    }

    // }}}

    // {{{ setRubriqueId()

    function setRubriqueId($rubriqueId) {
        $this->_objectMetier->setRubriqueId($rubriqueId);
    }

    // }}}

    // {{{ getDescriptif()

    function getDescriptif() {
        return $this->_objectMetier->getDescriptif();
    }

    // }}}

    // {{{ setDescriptif()

    function setDescriptif($descriptif) {
        $this->_objectMetier->setDescriptif($descriptif);
    }

    // }}}

    // {{{ getChapo()

    function getChapo() {
        return $this->_objectMetier->getChapo();
    }

    // }}}

    // {{{ setChapo()

    function setChapo($chapo) {
        $this->_objectMetier->setChapo($chapo);
    }

    // }}}

    // {{{ getTexte()

    function getTexte() {
        return $this->_objectMetier->getTexte();
    }

    // }}}

    // {{{ setTexte()

    function setTexte($texte) {
        //var_dump($this->_objectMetier);
        $this->_objectMetier->setTexte($texte);
    }

    // }}}

    // {{{ getPs()

    function getPs() {
        return $this->_objectMetier->getPs();
    }

    // }}}

    // {{{ setPs()

    function setPs($ps) {
        $this->_objectMetier->setPs($ps);
    }

    // }}}

    // {{{ getDate()

    function getDate() {
        return $this->_objectMetier->getDate();
    }

    // }}}

    // {{{ setDate()

    function setDate($date) {
        $this->_objectMetier->setDate($date);
    }

    // }}}

    // {{{ getStatut()

    function getStatut() {
        return $this->_objectMetier->getStatut();
    }

    // }}}

    // {{{ setStatut()

    function setStatut($statut) {
        $this->_objectMetier->setStatut($statut);
    }

    // }}}

    // {{{ getSecteurId()

    function getSecteurId() {
        return $this->_objectMetier->getSecteurId();
    }

    // }}}

    // {{{ setSecteurId()

    function setSecteurId($secteurId) {
        $this->_objectMetier->setSecteurId($secteurId);
    }

    // }}}

    // {{{ getMajDate()

    function getMajDate() {
        return $this->_objectMetier->getMajDate();
    }

    // }}}

    // {{{ setMajDate()

    function setMajDate($majDate) {
        $this->_objectMetier->setMajDate($majDate);
    }

    // }}}

    // {{{ getExport()

    function getExport() {
        return $this->_objectMetier->getExport();
    }

    // }}}

    // {{{ setExport()

    function setExport($export) {
        $this->_objectMetier->setExport($export);
    }

    // }}}

    // {{{ getRedactionDate()

    function getRedactionDate() {
        return $this->_objectMetier->getRedactionDate();
    }

    // }}}

    // {{{ setRedactionDate()

    function setRedactionDate($redactionDate) {
        $this->_objectMetier->setRedactionDate($redactionDate);
    }

    // }}}

    // {{{ getVisites()

    function getVisites() {
        return $this->_objectMetier->getVisites();
    }

    // }}}

    // {{{ setVisistes()

    function setVisites($visites) {
        $this->_objectMetier->setVisites($visites);
    }

    // }}}

    // {{{ getReferers()

    function getReferers() {
        return $this->_objectMetier->getReferers();
    }

    // }}}

    // {{{ setReferers()

    function setReferers($referers) {
        $this->_objectMetier->setReferers($referers);
    }

    // }}}

    // {{{ getPopularite()

    function getPopularite() {
        return $this->_objectMetier->getPopularite();
    }

    // }}}

    // {{{ setPopularite()

    function setPopularite($popularite) {
        $this->_objectMetier->setPopularite($popularite);
    }

    // }}}

    // {{{ getAccpeterForum()

    function getAccepterForum() {
        return $this->_objectMetier->getAccepterForum();
    }

    // }}}

    // {{{ setAccepterForum()

    function setAccepterForum($accepterForum) {
        $this->_objectMetier->setAccepterForum($accepterForum);
    }

    // }}}

    // {{{ getAuteurModif()

    function getAuteurModif() {
        return $this->_objectMetier->getAuteurModif();
    }

    // }}}

    // {{{ setAuteurModif()

    function setAuteurModif($auteurModif) {
        $this->_objectMetier->setAuteurModif($auteurModif);
    }

    // }}}

    // {{{ getModificationDate()

    function getModificationDate() {
        return $this->_objectMetier->getModificationDate();
    }

    // }}}

    // {{{ setModificationDate()

    function setModificationDate($modificationDate) {
        $this->_objectMetier->setModificationDate($modificationDate);
    }

    // }}}

    // {{{ getExtra()

    function getExtra() {
        return $this->_objectMetier->getExtra();
    }

    // }}}

   // {{{ setExtra()

   function setExtra($extra) {
        $this->_objectMetier->setExtra($extra);
   }

   // }}}

    // {{{ getLang()

    /**
     * Returns the lang fields
     * @return  String
     * @access  public
     */

    function getLang() {
        return $this->_objectMetier->getLang();
    }

    // }}}

    // {{{ setLang()

    /**
     * Sets the lang fields
     * @param   String
     * @access  public
     */

    function setLang($lang) {
        $this->_objectMetier->setLang($lang);
    }

    // }}}

    // {{{ getLangChoisie()

    /**
     * get Lang functions activation.
     * @var     String
     * @access  private
     */

    function getLangChoisie() {
        return $this->_objectMetier->getLangChoisie();
    }

    // }}}
    
    // {{{ setLangChoisie()


    /**
     * Set Lang functions activation.
     * @var     String
     * @access  private
     */

    function setLangChoisie($langChoisie) {
        $this->_objectMetier->setLangChoisie($langChoisie);
    }

    // }}}
        
    // {{{ getTradId()

    /**
     * get Trad id.
     * @var     int
     * @access  private
     */

    function getTradId() {
        return $this->_objectMetier->getTradId();
    }

    // }}}
    
    // {{{ setTradId()


    /**
     * Set Trad Id.
     * @var     int
     * @access  private
     */

    function setTradId($tradId) {
        $this->_objectMetier->setTradId($tradId);
    }

    // }}}

    // {{{ getNomSite()

    /**
     * get Site Name.
     * @var     String
     * @access  private
     */

    function getNomSite() {
        return $this->_objectMetier->getNomSite();
    }

    // }}}
    
    // {{{ setNomSite()


    /**
     * Set Site Name.
     * @var     String
     * @access  private
     */

    function setNomSite($nomSite) {
        $this->_objectMetier->setNomSite($nomSite);
    }

    // }}}
    
    // {{{ getUrlSite()

    /**
     * get Site Url.
     * @var     String
     * @access  private
     */

    function getUrlSite() {
        return $this->_objectMetier->getUrlSite();
    }

    // }}}
    
    // {{{ setUrlSite()


    /**
     * Set Site Url.
     * @var     String
     * @access  private
     */

    function setUrlSite($urlSite) {
        $this->_objectMetier->setUrlSite($urlSite);
    }

    // }}}


    // {{{ getVersionId
    /**
     * Get the version Id
     * 
     */
    
    function getVersionId() {
        return $this->_objectMetier->getVersionId();
    }
    
    // }}}
    
    // {{{ setVersionId
    
    /**
     * Set the Version Id
     */
    
    function setVersionId($versionId) {
        $this->_objectMetier->setVersionId($versionId); 
    }
    
    // }}}
    
    
    // {{{ getActiverHistorique()
    
    function getActiverHistorique() {
        return $this->_objectMetier->getActiverHistorique();
    }
        
    // }}}

    // {{{ setActiverHistorique()
    
    function setActiverHistorique($activerHistorique) {
        $this->_objectMetier->setActiverHistorique($activerHistorique);
    }
    
    // }}}


    // {{{ create()

    /**
     * This method is used to create a new article in the database
     * @access public
     */

    function create() {
        $this->flushBothCache();
        return $this->_objectMetier->create();

    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this article in the database
     * @access public
     */

    function update() {
		$this->flushBothCache();
		return $this->_objectMetier->update();

    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an article from the database
     * @access  public
     * @param   int $idArticle id of article to load
     */

    function load($idArticle) {
        
        $signature = $this->_cache->generateID('load'.$idArticle);
        // $signature = 'load'.$idArticle;
		$this->_objectId = $idArticle; 
		if ($this->cacheExist($signature)) {
			//echo 'LE CACHE EXISTE<br /><br />';
			$this->_objectMetier = $this->loadCache($signature);
            return $this->_objectMetier;
		} else {
			//echo 'LE CACHE N\'EXISTE PAS<br /><br />';
			$result = $this->_objectMetier->load($idArticle);
			if (!PEAR::isError($result)) {
				$this->saveCache($signature, $this->_objectMetier);
			}
			return $result;
		}		
        
    }

    // }}}

    // {{{ loadLightWeight()

    /**
     * This method is used to load an article from the database
     * selecting only small size fields from the DB
     * @access  public
     * @param   int $idArticle id of article to load
     * ne retourne rien 
     */
    function loadLightWeight($idArticle) {
    	
    	$signature = $this->_cache->generateID('loadLightWeight'.$idArticle);
    	$this->_objectId = $idArticle; 
    	if ($this->cacheExist($signature)) {
			$this->_objectMetier = $this->loadCache($signature);
            //return $this->_objectMetier;
		} else {
			$result = $this->_objectMetier->loadLightWeight($idArticle);
			if (!PEAR::isError($result)) {
				$this->saveCache($signature, $this->_objectMetier);
			}
			//return $result;
		}	
		
		//return $this->_objectMetier->loadLightWeight($idArticle);
    }

    // }}}

    // {{{ loadLightWeightIfStatut($idArticle, $statut)

    /**
     * This method is used to load an article from the database
     * selecting only small size fields from the DB
     * @access  public
     * @param   int $idArticle id of article to load
     * @param   String $statut of article to load
     */
    function loadLightWeightIfStatut($idArticle, $statut) {
    	
    	$signature = $this->_cache->generateID('loadLightWeightIfStatut'.$idArticle.$statut);
    	//$signature = 'loadLightWeightIfStatut'.$idArticle.$statut;
    	$this->_objectId = $idArticle;
    	if ($this->cacheExist($signature)) {
    		return $this->loadCache($signature);
    	} else {
    		$result = $this->_objectMetier->loadLightWeightIfStatut($idArticle, $statut);
    		if (!PEAR::isError($result)) {
    			$this->saveCache($signature, $result);
    		}
    		return $result;
    	}
    	
        //return $this->_objectMetier->loadLightWeightIfStatut($idArticle, $statut);
        
    }

    // }}}


    // {{{ delete()

    /**
     * This method is used to delete an article from the database
     * @access  public
     * @param   int $idArticle id of article to delete
     */

    function delete($idArticle) {
        $this->flushBothCache();
        return $this->_objectMetier->delete($idArticle);
        
    }

    // }}}

    // {{{ unlock()

    /**
     * This method unlock an Article
     * @access  public
     * @param   int $idArticle id of article to unlock
     */
    function unlock($idArticle, $connect_id_auteur) {

		return $this->_objectMetier->unlock($idArticle, $connect_id_auteur);

    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $idArticle id of article to load
     */

    function _fetchData($row) {

		return $this->_objectMetier->_fetchData($row);
        
    }

    // }}}

    // {{{ _fetchLightWeightData()

    /**
     * This method is used to fetch result set fields into the object fields
     * used with loadLightWeight
     * @access  private
     * @param   int $idArticle id of article to load
     * @see     loadLightWeight($idArticle)
     */
    function _fetchLightWeightData($row) {
		
		return $this->_objectMetier->_fetchLightWeightData($row);
		        
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all articles former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $this->flushBothCache();
        $this->_objectMetier->deleteMajDate($mydate);
        
    }

    // {{{ deleteArticleForStatut($statut, $maj)

    /**
     * This method is used to delete all deleted articles
     * @access  public
     */

    function deleteArticleForStatut($statut, $maj) {
        $this->flushBothCache();
		$this->_objectMetier->deleteArticleForStatut($statut, $maj);

    }

    // {{{ deleteAuteurs()

    /**
     * This method is used to delete all authors attached to this article
     * @access  public
     */

    function deleteAuteurs() {
        $this->flushAllCache();
		$this->_objectMetier->deleteAuteurs();

    }

    // }}}

    // {{{ deleteAuteur()

     /**
     * This method is used to delete a given author attached to this article
     * @param   int $authorId author to delete
     * @access  public
     */
    function deleteAuteur($authorId) {
        $this->flushAllCache();
		$this->_objectMetier->deleteAuteur($authorId);

    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptArticleIds($articles)

     /**
     * This method is used to delete authors not attached to a list of articleIds
     * @param   int list of rubriqueIds
     * @access  public
     */
    function deleteAllAuteurIdsExceptArticleIds($articles) {
        $this->flushAllCache();
		$this->_objectMetier->deleteAllAuteurIdsExceptArticleIds($articles);

    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $this->flushAllCache();
        $this->_objectMetier->deleteAllAuteurIdsExceptAuteurIds($auteurs);
        
    }

    // }}}

    // {{{ addAuteur()

     /**
     * This method is used to attach an author to this article
     * @param   int $authorId autor to attach
     * @access  public
     */
    function addAuteur($auteurId) {
        $this->flushAllCache();
        return $this->_objectMetier->addAuteur($auteurId);

    }

    // }}}

    // {{{ isAuthor()

     /**
     * This method determines whether or not a given author is an author
     * of this article
     * @param   int $auteurId author to check
     * @return  boolean
     * @access  public
     */
    function isAuthor($auteurId) {
        
       return $this->_objectMetier->isAuthor($auteurId);
        
    }

    // }}}

    // {{{ getRubriqueIdsByStatus()

     /**
     * This method is used to get all "rubrique" containing published articles
     * @param   String  status to look for
     * @param   boolean look for postdated articles ?
     * @return  mixed   result array of IDs or PEAR::Error object
     * @access  public
     */
    function getRubriqueIdsByStatus($statut, $postDated) {
        
        return $this->_objectMetier->getRubriqueIdsByStatus($statut, $postDated);
        
    }

    // }}}

    // {{{ getRubriqueIds()

     /**
     * This method is used to get all "rubrique" containing published articles
     * @access  public
     */
    function getRubriqueIds() {

		return $this->_objectMetier->getRubriqueIds();
		
    }

    // }}}

    // {{{ getMaxDateByRubriqueAndStatus()

    /**
     * This method is used to the latest date of a published article for a given rubrique
     * with a given status and a flag to determine whether or not to handle postdated articles
     * @param   int     $rubriqueId
     * @param   String  status to look for
     * @param   boolean look for postdated articles ?
     * @return  mixed   Date or PEAR::Error object
     * @access  public
     */
    function getMaxDateByRubriqueAndStatus($rubriqueId, $statut, $postDated) {

		return $this->_objectMetier->getMaxDateByRubriqueAndStatus($rubriqueId, $statut, $postDated);

    }

    // }}}

    // {{{ getRecentArticleIds()

    /**
     * This method returns an array of article ids, representing the 10 most recent ones
     *
     * @return  Array   containing the wished IDs
     * @access  public
     */

    function &getRecentArticleIds() {
        
        return $this->_objectMetier->getRecentArticleIds();

    }

    // }}}

    // {{{ updateSecteursForRubriques()

    /**
     * This method is used to update the sector racttached to different articles
     * @param   int     id sector
     * @param   array   Rubriques id list
     * @return  mixed   nothing or PEAR::Error object
     * @access  public
     */
    function updateSecteursForRubriques($secteurId, $listRubriques) {
        $this->flushAllCache();
		$this->_objectMetier->updateSecteursForRubriques($secteurId, $listRubriques);

    }

    // }}}

    // {{{ updateTradIdForTradId($idTradOld, $idTradNew)

    /**
     * This method is used to update the sector racttached to different articles
     * @param   int     id sector
     * @param   array   Rubriques id list
     * @return  mixed   nothing or PEAR::Error object
     * @access  public
     */
    function updateTradIdForTradId($idTradOld, $idTradNew) {
        $this->flushAllCache();
		$this->_objectMetier->updateTradIdForTradId($idTradOld, $idTradNew);

    }

    // }}}

    // {{{ updateAccepterForum()

    /**
     * This method is used to update the forum acceptation flag for an article subset
     * @param   String  update type
     * @param   boolean accept forum ?
     * @return  mixed   void or PEAR::Error object
     * @access  public
     */
    function updateAccepterForum($updateType, $acceptForum) {
        $this->flushAllCache();
		$this->_objectMetier->updateAccepterForum($updateType, $acceptForum);

    }

    // }}}

    // {{{ isPostDated()

    /**
     * This method tests whether or not this article is postdated.
     * @return  mixed   boolean or PEAR::Error object
     * @access  public
     */
    function isPostDated() {

		return $this->_objectMetier->isPostDated();

    }

    // }}}

    // {{{ hasLastModified()

    /**
     * This method tests whether a given author has last modified this article
     * @return  mixed   boolean or PEAR::Error object
     * @access  public
     */
    function hasLastModified($auteurId) {

		return $this->_objectMetier->hasLastModified($auteurId);

    }

    // }}}

    // {{{ getMaxDateHeure($id_rubrique,$statut, $post_dates)

    function getMaxDateHeure($id_rubrique,$statut, $post_dates = 'non') {

		return $this->_objectMetier->getMaxDateHeure($id_rubrique,$statut, $post_dates);

    }

    // }}}

    // {{{ getLastModifiedUserName()

    /**
     * This method returns the last contributor of this article name
     * @return  mixed   String or PEAR::Error object
     * @access  public
     */
    function getLastModifiedUserName() {

		return $this->_objectMetier->getLastModifiedUserName();

    }

    // }}}

    // {{{ whenWasModified

    function whenWasModified() {
        return $this->_objectMetier->whenWasModified();
    }

    // }}}

    // {{{ howManyWritten()

    /**
     * This method returns the number of article written by a given author
     * @return  int
     * @access  public
     */
    function howManyWritten($authorId, $allowedStatus = '') {

		return $this->_objectMetier->howManyWritten($authorId, $allowedStatus);

    }

    // }}}

    // {{{ howManyPublished()

    /**
     * This method returns the number of published articles
     * @return  int
     * @access  public
     */
    function howManyPublished() {

		return $this->_objectMetier->howManyPublished();

    }

    // }}}


    // {{{ howManyProposed()

    /**
     * This method returns the number of proposed articles
     * @return  int
     * @access  public
     */
    function howManyProposed() {

		return $this->_objectMetier->howManyProposed();

    }

    // }}}

    // {{{ hasDocument()

    /**
     * This method tests whether or not this article contains any document
     * @return  boolean
     * @access  public
     */
    function hasDocument($documentId) {

		return $this->_objectMetier->hasDocument($documentId);

    }

    // }}}

    // {{{ getToday()

    /**
     * Returns an array of Article representing
     * the current day published articles.
     *
     * This method is abstract and will be implemented
     * in a future version, when the data model has been
     * updated.
     *
     * @return Array of Article
     * @param $month
     * @param $year
     * @access public
     */

    function &getToday($month, $year) {

		return $this->_objectMetier->getToday($month, $year);

    }

    // }}}

    // {{{ getPublishedAndPopular()

    /**
     * This method returns an array of Article objects that are published
     * and that have already been visited
     *
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getPublishedAndPopular() {

		return $this->_objectMetier->getPublishedAndPopular();

    }

    // }}}

    // {{{ getRecentPublishedAndPopularButNotSeen()

    /**
     * This method returns an array of Article objects that are published
     * and that have already been visited
     *
     * @param   String  $recentIds comma separated ids of recent articles
     * @param   String  $seenIds comma separated ids of seen articles
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getRecentPublishedAndPopularButNotSeen($recentIds, $seenIds) {

		return $this->_objectMetier->getRecentPublishedAndPopularButNotSeen($recentIds, $seenIds);

    }

    // }}}

    // {{{ getPublishedAndPopularFromBeginning()

    /**
     * This method returns an array of Article objects
     *
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getPublishedAndPopularFromBeginning() {

		return $this->_objectMetier->getPublishedAndPopularFromBeginning();

    }

    // }}}

    // {{{ getOpened()

    /**
     * Returns an array of Article representing
     * the currently opened articles for a given author
     *
     * This method is abstract and will be implemented
     * in a future version, when the data model has been
     * updated.
     *
     * @return Array of Article
     * @param int $authorId
     * @access public
     */

    function &getOpened($authorId) {

		return $this->_objectMetier->getOpened($authorId);

    }

    // }}}

    // {{{ getExtract()

    /**
     * Returns an extract of this article instance
     *
     * @return String representing the extract of the article
     * @access public
     */

    function getExtract() {

		return $this->_objectMetier->getExtract();

    }

    // }}}

    // {{{ updateVisites())

    /**
     * Updates a set of articles visites
     *
     * @param array $articleIds containing all article IDs of articles to update
     * @param int $visites representing the new value for visites
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */

    function updateVisites($articleIds, $visits) {

		return $this->_objectMetier->updateVisites($articleIds, $visits);

    }

    // }}}

    // {{{ computePopularity())

    /**
     * Updates all articles to compute new popularity value
     *
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */

    //Dsol pour le code, mais c'est toujours parail : on essaye de garder
    //au maximum le code original...

    function computePopularity() {

		return $this->_objectMetier->computePopularity();

    }

    // }}}

    // {{{ getAuteurIdsForArticleId($articleId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $articleId
     * @access public
     */

    function &getAuteurIdsForArticleId($articleId) {

		return $this->_objectMetier->getAuteurIdsForArticleId($articleId);

    }

    // }}}

    // {{{ getAllForRubriqueIds($rubriques)

    /**
     * Returns an array of Article.
     *
     *
     * @return Array of Article
     * @param $rubriques
     * @access public
     */

    function &getAllForRubriqueIds($rubriques) {

		return $this->_objectMetier->getAllForRubriqueIds($rubriques);

    }

    // }}}

    // {{{ getArticleIdsForAuteurId($auteurId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $auteurId
     * @access public
     */

    function &getArticleIdsForAuteurId($auteurId) {

		return $this->_objectMetier->getArticleIdsForAuteurId($auteurId);

    }

    // }}}

    // {{{ getAuteursForArticleId($articleId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $articleId
     * @access public
     */

    function &getAuteursForArticleId($articleId) {

		return $this->_objectMetier->getAuteursForArticleId($articleId);

    }

    // }}}

    // {{{ howManyArticleForMot($conf_mot, $aff_articles, $statut)

    function howManyArticleForMot($conf_mot, $aff_articles, $statut)    {

		return $this->_objectMetier->howManyArticleForMot($conf_mot, $aff_articles, $statut);

    }
    // }}}

    // {{{ howManyArticlesForStatut($statut)

    function howManyArticlesForStatut($statut) {

		return $this->_objectMetier->howManyArticlesForStatut($statut);

    }
    // }}}

    // {{{ getAllDocumentsLies($id_article, $mode)

    /**
     * Returns an array of Document.
     *
     *
     * @return Array of Document
     * @param $id_article
     * @access public
     */

    function &getAllDocumentsLies($id_article, $mode, $docs_exclus = "", $id_doublons = null) {

		return $this->_objectMetier->getAllDocumentsLies($id_article, $mode, $docs_exclus, $id_doublons);

    }

    // }}}


    function &getAllForArticleIds($ids) {

		return $this->_objectMetier->getAllForArticleIds($ids);

    }

    // }}}

    function &getAllArticleIds() {

		return $this->_objectMetier->getAllArticleIds();

    }

    function &getAllForRubriqueId($rubriqueId, $statut = null) {

		return $this->_objectMetier->getAllForRubriqueId($rubriqueId, $statut);

    }

    // }}}

	// {{{ addBookmark($id_auteur)

	function addBookmark($id_auteur) {
        // ? 
        $this->flushAllCache();
		return $this->_objectMetier->addBookmark($id_auteur);

	}
	
	// }}}

	// {{{ deleteBookmark($id_auteur)

	function deleteBookmark($id_auteur) {
        // ? 
        $this->flushAllCache();
		$this->_objectMetier->deleteBookmark($id_auteur);

	}
	
	// }}}

	// {{{ isBookmark($id_auteur)

	function isBookmark($id_auteur) {
		
		return $this->_objectMetier->isBookmark($id_auteur);

	}
	
	// }}}
	
    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Article.
     *
     * @return Array of Article
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut, $orderBy = null, $desc = null) {

		$signature = $this->_cache->generateID('getAllForStatut'.$statut.$orderBy.$desc);
        if ($this->generalCacheExist($signature)) {
        	return $this->loadGeneralCache($signature);
        } else {
        	$result = $this->_objectMetier->getAllForStatut($statut, $orderBy, $desc);
        	if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
		
		
		//return $this->_objectMetier->getAllForStatut($statut, $orderBy, $desc);

    }

    // }}}	

    // {{{ getArticlesOfTheDay($date)

    /**
     * Returns an array of Articles Of The Day..
     *
     * @return Array of Article
     * @param $date
     * @access public
     */

    function &getArticlesOfTheDay($date) {

		return $this->_objectMetier->getArticlesOfTheDay($date);

    }

    // }}}

	// {{{ getAllMotherLang()

    /**
     * This method return la langue des rubriques mere pour chaque article fils
     * @return	Array
     */

    function getAllMotherLang() {
        
		return $this->_objectMetier->getAllMotherLang();
        
    }

	// }}}

	// {{{ getAllArticleForStatutsOrderBy

    /**
     * This method return la liste des rubriques
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getAllArticleForStatutsOrderBy($statuts, $critere = 'titre') {
        /*
        $signature = $this->_cache->generateID('getAllArticleForStatutsOrderBy'.$statuts.$critere);
        //$signature = 'getAllArticleForStatutsOrderBy'.$statuts.$critere;
        if ($this->generalCacheExist($signature)) {
			//echo 'LE CACHE EXISTE<br /><br />';
			return $this->loadGeneralCache($signature);			
		} else {
			//echo 'LE CACHE N\'EXISTE PAS<br /><br />';
			$result = $this->_objectMetier->getAllArticleForStatutsOrderBy($statuts, $critere);
			if (!PEAR::isError($result)) {
				$this->saveGeneralCache($signature, $result);
			}
			return $result;
		}
        */
        return $this->_objectMetier->getAllArticleForStatutsOrderBy($statuts, $critere);
        
    }

	// }}}

    // {{{ howManyArticleForTradID($id_trad)

    function howManyArticleForTradID($id_trad) {

		return $this->_objectMetier->howManyArticleForTradID($id_trad);

    }
    // }}}

    // {{{ howManyXForRubriqueId($critere)

    function howManyXForRubriqueId($critere) {

		return $this->_objectMetier->howManyXForRubriqueId($critere);

    }
    // }}}

    // {{{ howManyX($critere)

    function howManyX($critere) {

		return $this->_objectMetier->howManyX($critere);

    }
    // }}}

    // {{{ howManyXGroupByLang($critere)

    function howManyXGroupByLang($critere) {

		return $this->_objectMetier->howManyXGroupByLang($critere);

    }
    // }}}

	// {{{ getAllArticleForTradId

    /**
     * This method return la liste des articles
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getAllArticleForTradId($tradId) {
        
		return $this->_objectMetier->getAllArticleForTradId($tradId);

    }

	// }}}
    
	// {{{ getArticlesForStatutAndAuteur($statut, $auteurId)

    /**
     * This method return la liste des articles prpars par un auteur donn
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getArticlesForStatutAndAuteur($statut, $auteurId) {

        $signature = $this->_cache->generateID('getArticlesForStatutAndAuteur'.$statut.$auteurId);
        if ($this->generalCacheExist($signature)) {
        	return $this->loadGeneralCache($signature);
        } else {
        	$result = $this->_objectMetier->getArticlesForStatutAndAuteur($statut, $auteurId);
        	if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
		
		// return $this->_objectMetier->getArticlesForStatutAndAuteur($statut, $auteurId);
    }

	// }}}

	// {{{ getArticlesForRubriqueId($rubriqueId, $orderBy = null, $desc = null)

    /**
     * This method return la liste des articles d'une rubrique
     * @return	Array
     */
	// pas possible de mettre ca en cache ..... 
    function &getArticlesForRubriqueId($rubriqueId, $orderBy = null, $desc = null) {

		return $this->_objectMetier->getArticlesForRubriqueId($rubriqueId, $orderBy, $desc);

    }

    // }}}


	// {{{ getArticlesForRubriqueIdAndAuteurIdAndStatuts($rubriqueId, $auteurId)

    /**
     * This method return la liste des articles d'une rubrique en fonction de l'auteur ou de leurs statuts.
     * @return	Array
     */

    function &getArticlesForRubriqueIdAndAuteurIdAndIDontKnowWhyButIloveYou($rubriqueId, $auteurId) {

		return $this->_objectMetier->getArticlesForRubriqueIdAndAuteurIdAndIDontKnowWhyButIloveYou($rubriqueId, $auteurId);

    }

    // }}}
    
    // {{{ isStatutDoneArticleByAuteur($statut, $auteurId)

    /**
     * This method returns
     * @return  int
     * @access  public
     */
    function isStatutDoneArticleByAuteur($statut, $auteurId) {

		return $this->_objectMetier->isStatutDoneArticleByAuteur($statut, $auteurId);

    }

    // }}}    

	// {{{ getLangUsed()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &getLangUsed() {

		return $this->_objectMetier->getLangUsed();

    }

    // }}}
    
	// {{{ calculatePublishedRubrique()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &calculatePublishedRubrique($trad_lang) {

		return $this->_objectMetier->calculatePublishedRubrique($trad_lang);

    }

    // }}}
    
    // {{{ calculatepublishedRubrique()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &calculateNoTraductionForRubrique($trad_lang) {

		return $this->_objectMetier->calculateNoTraductionForRubrique($trad_lang);

    }

    // }}}

    // {{{ getTradStatistics()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &getTradStatistics($trad_lang) {

		return $this->_objectMetier->getTradStatistics($trad_lang);

    }

    // }}}
    
    
    // {{{ switchVersion
    
    /**
     * This method switch an article with another version of itself
     * @return  Void  
     */ 
    
    function switchVersion($id_article, $id_article_version) {
    
        return $this->_objectMetier->switchVersion($id_article, $id_article_version);
    
    }
    
    // }}}
    
    // {{{ getAllForVersion
    
    /**
     * This method return an all articles for one version
     */
    function getAllForVersion($orderby) {
    
        return $this->_objectMetier->getAllForVersion($orderby);
    
    }
    
    /// }}}
    
    
    // {{{

    /**
     * fabrique un historique
     * @access public
     */

    function create_historique () {
    
        return $this->_objectMetier->create_historique();
        
    }
    
    // }}}
    
    // {{{
    
    /**
    * compte le nbre dentree ds la table historique pour cet article
    * @access public
    */
    
    function countHistorique() {
        
        return $this->_objectMetier->countHistorique();
        
    }
    
    // }}}
    
    
    // {{{
    
    /**
    * modifie l'article  partir d'un historique
    */
    function switchHistorique ($id_article_historique) {
        
        return $this->_objectMetier->switchHistorique ($id_article_historique);
        
    }
    
    // }}}
}
?>