<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                                              |
// +----------------------------------------------------------------------+
//
// Base class for Article List Data cache abstraction.
//


require_once dirname(__FILE__)."/AgoraCache.php";

class articleListData_cache extends AgoraCache {


    // {{{ constructor

    /**
     * articleListData_cache constructor.
     *
     * @access public
     */

    function articleListData_cache ($cacheParams) {
        $this->_objectMetier = &recuperer_instance_list_articles(true);
        //var_dump ($this->_objectMetier);
        $this->_objectType = 'article';
        //var_dump ($this->_objectMetier);
        $par = get_parent_class($this);
        $res = $this->$par($cacheParams);
    }

    // }}}



    // {{{
    // cette fct ecrit sur la sortie :-(
    // il faut stocker la sortie et le retour de la fct
    // et il y a 2 params en global :-(

    function displayHTMLList($titre_table, $queryType, $params = array(), $afficher_visites = false, $afficher_auteurs = true, $toujours_afficher = false, $afficher_cadre = true, $firstElement = 0, $lastElement = 0, $url = 'articles.php3', $urlParams = '') {
        global $connect_id_auteur, $connect_statut;
        $signature = $this->_cache->generateID('displayHTMLList'.$titre_table.$queryType. $params . $afficher_visites . $afficher_auteurs .$toujours_afficher .$afficher_cadre . $firstElement .$lastElement .$url .$urlParams. $connect_id_auteur.$connect_statut);
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            $datas =  $this->loadGeneralCache($signature); // un tableau est retourne
            echo $datas[0];
            return $datas[1];           
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $datas = array ();
            ob_start();
            $datas[1] = $this->_objectMetier->displayHTMLList($titre_table, $queryType, $params, $afficher_visites, $afficher_auteurs, $toujours_afficher, $afficher_cadre, $firstElement, $lastElement, $url, $urlParams);
            $datas[0] = ob_get_contents();
            ob_end_clean();
            ob_start();
            echo $datas[0];  
            // sauvegarde des donnes
            $this->saveGeneralCache($signature, $datas);
            return $datas[1];
        }
    }

    // }}}

    // {{{ _articleHasPetition($articleId)


    function _articleHasPetition($articleId) {
        return $this->_objectMetier->_articleHasPetition($articleId);
    }

    // }}}

    // {{{ _getArticleAuthors($articleId)

    function _getArticleAuthors($articleId) {
    	
    	$signature = $this->_cache->generateID('_getArticleAuthors'.$articleId);
    	//$signature = '_getArticleAuthors'.$articleId;
    	$this->_objectId = $articleId; 
    	if ($this->cacheExist($signature)) {
			return $this->loadCache($signature);
		} else {
			$result = $this->_objectMetier->_getArticleAuthors($articleId);
			if (!PEAR::isError($result)) {
				$this->saveCache($signature, $result);
			}
			return $result;
		}	
    
        //return $this->_objectMetier->_getArticleAuthors($articleId);
    }

    // }}}

    // {{{ _fillQueries()

    
    function _fillQueries() {
        return $this->_objectMetier->_fillQueries();
    }

    // }}}

}
?>