<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour  <omansour@clever-age.com>                   |
// +----------------------------------------------------------------------+
//


require_once dirname(__FILE__)."/AgoraCache.php";

class groupe_mot_cache extends AgoraCache {

    // {{{ properties

  

    // {{{ constructor

    /**
     * groupe_mot_cache constructor.
     *
     * @access public
     */

    function groupe_mot_cache ($cacheParams) {
        $this->_objectMetier = &recuperer_instance_groupe_mot(true);
        $this->_objectType = 'groupe_mot';
        
        $par = get_parent_class($this);
         $res = $this->$par($cacheParams);
    }

    // }}}

    // {{{ getGroupeId()

    /**
     * Returns the Group ID
     * @return  int
     * @access  public
     */

    function getGroupeId() {
        return $this->_objectMetier->_groupeId;
    }

    // }}}

    // {{{ setGroupeId()

    /**
     * Sets the Groupe ID
     * @param   int
     * @access  public
     */

    function setGroupeId($groupeId) {
        $this->_objectMetier->_groupeId = $groupeId;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the group word title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_objectMetier->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the groupe word title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_objectMetier->_titre = $this->_objectMetier->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getUnSeul()

    /**
     * Returns the UnSeul
     * @return  String
     * @access  public
     */

    function getUnSeul() {
        return $this->_objectMetier->_unSeul;
    }

    // }}}

    // {{{ setUnSeul()

    /**
     * Sets the UnSeul
     * @param   String
     * @access  public
     */

    function setUnSeul($unSeul) {
        $this->_objectMetier->_unSeul = $this->_objectMetier->corriger_caracteres($unSeul);
    }

    // }}}

    // {{{ getObligatoire()

    /**
     * Returns the obligatory
     * @return  String
     * @access  public
     */

    function getObligatoire() {
        return $this->_objectMetier->_obligatoire;
    }

    // }}}

    // {{{ setObligatoire()

    /**
     * Sets the obligatory
     * @param   String
     * @access  public
     */

    function setObligatoire($obligatoire) {
        $this->_objectMetier->_obligatoire = $this->_objectMetier->corriger_caracteres($obligatoire);
    }

    // }}}

    // {{{ getCm()

    /**
     * Returns the cm
     * @return  String
     * @access  public
     */

    function getCm() {
        return $this->_objectMetier->_cm;
    }

    // }}}

    // {{{ setCm()

    /**
     * Sets the cm
     * @param   String
     * @access  public
     */

    function setCm($cm) {
        $this->_objectMetier->_cm = $this->_objectMetier->corriger_caracteres($cm);
    }

    // }}}

    // {{{ getArticles()

    /**
     * Returns the articles
     * @return  String
     * @access  public
     */

    function getArticles() {
        return $this->_objectMetier->_articles;
    }

    // }}}

    // {{{ setArticles()

    /**
     * Sets the articles
     * @param   String
     * @access  public
     */

    function setArticles($articles) {
        $this->_objectMetier->_articles = $this->_objectMetier->corriger_caracteres($articles);
    }

    // }}}

    // {{{ getBreves()

    /**
     * Returns the breves
     * @return  String
     * @access  public
     */

    function getBreves() {
        return $this->_objectMetier->_breves;
    }

    // }}}

    // {{{ setBreves()

    /**
     * Sets the breves
     * @param   String
     * @access  public
     */

    function setBreves($breves) {
        $this->_objectMetier->_breves = $this->_objectMetier->corriger_caracteres($breves);
    }

    // }}}


    // {{{ getRubriques()

    /**
     * Returns the rubriques
     * @return  String
     * @access  public
     */

    function getRubriques() {
        return $this->_objectMetier->_rubriques;
    }

    // }}}

    // {{{ setRubriques()

    /**
     * Sets the rubriques
     * @param   String
     * @access  public
     */

    function setRubriques($rubriques) {
        $this->_objectMetier->_rubriques = $this->_objectMetier->corriger_caracteres($rubriques);
    }

    // }}}

    // {{{ getSyndic()

    /**
     * Returns the syndic
     * @return  String
     * @access  public
     */

    function getSyndic() {
        return $this->_objectMetier->_syndic;
    }

    // }}}

    // {{{ setSyndic()

    /**
     * Sets the syndic
     * @param   String
     * @access  public
     */

    function setSyndic($syndic) {
        $this->_objectMetier->_syndic = $this->_objectMetier->corriger_caracteres($syndic);
    }

    // }}}

    // {{{ getSyndic()

    /**
     * Returns the auteurs
     * @return  String
     * @access  public
     */

    function getAuteurs() {
        return $this->_objectMetier->_auteurs;
    }

    // }}}

    // {{{ setAuteurs()

    /**
     * Sets the auteurs
     * @param   String
     * @access  public
     */

    function setAuteurs($auteurs) {
        $this->_objectMetier->_auteurs = $this->_objectMetier->corriger_caracteres($auteurs);
        $this->_objectMetier->setCm($this->_objectMetier->_auteurs);
    }

    // }}}

    // {{{ getforum()

    /**
     * Returns the forum
     * @return  String
     * @access  public
     */

    function getforum() {
        return $this->_objectMetier->_forum;
    }

    // }}}

    // {{{ setforum()

    /**
     * Sets the forum
     * @param   String
     * @access  public
     */

    function setforum($forum) {
        $this->_objectMetier->_forum = $this->_objectMetier->corriger_caracteres($forum);
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the word update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_objectMetier->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the word update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_objectMetier->_majDate = $majDate;
    }

    // }}}


    // {{{ getProfils()

    /**
     * Returns the profils
     * @return  int
     * @access  public
     */

    function getProfils() {
        return $this->_objectMetier->_profils;
    }

    // }}}

    // {{{ setProfils()

    /**
     * Sets the profils
     * @param   int
     * @access  public
     */

    function setProfils($profils) {
        $this->_objectMetier->_profils = $profils;
    }

    // }}}



    // {{{ create()

    function create() {
        
        $this->flushBothCache();
        return $this->_objectMetier->create();
    }

    // }}}

    // {{{ update()

    function update() {
        $this->flushBothCache();
        return $this->_objectMetier->update();
    }

    // }}}

    // {{{ load()

    function load($idGroupe) {
        return $this->_objectMetier->load($idGroupe);
    }

    // }}}

    // {{{ delete()

    function delete($idGroupe) {
        $this->flushBothCache();
        return $this->_objectMetier->delete($idGroupe);
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        return $this->_objectMetier->_fetchData($row);
    }

    // }}}



    // {{{ deleteForTitleAndNotGroupeId($titre, $id_groupe)

    function deleteForTitleAndNotGroupeId($titre, $id_groupe) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteForTitleAndNotGroupeId($titre, $id_groupe);
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all word groups former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteMajDate($myDate);
    }

    // }}}

    // {{{ getAllGroupe()

    /**
     * Returns an array of Group.
     * _GENERAL_ method 
     *
     * @return Array of Group
     * @param $seidObjet
     * @access public
     */

    function &getAllGroupe($critere = 'id_groupe') {
        $signature = $this->_cache->generateID('getAllGroupe'.$critere);
        //$signature = 'getAllGroupe'.$critere;
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature);           
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllGroupe($critere);
            if (!PEAR::isError($result)) {  
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
        
        
        // inutile dans cette methode 
        // if ($this->generalCacheExist(($signature)) $this->_objectMetier->getAllGroupe($critere);

    }

    // }}}

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $seidObjet
     * @access public
     */

    function &getAllForTitre($titre) {
        return $this->_objectMetier->getAllForTitre($titre);
    }

    // }}}

    // {{{ getAllForforumAndTableAndGroupId($forum, $table, $selectionner_groupe)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $forum
     * @param $table
     * @param $selectionner_groupe
     * @access public
     */

    function &getAllForforumAndTableAndGroupId($forumValue, $table, $selectionner_groupe) {
        return $this->_objectMetier->getAllForforumAndTableAndGroupId($forumValue, $table, $selectionner_groupe);
    }

    // }}}

    // {{{ getAllForTableAndProfil($table, $tableValue, $connect_profil)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_profil
     * @access public
     */

    function &getAllForTableAndProfil($table, $tableValue, $connect_profil) {
        return $this->_objectMetier->getAllForTableAndProfil($table, $tableValue, $connect_profil);
    }

    // }}}

    // {{{ getAllForTableAndStatutAndObligatoryAndIdGroupe($table, $tableValue, $connect_statut, $connect_statutValue, $obligatoire, $id_groupes_vus)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_statut
     * @param $connect_statutValue
     * @param $obligatoire
     * @param $id_groupes_vu
     * @access public
     */

    function &getAllForTableAndStatutAndObligatoryAndIdGroupe($table, $tableValue, $connect_profil, $obligatoire, $id_groupes_vus)    {
        return $this->_objectMetier->getAllForTableAndStatutAndObligatoryAndIdGroupe($table, $tableValue, $connect_profil, $obligatoire, $id_groupes_vus);
    }

    // }}}

    // {{{ getAllForTableAndStatutAndUnSeulAndIdGroupe($table, $tableValue, $connect_statut, $connect_statutValue, $unSeul, $id_groupes_vus)

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $table
     * @param $tableValue
     * @param $connect_statut
     * @param $connect_statutValue
     * @param $unSeul
     * @param $id_groupes_vu
     * @access public
     */

    function &getAllForTableAndStatutAndUnSeulAndIdGroupe($table, $tableValue, $connect_profil, $unSeul, $id_groupes_vus)    {
        return $this->_objectMetier->getAllForTableAndStatutAndUnSeulAndIdGroupe($table, $tableValue, $connect_profil, $unSeul, $id_groupes_vus);
    }

    // }}}

    // {{{ howManyInGroup

    /**
     * Returns the number of keywords for a given keyword group
     * @return  int     number of keyword in group
     * @access  public
     */

    function howManyInGroup() {
        return $this->_objectMetier->howManyInGroup();

    }

    // }}}

    // {{{ function htmlSelect()

    /**
     * This method returns the html select box for the keyword trees within this group
     * @param   String    selectName  HTML NAME attribute of the SELECT tag
     * @return  String
     * @access  public
     */

    function htmlSelect($id_mot = 'root', $selectName = 'id_mot_subnode') {
        return $this->_objectMetier->htmlSelect($id_mot, $selectName);
    }

    // }}}

    // {{{ getMotArbre()

    /**
     *
     *
     *
     *
     */

    function &getMotArbre() {
        return $this->_objectMetier->getMotArbre();
    }

    // }}}

    // {{{ _getRootIds()

    /**
     * This method returns all root keyword ids within this group
     * @return  array
     * @access  private
     */
    function &_getRootIds() {
        return $this->_objectMetier->_getRootIds();
    }

    // }}}

    // {{{ isManagedByProfil($profil)

    function isManagedByProfil($profil) {
        return $this->_objectMetier->isManagedByProfil($profil);
    }

    // }}}
    
	// {{{ getAllGroupeAffectedTo($type)

    function getAllGroupeAffectedToPersonnalisation($type, $groupeIds = '') {
        return $this->_objectMetier->getAllGroupeAffectedToPersonnalisation($type, $groupeIds);
    }

    // }}}

}
?>