<?php
///
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                                              |
// +----------------------------------------------------------------------+
//
// Base class for mot_cache business persistence abstraction.
//

require_once dirname(__FILE__)."/AgoraCache.php";


/**
 * mot_cache 
 * @author 	Olivier Mansour :-)
 * @access	public
 */
 
class mot_cache extends AgoraCache {

    // {{{ properties

    // }}}

    

    // {{{ constructor

    /**
     * mot_cache constructor.
     *
     * @access public
     */

    function mot_cache($cacheParams) {
        $this->_objectMetier = &recuperer_instance_mot(true);
        $this->_objectType = 'mot';
        
        $par = get_parent_class($this);
        $res = $this->$par($cacheParams);
    }

    // }}}

    // {{{ getMotId()

    /**
     * Returns the Mot ID
     * @return  int
     * @access  public
     */

    function getMotId() {
        return $this->_objectMetier->_motId;
    }

    // }}}

    // {{{ setMotId()

    /**
     * Sets the Mot ID
     * @param   int
     * @access  public
     */

    function setMotId($motId) {
        $this->_objectMetier->_motId = $motId;
    }

    // }}}

    // {{{ getType()

    /**
     * Returns the Type
     * @return  String
     * @access  public
     */

    function getType() {
        return $this->_objectMetier->_type;
    }

    // }}}

    // {{{ setType()

    /**
     * Sets the Type
     * @param   String
     * @access  public
     */

    function setType($type) {
        $this->_objectMetier->_type = $this->_objectMetier->corriger_caracteres($type);
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the word title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_objectMetier->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the word title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_objectMetier->_titre = $this->_objectMetier->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getDescriptif()

    /**
     * Returns the word description
     * @return  String
     * @access  public
     */

    function getDescriptif() {
        return $this->_objectMetier->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    /**
     * Sets the word description
     * @param   String
     * @access  public
     */

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->_objectMetier->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the word text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_objectMetier->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the word text
     * @param   String
     * @access  public
     */

    function setTexte($texte) {
        $this->_objectMetier->_texte = $this->_objectMetier->corriger_caracteres($texte);
    }

    // }}}

    // {{{ getGroupeId()

    /**
     * Returns the Group ID
     * @return  int
     * @access  public
     */

    function getGroupeId() {
        return $this->_objectMetier->_groupeId;
    }

    // }}}

    // {{{ setGroupeId()

    /**
     * Sets the Group ID
     * @param   int
     * @access  public
     */

    function setGroupeId($groupeId) {
        $this->_objectMetier->_groupeId = $groupeId;
    }

    // }}}

    // {{{ getMajDate()

    /**
     * Returns the word update date
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_objectMetier->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Sets the word update date
     * @param   Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_objectMetier->_majDate = $majDate;
    }

    // }}}

    // {{{ getExtra()

    /**
     * Returns the word extra fields
     * @return  String
     * @access  public
     */

    function getExtra() {
        return $this->_objectMetier->_extra;
    }

    // }}}

    // {{{ setExtra()

    /**
     * Sets the word extra fields
     * @param   String
     * @access  public
     */

    function setExtra($extra) {
        $this->_objectMetier->_extra = $extra;
    }

    // }}}

    // {{{ _getNestedSet()

    /**
     * Returns the reference to the technical nested set object.
     * @return  DB_NestedSet
     * @access  private
     */

    function &_getNestedSet() {
        return $this->_objectMetier->_nestedSet;
    }

    // }}}

    // {{{ _setNestedSet()

    /**
     * Sets the technical nested set used for tree manipulation.
     * @param   DB_NestedSet_DB PEAR::DB implementation for compatibility
     *                          with this abstraction layer
     * @access private
     */

    function _setNestedSet(&$nestedSet) {
        $this->_objectMetier->_nestedSet = &$nestedSet;
    }

    // }}}

    // {{{ create()

    function create($motId = null, $specificTTL = null) {
        $this->flushBothCache();
        return $this->_objectMetier->create($motId, $specificTTL);
        
    }

    // }}}

    // {{{ update()

    function update() {
        $this->flushBothCache();
        return $this->_objectMetier->update();
    }

    // }}}

    // {{{ load()

    function load($idMot) {
        //echo 'load '.$idMot;
        $this->_objectId = $idMot; // on utilise pas le cache general 
        $signature = $this->_cache->generateID('load'.$idMot);
        if ($this->cacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            $this->_objectMetier = $this->loadCache($signature); // je dois charger mon objet metier
            return $this->_objectMetier;
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->load($idMot);
            if (!PEAR::isError($result)) {
                $this->saveCache($signature, $this->_objectMetier);
            }
            return $result;
        }
        
        
    }

    // }}}

    // {{{ delete()

    function delete($idMot) {
        $this->flushBothCache();
        return $this->_objectMetier->delete($idMot);
        
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        
        return $this->_objectMetier->_fetchDate($row);
        
    }

    // }}}

    // {{{ deleteMajDate($myDate)

    /**
     * This method is used to delete all words former to mydate
     * @access  public
     */

    function deleteMajDate($myDate) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteMajDate($myDate);
        
    }

    // }}}

    // {{{ getAllMotIds()

    function getAllMotIds() {
        $signature = $this->_cache->generateID('getAllMotIds');
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature);
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllMotIds();
            if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
        //return $this->_objectMetier->getAllMotIds();
        
    }

    // }}}

    // {{{ getAllTypes()

    function getAllTypes() {
        $signature = $this->_cache->generateID('getAllTypes');
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature);
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllTypes();
            if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
        //return $this->_objectMetier->getAllTypes();
        
   }

    // }}}

    // {{{ updateNullType($newType)

    function updateNullType($newType) {
        $this->flushBothCache();
        return $this->_objectMetier->updateNullType($newType);
        
    }

    // }}}

    // {{{ updateGroupeIdForType($id_groupe, $type)

    function updateGroupeIdForType($id_groupe, $type) {
        $this->flushBothCache(); 
        return $this->_objectMetier->updateGroupeIdForType($id_groupe, $type);
        
    }

    // }}}

    // {{{ updateTypeForGroupeId($type, $id_groupe)

    function updateTypeForGroupeId($change_type, $id_groupe) {
         $this->flushBothCache();
         return $this->_objectMetier->updateTypeForGroupeId($change_type, $id_groupe);
        
    }

    // }}}

    // {{{ addMot($table, $id_table, $id_mot, $id_table_value)

    function addMot($table, $id_table, $id_mot, $id_table_value) {
        $this->flushBothCache();
        return $this->_objectMetier->addMot($table, $id_table, $id_mot, $id_table_value);
        
    }

    // }}}

    // {{{ deleteForTitle($titre)

    function deleteForTitle($titre) {
         $this->flushBothCache();
         return $this->_objectMetier->deleteForTitle($titre);

    }

    // }}}

    // {{{ deleteMotTable($table, $id_table, $id_message, $supp_mot = -1)

    function deleteMotTable($table, $id_table, $id_message, $supp_mot = -1) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteMotTable($table, $id_table, $id_message, $supp_mot);

        
    }

    // }}}

    // {{{ deleteMotTableForTableIdNotIn($table, $id_table, $values)

    function deleteMotTableForTableIdNotIn($table, $id_table, $values) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteMotTableForTableIdNotIn($table, $id_table, $values) ;
        
    }

    // }}}

    // {{{ deleteForTitleAndMaj($titre, $mydate)

    function deleteForTitleAndMaj($titre, $mydate) {
        $this->flushBothCache();
        return $this->_objectMetier->deleteForTitleAndMaj($titre, $mydate);

    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTable($table, $id_table, $id_objet)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &getAllFromMotsAndAnotherTable($table, $id_table, $id_objet, $orderBy = false) {
        $signature = $this->_cache->generateID('getAllFromMotsAndAnotherTable'.$table.$id_table.$id_objet.$orderBy);
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature); // je dois charger mon objet metier
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllFromMotsAndAnotherTable($table, $id_table, $id_objet, $orderBy);
            if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTableAndGroupId($table, $id_table, $id_objet, $id_groupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &getAllFromMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe) {
        $signature = $this->_cache->generateID('getAllFromMotsAndAnotherTableForGroupId'.$table.$id_table.$id_objet.$id_groupe);
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature); // je dois charger mon objet metier
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllFromMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe);
            if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
        //return $this->_objectMetier->getAllFromMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe);
        
    }

    // }}}

    // {{{ getAllFromMotsAndAnotherTableAndGroupId($table, $id_table, $id_objet, $id_groupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $table
     * @param $id_table
     * @param $id_objet
     * @access public
     */

    function &hasMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe) {
        
        return $this->_objectMetier->hasMotsAndAnotherTableForGroupId($table, $id_table, $id_objet, $id_groupe);
        
    }

    // }}}

    // {{{ getAllFromAnotherTable($table, $id_table, $id_mot)

    /**
     * Returns an array of Mots_table.
     *
     *
     * @return Array of MotTable
     * @param $table
     * @param $id_table
     * @param $id_mot
     * @access public
     */

    function &getAllFromAnotherTable($table, $id_table, $id_mot) {
        
        return $this->_objectMetier->getAllFromAnotherTable($table, $id_table, $id_mot);
        
    }

    // }}}

    // {{{ getAllForForumId($id_message)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllForForumId($id_message) {
        
        return $this->_objectMetier->getAllForForumId($id_message);
        
    }

    // }}}

    // {{{ getAllMotIdsForRubrique()

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForRubrique() {
        
        return $this->_objectMetier->getAllMotIdsForRubrique();
    }

    // }}}

    // {{{ getAllForGroupIdAndMotId($id_groupe, $les_mots = null)

    function &getAllForGroupIdAndMotId($id_groupe, $les_mots = null) {
        $signature = $this->_cache->generateID('getAllForGroupIdAndMotId'.$id_groupe.$les_mots);
        if ($this->generalCacheExist($signature)) {
            //echo 'LE CACHE EXISTE<br /><br />';
            return $this->loadGeneralCache($signature); 
        } else {
            //echo 'LE CACHE N\'EXISTE PAS<br /><br />';
            $result = $this->_objectMetier->getAllForGroupIdAndMotId($id_groupe, $les_mots);
            if (!PEAR::isError($result)) {
                $this->saveGeneralCache($signature, $result);
            }
            return $result;
        }
        //return $this->_objectMetier->getAllForGroupIdAndMotId($id_groupe, $les_mots);
        
    }

    // }}}

    // {{{ getAllMotsForGroupeId($selectGroupe)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $seidObjet
     * @access public
     */

    function &getAllMotsForGroupeId($selectGroupe, $critere = false) {
        
         return $this->_objectMetier->getAllMotsForGroupeId($selectGroupe, $critere);
       
    }

    // }}}

    // {{{ getAllMotsForMotId($les_mots,"titre")

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $les_mots
     * @param $critere
     * @access public
     */

    function &getAllMotsForMotId($les_mots,$critere) {
        
        return $this->_objectMetier->getAllMotsForMotId($les_mots,$critere);
        
    }

    // }}}

    // {{{ exist($table, $id_table, $nouv_mot, $id_objet)

    /**
     * Returns an boolean.
     *
     *
     * @return boolean
     * @param $table
     * @param $id_table
     * @param $nouv_mot
     * @param $id_objet
     * @access public
     */

    function exist($table, $id_table, $nouv_mot, $id_objet) {
        
         return $this->_objectMetier->exist($table, $id_table, $nouv_mot, $id_objet);
        
    }

    // }}}

    // {{{ getAllMotIdsForArticleStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForArticleStatut($aff_articles, $statut) {
        
        return $this->_objectMetier->getAllMotIdsForArticleStatut($aff_articles, $statut);

    }

    // }}}

    // {{{ getAllMotIdsForBreveStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForBreveStatut($aff_articles, $statut) {
        
        return $this->_objectMetier->getAllMotIdsForBreveStatut($aff_articles, $statut);
        
    }

    // }}}

    // {{{ getAllMotIdsForSyndicStatut($aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForSyndicStatut($aff_articles, $statut) {
        
        return $this->_objectMetier->getAllMotIdsForSyndicStatut($aff_articles, $statut);
        
    }

    // }}}

    // {{{ getAllMotIdsForArticles($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForArticles($aff_articles) {
        
        return $this->_objectMetier->getAllMotIdsForArticles($aff_articles);
        
    }

    // }}}

    // {{{ getAllMotIdsForBreves($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForBreves($aff_articles) {
        
        return $this->_objectMetier->getAllMotIdsForBreves($aff_articles);
        
    }

    // }}}

    // {{{ getAllMotIdsForSyndics($aff_articles)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function &getAllMotIdsForSyndics($aff_articles) {
        
        return $this->_objectMetier->getAllMotIdsForSyndics($aff_articles);
        
    }

    // }}}

    // {{{ howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut)

    /**
     * Returns an array of Mots.
     *
     *
     * @return Array of Mot
     * @param $id_message
     * @access public
     */

    function howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut) {
        //$signature = $this->generateID('howManyMotIdsForMotIdandArticleStatut'.$id_mot.$aff_articles.$statut);
        return $this->_objectMetier->howManyMotIdsForMotIdandArticleStatut($id_mot, $aff_articles, $statut);
    }

    // }}}

    // {{{ isLeaf()

    /**
     * This method returns true if the current keywork is a leaf in the keywords tree
     * false otherwise
     *
     * @return  boolean
     * @access  public
     */

    function isLeaf() {
        
        return $this->_objectMetier->isLeaf();
        
    }

    // }}}

    // {{{ getDescendents()

    /**
     *
     *
     *
     **/

    function getBranch($ids) {
        
        return $this->_objectMetier->getBranch($ids);
        
    }

    // }}}

    function getSubBranchIds($id) {
        return $this->_objectMetier->getSubBranchIds($id);
        
    }


    function getParentId($id) {
        
        return $this->_objectMetier->getParentId($id);
        
    }

    function getEnfantIds($id) {
        
        return $this->_objectMetier->getEnfantIds($id);
        
    }

    // {{{ getGranularityImpactedMot()

    /**
     *
     *
     *
     */

    function getGranularityImpactedMot($motToCheck, $motsSelected) {
        
        return $this->_objectMetier->getGranularityImpactedMot($motToCheck, $motsSelected);
        
    }

    //

    // {{{ getCheminMot()

    /**
     * This method returns the path from the root node to the current node
     * as an array of Mot.
     * @return  String   path to this Mot
     * @access  public
     */

    function getCheminMot() {
        
        return $this->_objectMetier->getCheminMot();
        
    }

    // }}}

    function getHierarchie($id_mot) {
        
        return $this->_objectMetier->getHierarchie($id_mot);
        
    }

}
?>
