<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Classe de base dfinissant le cache HTML de SPIP-Agora.
//

/**
 * CacheHTML est la classe centrale de gestion du cache HTML de SPIP-Agora.
 * @package	cacheHTML
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class CacheHTML {

    // {{{ properties
    
    /**
     * Le container du cache HTML.
     *
     * var		Container
     * @access	private
     */
    var $_container;

    /**
     * L'identifiant du groupe d'appartenance du cache.
     *
     * var		String
     * @access	private
     */
    var $_groupId;
	
	/**
     * L'identifiant du cache.
     *
     * var		String
     * @access	private
     */
    var $_cacheName;

	/**
     * Cette variable correspond  la requte de cache.
     *
     * var		String
     * @access	private
     */
    var $_query;

	/**
     * Cette variable stocke les paramtres en mthode GET  utiliser pour gnrer l'identifiant du cache.
     *
     * var		Array
     * @access	private
     */    
    var $_httpGetParams;

	/**
     * Cette variable stocke les paramtres en mthode POST  utiliser pour gnrer l'identifiant du cache. 
     *
     * var		String
     * @access	private
     */    
    var $_httpPostParams;

	/**
     * Cette variable stocke les paramtres  utiliser pour gnrer l'identifiant du cache HTML.
     *
     * var		String
     * @access	private
     */    
    var $_httpParamsString;

	/**
     * Le dlai de validit du cache HTML.
     *
     * var		int
     * @access	private
     */    
    var $_delais;

	/**
     * Variable pour forcer l'utilisation du cache HTML disponible.
     *
     * var		boolean
     * @access	private
     */    
    var $_useCacheAbsolutely;

	/**
     * Variable pour forcer le recalcul du cache HTML.
     *
     * var		boolean
     * @access	private
     */    
    var $_generateCacheAbsolutely;
    
    // }}}
    
    // {{{ setContainer($container)

    /**
     * Setter pour affecter le container du cache HTML.
     *
     * @param      Container	$container Le container  utiliser.
     * @access      public
     */
    
    function setContainer($container) {
    	$this->_container = $container;
    }

	// }}}

	// {{{ getContainer()

    /**
     * Getter pour rcuprer le container du cache HTML.
     *
     * @return      Container		L'object container support du cache HTML.
     * @access      public
     */

    function getContainer() {
    	return $this->_container;
    }
    
    // }}}
    
    // {{{ setGroupId($groupId)

    /**
     * Setter pour affecter l'dentifiant du groupe d'appartenance du cache.
     *
     * @param      String		$groupId L'identifiant du groupe d'appartenance du cache HTML.
     * @access      public
     */
    
    function setGroupId($groupId) {
    	$this->_groupId = $groupId;
    }
	
	// }}}
	
	// {{{ getGroupId()

    /**
     * Getter pour rcuprer l'identifiant du groupe d'appartenance du cache.
     *
     * @return      String		L'identifiant du groupe d'appartenance du cache HTML.
     * @access      public
     */
	
    function getGroupId() {
    	return $this->_groupId;
    }    
    
    // }}}
    
    // {{{ setCacheName($cacheName)

    /**
     * Setter pour affecter l'identifiant du cache HTML.
     *
     * @param      String		$cacheName L'identifiant du cache HTML.
     * @access      public
     */
    
    function setCacheName($cacheName) {
    	$this->_cacheName = $cacheName;
    }
    
    // }}}

	// {{{ getCacheName()

    /**
     * Getter pour rcuprer l'identifiant du cache HTML.
     *
     * @return      String		L'identifiant du cache HTML.
     * @access      public
     */

    function getCacheName() {
    	return $this->_cacheName;
    }

    // }}}
    
    // {{{ setQuery($query)

    /**
     * Setter pour affecter la requte du cache HTML.
     *
     * @param      String		$query La requte du cache HTML demande.
     * @access      public
     */
    
    function setQuery($query) {
    	$this->_query = $query;
    }

    // }}}

	// {{{ getQuery()

    /**
     * Getter pour rcuprer la requte du cache HTML.
     *
     * @return      String		La requte du cache HTML demande.
     * @access      public
     */

    function getQuery() {
    	return $this->_query;
    }    

    // }}}
    
    // {{{ setDelais($delais)

    /**
     * Setter pour affecter le dlai de validit du cache HTML.
     *
     * @param      String		$delais Le dlai de validit du cache HTML.
     * @access      public
     */
    
    function setDelais($delais) {
    	$this->_delais = $delais;
    }

    // }}}

	// {{{ getDelais()

    /**
     * Getter pour rcuprer le dlai de validit du cache HTML.
     *
     * @return      int		Le dlai de validit du cache HTML.
     * @access      public
     */

    function getDelais() {
    	return $this->_delais;
    }
    
    // }}}
    
    // {{{ setUseCacheAbsolutely($useCacheAbsolutely)

    /**
     * Setter pour forcer l'utilisation du cache HTML.
     *
     * @param      boolean		$useCacheAbsolutely boolean forant l'utilisation du cache HTML.
     * @access      public
     */
    
    function setUseCacheAbsolutely($useCacheAbsolutely) {
    	$this->_useCacheAbsolutely = $useCacheAbsolutely;    	
    }

    // }}}

	// {{{ getUseCacheAsolutely()

    /**
     * Getter pour savoir si on doit forcer l'utilisation du cache HTML.
     *
     * @return      boolean		boolean forant l'utilisation du cache HTML.
     * @access      public
     */

    function getUseCacheAbsolutely() {
    	return $this->_useCacheAbsolutely;
    }    

    // }}}

	// {{{ setGenerateCacheAbsolutely($generateCacheAbsolutely)

    /**
     * Setter activer le forage du calcul du cache HTML.
     *
     * @param      boolean		$generateCacheAbsolutely boolean forant le recalcul du cache HTML.
     * @access      public
     */  

    function setGenerateCacheAbsolutely($generateCacheAbsolutely) {
    	$this->_generateCacheAbsolutely = $generateCacheAbsolutely;    	
    }

    // }}}
    
    // {{{ getGenerateCacheAbolutely()

    /**
     * Getter pour savoir si on doit forcer le calcul du cache HTML.
     *
     * @return      boolean		boolean forant le recalcul du cache HTML.
     * @access      public
     */    

    function getGenerateCacheAbsolutely() {
    	return $this->_generateCacheAbsolutely;
    }    
    
    // }}}
    
    // {{{ factory($typeCacheHTML)
    
    /**
     * Indexer Factory.
     * @return $CacheHTML
     * @access public
     */
    function &factory($nameCacheHTML, $container, $query, $httpGetParams, $httpPostParams, $delais = 0, $cacheParams = null) {

        if(!file_exists(dirname(__FILE__).'/'.$GLOBALS['type_cacheHTML'].'/'.$nameCacheHTML.'_'.$GLOBALS['type_cacheHTML'].'_common.php')) {
            include_once(dirname(__FILE__).'/common/'.$nameCacheHTML.'CacheHTML_common.php');
            $classname = $nameCacheHTML.'CacheHTML_common';
        }
        else {
            include_once(dirname(__FILE__).'/'.$GLOBALS['type_cacheHTML'].'/'.$nameCacheHTML.'CacheHTML_common.php');
            $classname = $nameCacheHTML.'CacheHTML_'.$GLOBALS['type_cacheHTML'];
        }
		$obj = & new $classname($container, $query, $httpGetParams, $httpPostParams, $delais, $cacheParams);
        
        return $obj;

    }

    // }}}    
    
    // {{{ constructor

    /**
     * cacheHTML constructor.
     *
	 * @param    Container	$container reprsente l'object container support du cache HTML.
	 * @param    string		$query reprsente la requte du cache HTML.
	 * @param    array		$httpGetParams fournit les paramtres GET de la requte.
	 * @param    array		$httpPostParams fournit les paramtres POST de la requte.
	 * @param    int		$delais reprsente la dure de validit du cache HTML.
	 * @param    array		$cacheParams stocke les paramtres potentiellement utiles.
	 * @access public
     */

	function CacheHTML($container, $query, $httpGetParams = array(), $httpPostParams = array(), $delais = null, $cacheParams = null) {
		
		$this->_useCacheAbsolutely = false;
		$this->_generateCacheAbsolutely = false;
		
		$this->_container = $container;
        $this->_httpGetParams = $httpGetParams;
        $this->_httpPostParams = $httpPostParams;
        $this->_ignoreQueryParams();
        $this->_query = $query;
        $this->_delais = $delais;
        // Si pas de dlai de dfini, on fixe un dlai de 1H
        if($this->_delais == null && $this->_delais!=0)
			$this->_delais = 1 * 3600;
		else {
        	if ($this->_delais < 0) $this->_useCacheAbsolutely = true; 
        	$this->_delais = $delais;
		}

		$this->_generateCacheName();

	}

    // }}}	

	// {{{ _ignoreQueryParams()

    /**
     * Cette mthode permet de slectionner les paramtres  utiliser pour fabriquer l'identifiant du cache HTML.
     *
	 * @access private
     */
	
	function _ignoreQueryParams() {

		while ( list($key, $value) = each($this->_httpGetParams) ) {
			//if ( eregi('(submit|valider|PHPSESSID|(var_[^=&]*)|recalcul)=[^&]*', $key.'='.$value) ) {
			if ( eregi('(submit|valider|PHPSESSID|(var_[^=&]*)|recalcul|preview)=.', $key.'='.$value) ) {
				unset($this->_httpGetParams[$key]);
			}
			else {
				$this->_httpParamsString .= '&' . $key.'='.$value;
			}
		}

	}
	
	// }}}

	// {{{ _generateCacheName()

    /**
     * Cette mthode gnre l'identifiant du cache HTML.
     *
	 * @access private
     */

	function _generateCacheName() {
	
		if ($this->_query != '') {
			$md_cache = md5($this->_query . $this->_httpParamsString );
		
			$cacheName = ereg_replace('^/+', '', $this->_query . $this->_httpParamsString);
			$cacheName = ereg_replace('\.[a-zA-Z0-9]*', '', $cacheName);
			$cacheName = ereg_replace('&[^&]+=([^&]+)', '&\1', $cacheName);
			$cacheName = rawurlencode(strtr($cacheName, '/&-', '--_'));
	
			if (strlen($cacheName) > 24)
				$cacheName = substr(ereg_replace('([a-zA-Z]{1,3})[^-]*-', '\1-', $cacheName), -24);
		
			
			
			if (!empty($this->_httpPostParams) ) $cacheName .= '.'.@getmypid();
			
            if ($GLOBALS['preview'] == 'oui') $cacheName .= '.pre';
            
			$cacheName .= '.' . $md_cache;
			$subdir_cache = substr($md_cache, 0, 1);
			$this->_cacheName = $subdir_cache . '/' . $cacheName;
		}
		
		
	}

	// }}}
	
	// {{{ save($data)
    
    /**
     * Cette mthode sauvegarde  partir du container les donnes  mettre en cache.
     *
     * @param string	$data stocke les donnes  sauvegarder dans le cache.
	 * @access public
     */
	
	function save($data) {
		
		$this->_container->save($data, $this->_groupId, $this->_cacheName);
	    
	}

	// }}}
	
	// {{{ load()

    /**
     * Cette mthode permet de charger  partir du container support le cache HTML.
     *
     * @return string	Les donnes du cache.
	 * @access public
     */
	
	function load() {
		
		return $this->_container->load($this->_groupId, $this->_cacheName);
	    
	}

	// }}}	

	// {{{ includeCache()
	
	/**
	 * Cette mthode permet d'inclure au sens de la fonction include de PHP le contenu du cache.
	 *
	 * @access public
	 */
	
	function includeCache() {
		
		$this->_container->includeCache($this->_groupId, $this->_cacheName);
	    
	}

	// }}}
	
	// {{{ useCache()
	
	 /**
     * Cette mthode dtermine s'il faut utiliser le cache.
     * @return boolean faut-il utiliser le cache?
     * @access public
     */	
	
	function useCache() {
		
        if ($this->getDelais() < 0) { // le cache est ngatif il n'expire jamais
            $this->setUseCacheAbsolutely(true);
        }
        
		if (!$this->_useCacheAbsolutely or !$this->_generateCacheAbsolutely) {
			
			$use_cache = $this->_container->useCache( $this->_groupId, $this->_cacheName, $this->_delais, $this->getUseCacheAbsolutely() );
			
			// recalcul obligatoire
			// TODO Vrifier si ce test esr $recalcul est utile puisqu'on doit passer par l'attribut generateCacheAbsolutely
			$use_cache &= ($GLOBALS['recalcul'] != 'oui');
			$use_cache &= empty($HTTP_POST_VARS);
		
			// ne jamais recalculer pour les moteurs de recherche, proxies...
			if ($HTTP_SERVER_VARS['REQUEST_METHOD'] == 'HEAD')
				$use_cache = true;
			//spip_debug (($use_cache ? "cache":"calcul")." ($chemin_cache)". ($age ? " age: $age s (reste ".($delais-$age)." s)":''));
		}
		else {
			if ($this->_useCacheAbsolutely)	$use_cache = true;
			elseif($this->_generateCacheAbsolutely)	$use_cache = false;
			else	$use_cache = false;
		}
		
		return $use_cache;
		
	}	

	// }}}
	
	// {{{ destroyCache()

	/**
	* Cette mthode dtruit le cache HTML.
	* 
	* @access public
	*/
	
	function destroyCache() {
		
		if($this->_cacheName != null) {
			$this->_container->destroyCache();
		}
		else {
			$this->_container->destroyAllCache($this->_groupId);
		}
			
	}
	
	// }}}

	// {{{ destroyAllCache()

	/**
	* Cette mthode dtruit le cache HTML du groupe.
	* 
	* @access public
	*/
	
	function destroyAllCache() {
		
		$this->_container->destroyAllCache($this->_groupId);
			
	}
	
	// }}}

	// {{{ cacheExist()

	/**
	* Cette mthode permet de savoir si le cache est prsent.
	* 
	* @return boolean Le cache existe t'il?
	* @access public
	*/
	
	function cacheExist() {
	
		return $this->_container->cacheExist();
			
	}
	
	// }}}

}
?>