<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Implmentation du cache HTML pour les pages supportant la personnalisation.
//
require_once dirname(__FILE__)."/../CacheHTML.php";

/**
 * Implmentation du cache HTML pour les pages supportant la personnalisation.
 * @package	cache_html/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class PersonnalisationCacheHTML_common extends CacheHTML {

    // {{{ properties
    
    /**
     * L'identifiant du visiteur (utile  la dfinition du groupe d'appartenance du cache).
     *
     * var		int
     * @access	private
     */
    
    var $_personnalisationId;
    
    // }}}

    // {{{ setPersonnalisationId($personnalisationId)

    /**
     * Setter pour affecter l'identifiant du visiteur (utile  la dfinition du groupe d'appartenance du cache).
     *
     * @param      String		$personnalisationId l'identifiant du visiteur.
     * @access      public
     */
    
    function setPersonnalisationId($personnalisationId) {
    	$this->_personnalisationId = $personnalisationId;
    }

	// }}}

    // {{{ getPersonnalisationId()

    /**
     * Setter pour affecter l'identifiant du visiteur (utile  la dfinition du groupe d'appartenance du cache).
     *
     * @return      String		l'identifiant du visiteur.
     * @access      public
     */
    
    function getPersonnalisationId() {
    	return $this->_personnalisationId;
    }

	// }}}
    
    // {{{ constructor

    /**
     * PersonnalisationCacheHTML_common constructor.
     *
	 * @param    Container	$container reprsente l'object container support du cache HTML.
	 * @param    string		$query reprsente la requte du cache HTML.
	 * @param    array		$httpGetParams fournit les paramtres GET de la requte.
	 * @param    array		$httpPostParams fournit les paramtres POST de la requte.
	 * @param    int		$delais reprsente la dure de validit du cache HTML.
	 * @param    int		$delais reprsente la dure de validit du cache HTML.
	 * @param    array		$cacheParams stocke l'identifiant du visiteur $cacheParams['personnalisationId'].
	 * @access public
     */
    function PersonnalisationCacheHTML_common($container, $query, $httpGetParams, $httpPostParams, $delais = 0, $cacheParams = null) {
    	$this->_personnalisationId = $cacheParams['personnalisationId'];
		$this->_groupId = 'CACHE/perso/' . $cacheParams['personnalisationId'] . '/' . $query;
		$par = get_parent_class($this);
		$res = $this->$par($container, $query, $httpGetParams, $httpPostParams, $delais, $cacheParams);

    }

    // }}}	
	
}
?>