<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Implmentation du cache HTML pour les pages standard.
//
require_once dirname(__FILE__)."/../CacheHTML.php";

/**
 * Implmentation du cache HTML pour les pages standards.
 * @package	cache_html/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class StandardCacheHTML_common extends CacheHTML  {

    // {{{ properties
        
    // }}}
    
    // {{{ constructor

    /**
     * PersonnalisationCacheHTML_common constructor.
     *
	 * @param    Container	$container reprsente l'object container support du cache HTML.
	 * @param    string		$query reprsente la requte du cache HTML.
	 * @param    array		$httpGetParams fournit les paramtres GET de la requte.
	 * @param    array		$httpPostParams fournit les paramtres POST de la requte.
	 * @param    int		$delais reprsente la dure de validit du cache HTML.
	 * @param    int		$delais reprsente la dure de validit du cache HTML.
	 * @param    array		$cacheParams stocke les paramtres potentiellement utiles.
	 * @access public
     */

    function StandardCacheHTML_common($container, $query, $httpGetParams, $httpPostParams, $delais = 0, $cacheParams = null) {
    	$this->_groupId = 'CACHE/common/' . $query;
    	$par = get_parent_class($this);
        $res = $this->$par($container, $query, $httpGetParams, $httpPostParams, $delais, $cacheParams);
    }

    // }}}	
	
}
?>