<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Agora CACHE HTML front.
// @version $Id$
//
require_once dirname(__FILE__)."/Container.php";

/**
 * AgoraCache is a class for front cache HTML.
 * @package	cache_html
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class FileContainer extends Container {

    // {{{ properties

	var $_cacheHTMLDirectory;
	
	var $_cacheHTMLFile;
	
    // }}}
    
    
    // {{{ getcacheHTMLFile()
    function getcacheHTMLFile() {
        return $this->_cacheHTMLFile;
    }
    
    // }}}
    
    
    // {{{ constructor

    /**
     * Container constructor.
     *
	 * @access public
     */

    function FileContainer($containerParams = array()) {
    	$this->_cacheHTMLDirectory = $containerParams['cacheHTML_directory'];
    }

    // }}}	

	// {{{

    // TODO : pouvoir sauver en gzip ? 
	function save($data, $groupId, $cacheName) {
		
		$subdir = explode('/', $cacheName);
		// Cration de l'arborescence de rpertoire du CACHE
		$this->mkdirr($this->_cacheHTMLDirectory . '/' . $groupId. '/' . $subdir[0], 0777);
		
		$cachePath = $this->_cacheHTMLDirectory . '/' . $groupId . '/' . $cacheName;
		$cachePathOld = $cachePath . '.OLD';
		$cachePathTmp = $cachePath . '_tmp';
		
		if (file_exists($cachePath)) {
			rename($cachePath, $cachePathOld);
		}
		
		$f = fopen($cachePathTmp, 'wb');
		while (!flock($f, LOCK_EX)); // boucle d'attente Yo 
			
		$r = fwrite($f, $data);
		flock($f, LOCK_UN); // libre le verrou
		fclose($f);
		rename($cachePathTmp, $cachePath);
		
		if (file_exists($cachePathOld)) {
			unlink($cachePathOld);
		}
		$this->_cacheHTMLFile = $cachePath;

	}

	// }}}
	
	// {{{
	
	function mkdirr($pathname, $mode = null) {
	    
	    // Check if directory already exists
	    if (is_dir($pathname) || empty($pathname)) {
	        return true;
	    }
	
	    // Ensure a file does not already exist with the same name
	    if (is_file($pathname)) {
	        trigger_error('mkdirr() File exists', E_USER_WARNING);
	        return false;
	    }
	
	    
	    // Crawl up the directory tree
	    $next_pathname = substr($pathname, 0, strrpos($pathname, '/'));
	    
	    if ($this->mkdirr($next_pathname, $mode)) {
	        if (!file_exists($pathname)) {
	            return mkdir($pathname, $mode);
	        }
	    }
	
	    return false;
	}	
	
	// }}}
	
	// {{{
	
	function rmdirr($dirname) {
	    // Simple delete for a file
	    if (is_file($dirname)) {
	    	return unlink($dirname);
	    }
	
	    // Loop through the folder
        if (is_dir($dirname)) {
	       $dir = dir($dirname);
	       while (false !== $entry = $dir->read()) {
	        // Skip pointers
	         if ($entry == '.' || $entry == '..') {
	               continue;
	           }
	
	        // Deep delete directories      
    	        if (is_dir("$dirname/$entry")) {
	               $this->rmdirr("$dirname/$entry");
	            } else {
	                $path_parts = pathinfo("$dirname/$entry");
			      if ($path_parts['extension'] != 'php3' and $path_parts['extension'] != 'php') {
	            	unlink("$dirname/$entry");
	                }
	            }
	        }
	
	    // Clean up
	       $dir->close();
	       $path_parts = pathinfo("$dirname");
	       if ($path_parts['basename'] != 'CACHE') return rmdir($dirname);
	       else return true;
        } else {
            return false; 
        }
	}	
	
	// }}}
	
	// {{{
	// TODO : pouvoir loader en gzip ? 
	function load($groupId, $cacheName) {
		
		$cachePath = $this->_cacheHTMLDirectory . '/' . $groupId . '/' . $cacheName;
		$cachePathOld = $cachePath . '.OLD';
		
		if (!file_exists($cachePath)) {
			if (file_exists($cachePathOld)) {
				return file_get_contents($cachePathOld);
			}
		}
		else {
			return file_get_contents($cachePath);
		}
				 
	}

	// }}}	

	// {{{

	function includeCache($groupId, $cacheName) {
		
		include($this->_cacheHTMLFile);
		
	}

	// }}}	
	
	// {{{
	
	function useCache( $groupId, $cacheName, $delais, $useCacheAbsolutely = false ) {
		global $lastmodified;
		
		$use_cache = true;
		
		$cachePath = $this->_cacheHTMLDirectory . '/' . $groupId . '/' . $cacheName;
		$cachePathOld = $cachePath . '.OLD';
		
		if (!file_exists($cachePath)) {
			if(file_exists($cachePathOld)) {
				$this->_cacheHTMLFile = $cachePathOld;
			}
			else {
				$cachePathTmp = $cachePath . '_tmp';
				if (file_exists($cachePathTmp)) {
					$f = fopen($cachePathTmp, 'wb');
					while (!flock($f, LOCK_EX)); // boucle d'attente Yo
					flock($f, LOCK_UN); // libere le verrou
					fclose($f);
					$use_cache = true;
					$this->_cacheHTMLFile = $cachePath;
				}
				else {
					$use_cache = false;
				}
				
				
			}
		}
		else {
            if ($useCacheAbsolutely) { // le fichier existe et je dois absolument l'utiliser 
                $this->_cacheHTMLFile = $cachePath;
                return true;
            }
			// Date de creation du fichier
			$t = filemtime($cachePath);
			$age = time() - $t;
			$age_ok = (($age < $delais) AND ($age >= 0));
			if (!$age_ok) {		// fichier cache trop vieux
				$use_cache = false;
			}
			else {
				$this->_cacheHTMLFile = $cachePath;
			}
			
			// Inclusions multiples : derniere modification
			//if ($lastmodified < $t) $lastmodified = $t;
		}
		
		return $use_cache;
		
	}

	// }}}
	
	// {{{

	function destroyCache() {
		
		unlink($this->_cacheHTMLFile);
		
	}

	// }}}

	// {{{

	function destroyAllCache($groupId) {
		
		$this->rmdirr($this->_cacheHTMLDirectory .$groupId);
		
	}

	// }}}
	
	// {{{
	
	function cacheExist() {
		return file_exists($this->_cacheHTMLFile);
	}
	
	// }}}		
	
}
?>