<?php
function subscribersTable($listId = 0)
{
    global $db;
    
    // Page id
    if (isset($_GET['page'])) {
        $page = $_GET['page'];
    } elseif (isset($_POST['page'])) {
        $page = $_POST['page'];
    } else {
        $page = 1;
    }
    
    if (isset($_GET['remove'])) {
		if ($listId == 0) {
			$db->query("DELETE FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE sub_id = ".$_GET['remove']);
        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_subscribers WHERE sub_id = ".$_GET['remove']);
        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_pending WHERE sub_id = ".$_GET['remove']);
        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_queued WHERE sub_id = ".$_GET['remove']);
        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_done WHERE sub_id = ".$_GET['remove']);
		} else {
        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE lst_id = ".$listId." AND sub_id = ".$_GET['remove']);
		}
    }

    if (isset($_POST['remove']) && strlen($_POST['sub_ids']) > 0) {
        foreach(explode(';', $_POST['sub_ids']) as $subId) {
			if ($subId != '') {
	            if ($listId == 0) {
					$db->query("DELETE FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE sub_id = ".$subId);
		        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_subscribers WHERE sub_id = ".$subId);
		        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_pending WHERE sub_id = ".$subId);
		        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_queued WHERE sub_id = ".$subId);
		        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_done WHERE sub_id = ".$subId);
	            } else {
	                $db->query("DELETE FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE lst_id = ".$listId." AND sub_id = ".$subId);
				}
			}
        }
    }

    // Number of elements shown in lists
    if (isset($_GET['show'])) {
        $show = $_GET['show'];
    } elseif (isset($_SESSION['show'])) {
        $show = $_SESSION['show'];
    } else {
        $show = CM_LISTS_SIZE;
    }
    $_SESSION['show'] = $show;

    // Filter
	if (isset($_SESSION['filter'])) {
	    $filter = $_SESSION['filter'];
	} else {
		$filter = array('email' => '', 'name' => '', 'mode' => -1);
	}
    if (isset($_POST['filter_email'])) {
        $filter['email'] = $_POST['filter_email'];
        $filter['name'] = $_POST['filter_name'];
        $filter['mode'] = $_POST['filter_mode'];
    }
    $_SESSION['filter'] = $filter;
    $where = "WHERE 1 = 1";
    if ($filter['email'] != '') {
        $where .= " AND sub_email LIKE '%".$filter['email']."%'";
    }
    if ($filter['name'] != '') {
        $where .= " AND (sub_first_name LIKE '%".$filter['name']."%' OR sub_last_name LIKE '%".$filter['name']."%')";
    }
    if ($listId != 0 && $filter['mode'] != -1 && $filter['mode'] != '') {
        $where .= " AND lsr_mode = ".$filter['mode'];
    }

    if ($listId == 0) {
        $nb = $db->getOne("SELECT COUNT(*)
            FROM ".CM_TABLE_PREFIX."_subscribers
            ".$where);
    } else {
        $nb = $db->getOne("SELECT COUNT(*)
            FROM ".CM_TABLE_PREFIX."_subscribers s, ".CM_TABLE_PREFIX."_lists_subscribers l
            ".$where."
            AND s.sub_id = l.sub_id
            AND l.lst_id = ".$listId);
    }

    $pageMax = ($nb == 0 ? 1 : floor(($nb - 1) / $show) + 1);
    $page = max(1, min($page, $pageMax));
    
    if ($listId == 0) {
        $subscribers = $db->query("SELECT *
			FROM ".CM_TABLE_PREFIX."_subscribers
            ".$where."
            ORDER BY sub_email, sub_last_name, sub_first_name
            LIMIT ".(($page - 1) * $show).", ".$show);
    } else {
		$query = "SELECT
            s.sub_id,
            s.sub_email,
            s.sub_first_name,
            s.sub_middle_name,
            s.sub_last_name,
            s.sub_title,
            l.lsr_mode
            FROM ".CM_TABLE_PREFIX."_subscribers s, ".CM_TABLE_PREFIX."_lists_subscribers l
            ".$where."
            AND s.sub_id = l.sub_id
            AND l.lst_id = ".$listId."
            ORDER BY s.sub_email, s.sub_last_name, s.sub_first_name
            LIMIT ".(($page - 1) * $show).", ".$show;
        $subscribers = $db->query($query);
    }
	?>
	<table class="list">
	<?php
	echo '<tr><td colspan="3">Page:';
	    for ($i = 1; $i <= $pageMax; $i++)
	    {
	        if ($i == $page) {
	if ($i > 1) echo '-';
	            echo '<b>'.$i.'</b>';
	        } elseif ($i == 1 || $i == $pageMax || abs($i - $page) <= 3) {
	if ($i > 1) echo '-';
	            echo '<a href="?'.($listId != 0 ? 'id='.$listId.'&' : '').'page='.$i.'">'.$i.'</a>';
	        } elseif (abs($i - $page) == 4) {
	            echo '-...';
	        }
	    }
	echo '</td><td colspan="2">';
	foreach(array(10, 20, 50) as $i) {
	    if ($i > 10) echo '-';
	    if ($i == $show) {
	        echo '<b>'.$i.'</b>';
	    } else {
	        echo '<a href="?'.($listId != 0 ? 'id='.$listId.'&' : '').'page='.$page.'&show='.$i.'">'.$i.'</a>';
	    }
	}
	echo ' items/page</td></tr>';
	?>
	<tr class="title">
	    <td>&nbsp;</td>
	    <td>E-mail</td>
	    <td>Full name</td>
	    <td><?=($listId == 0 ? 'Lists' : 'Mode')?></td>
	    <td>Actions</td>
	</tr>
	<form name="filter" action="<?=$_SERVER['PHP_SELF']?>" method="post">
	<input type="hidden" name="id" value="<?=$listId?>" />
	<input type="hidden" name="page" value="<?=$page?>" />
	<tr class="even">
	    <td>&nbsp;</td>
	    <td><input type="text" name="filter_email" value="<?=$filter['email']?>" size="15" maxlength="255" /></td>
	    <td><input type="text" name="filter_name" value="<?=$filter['name']?>" size="15" maxlength="255" /></td>
	    <td>
	        <?php
	        if ($listId != 0) {
	            ?>
	            <select name="filter_mode">
	                <option value="-1"></option>
	                <option value="0"<?=($filter['mode'] == 0 ? ' selected="selected"' : '')?>>Text</option>
	                <option value="1"<?=($filter['mode'] == 1 ? ' selected="selected"' : '')?>>HTML</option>
	            </select>
	            <?php
	        } else {
				?>
				<input type="hidden" name="filter_mode" value="<?=$filter['mode']?>" />
				<?php
			}
	        ?>
	    </td>
	    <td><input type="submit" name="filter_button" value="Filter" /></td>
	</tr>
	</form>
	<form name="subscribers" action="<?=$_SERVER['PHP_SELF']?>" method="post">
	<input type="hidden" name="id" value="<?=$listId?>" />
	<input type="hidden" name="sub_ids" value="" />
	<?php
    if ($subscribers->numRows() > 0) {
        $row = 0;
        while ($subscriber = $subscribers->fetchRow()) {
			if ($listId == 0) {
				$nbLists = $db->getOne("SELECT COUNT(*) FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE sub_id = ".$subscriber['sub_id']);
			}
            ?>
            <tr class="<?=($row++%2 ? 'even' : 'odd')?>">
                <td>
					<input type="checkbox" name="sub_id" value="<?=$subscriber['sub_id']?>" />
				</td>
                <td><?=$subscriber['sub_email']?></td>
                <td>
                    <?=$subscriber['sub_first_name']?>
                    <?=$subscriber['sub_last_name']?>
                </td>
                <td>
					<?php
					if ($listId == 0) {
						echo $nbLists;
					} else {
						echo ($subscriber['lsr_mode'] ? 'HTML' : 'Text');
					}
					?>
				</td>
                <td>
					<?php
					if ($listId != 0) {
						?>
						<a href="?id=<?=$listId?>&remove=<?=$subscriber['sub_id']?>&page=<?=$page?>">Unsubscribe</a>
						<?php
					} else {
						?>
						<a href="?remove=<?=$subscriber['sub_id']?>&page=<?=$page?>">Remove</a>
						<?php
					}
					?>
                </td>
            </tr>
            <?php
        }
	} else {
		?>
		<tr class="odd"><td colspan="5">No subscribers</td></tr>
		<?php
	}
    ?>
    </table>
    <p>
    <a href="#" onClick="toggle(document.subscribers, 'sub_id'); return false;">Toggle all</a>
    |
    Checked subscribers :
    <input type="submit" name="remove" value="<?=($listId == 0 ? 'Remove' : 'Unsubscribe')?>" onClick="checkbox2input(document.subscribers, 'sub_id', document.subscribers.sub_ids);" />
    </form>
    </p>
    <?php
}
?>
