#
# Table structure for table `cm_lists`
#

DROP TABLE IF EXISTS cm_lists;
CREATE TABLE cm_lists (
  lst_id int(11) NOT NULL default '0',
  lst_name varchar(255) NOT NULL default '',
  lst_comment text NOT NULL,
  lst_moderation varchar(10) NOT NULL default '',
  lst_moderator_email varchar(255) NOT NULL default '',
  lst_subscribe_subject varchar(255) NOT NULL default '',
  lst_subscribe_text text NOT NULL,
  lst_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_subject varchar(255) NOT NULL default '',
  lst_unsubscribe_text text NOT NULL,
  lst_subject_tag tinyint(1) NOT NULL default '1',
  lst_html_header text NOT NULL,
  lst_html_footer text NOT NULL,
  lst_text_header text NOT NULL,
  lst_text_footer text NOT NULL,
  PRIMARY KEY  (lst_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_lists_subscribers`
#

DROP TABLE IF EXISTS cm_lists_subscribers;
CREATE TABLE cm_lists_subscribers (
  lst_id int(11) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  lsr_mode tinyint(1) NOT NULL default '0',
  lsr_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id),
  KEY lst_id (lst_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_pending`
#

DROP TABLE IF EXISTS cm_pending;
CREATE TABLE cm_pending (
  lst_id int(11) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  pnd_action varchar(15) NOT NULL default '',
  pnd_mode tinyint(1) NOT NULL default '0',
  pnd_action_date int(11) NOT NULL default '0',
  pnd_action_id varchar(32) NOT NULL default '',
  PRIMARY KEY  (lst_id,sub_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_posts`
#

DROP TABLE IF EXISTS cm_posts;
CREATE TABLE cm_posts (
  pst_id bigint(20) NOT NULL default '0',
  lst_id int(11) NOT NULL default '0',
  pst_date_create int(11) NOT NULL default '0',
  pst_date_update int(11) NOT NULL default '0',
  pst_date_sent int(11) NOT NULL default '0',
  pst_subject varchar(255) NOT NULL default '',
  pst_html text NOT NULL,
  pst_text text NOT NULL,
  PRIMARY KEY  (pst_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_posts_done`
#

DROP TABLE IF EXISTS cm_posts_done;
CREATE TABLE cm_posts_done (
  pst_id bigint(20) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  PRIMARY KEY  (pst_id,sub_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_posts_links`
#

DROP TABLE IF EXISTS cm_posts_links;
CREATE TABLE cm_posts_links (
  lnk_id bigint(20) NOT NULL default '0',
  pst_id bigint(20) NOT NULL default '0',
  lnk_name varchar(255) NOT NULL default '',
  lnk_url text NOT NULL,
  PRIMARY KEY  (lnk_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_posts_queued`
#

DROP TABLE IF EXISTS cm_posts_queued;
CREATE TABLE cm_posts_queued (
  pst_id bigint(20) NOT NULL default '0',
  sub_id bigint(20) NOT NULL default '0',
  psq_date int(11) NOT NULL default '0',
  PRIMARY KEY  (pst_id,sub_id)
) TYPE=MyISAM;

#
# Table structure for table `cm_settings`
#

DROP TABLE IF EXISTS cm_settings;
CREATE TABLE cm_settings (
  set_name varchar(15) NOT NULL default '',
  set_value varchar(255) NOT NULL default '',
  PRIMARY KEY  (set_name)
) TYPE=MyISAM COMMENT='Application settings';

#
# Dumping data for table `cm_settings`
#

INSERT INTO cm_settings VALUES ('CM_MAIL_FROM', 'No Reply <noreply@example.com>');
INSERT INTO cm_settings VALUES ('CM_BASE_URL', 'http://www.example.com/cm/');
INSERT INTO cm_settings VALUES ('CM_LISTS_SIZE', '20');
INSERT INTO cm_settings VALUES ('CM_MAIL_ADMIN', 'postmaster@example.com');
INSERT INTO cm_settings VALUES ('CM_UPLOAD_DIR', '/tmp/');
INSERT INTO cm_settings VALUES ('CM_SEND_NUMBER', '100');

#
# Table structure for table `cm_subscribers`
#

DROP TABLE IF EXISTS cm_subscribers;
CREATE TABLE cm_subscribers (
  sub_id bigint(20) NOT NULL default '0',
  sub_email varchar(255) NOT NULL default '',
  sub_first_name varchar(50) NOT NULL default '',
  sub_middle_name varchar(50) NOT NULL default '',
  sub_last_name varchar(50) NOT NULL default '',
  sub_title varchar(10) NOT NULL default '',
  sub_profile varchar(32) NOT NULL default '',
  PRIMARY KEY  (sub_id),
  KEY sub_profile (sub_profile),
  KEY sub_email (sub_email)
) TYPE=MyISAM;

