<?php
require_once 'include/settings.php';
require_once 'design/top.php';

// Defines help presented in the right column
define('CM_COLUMN_RIGHT', "
<h2>Import</h2>
<p>You can import subscribers...</p>
");
?>
<div class="content">
<h1>Add new subscribers</h1>
<?php
$data = array();
if (isset($_FILES['cm_file']) && is_uploaded_file($_FILES['cm_file']['tmp_name'])) {
	$data = array_merge($data, file($_FILES['cm_file']['tmp_name']));
}

if (isset($_POST['cm_subs']) && strlen($_POST['cm_subs']) > 0) {
	$subString = ereg_replace("(\n|\r)+", "#", $_POST['cm_subs']);
	$subArray = explode('#', $subString);
	$data = array_merge($data, $subArray);
}

if (count($data) > 0) {
	if (isset($_POST['cm_lists']) && is_array($_POST['cm_lists'])) {
		$lists = $_POST['cm_lists'];
	}
	echo '<p>Importing new subscribers:</p><p>';
	$nbSub = 0;
	foreach($data as $subscriber) {
		if (ereg("^([^@ ]+@[^@ ]+\.[^@.; ]+)(;[^;]*)?(;[^;]*)?$", $subscriber, $regs)) {
			// CSV format: user@example.com;last name (optional);first name (optional)
			list($address, $firstName, $lastName) = explode(';', $subscriber);
			$address = trim($regs[1]);
			$lastName = (strlen($regs[2]) > 1 ? trim(substr($regs[2], 1)) : '');
			$firstName = (strlen($regs[3]) > 1 ? trim(substr($regs[3], 1)) : '');
			if (get_magic_quotes_gpc()) {
				$lastName = stripslashes($lastName);
				$firstName = stripslashes($firstName);
			}
		    if (!$recId = $db->getOne("SELECT sub_id FROM ".CM_TABLE_PREFIX."_subscribers WHERE sub_email='".$address."'")) {
		        // New e-mail address
	     	    $recId = $db->nextId(CM_TABLE_PREFIX.'_subscribers');
		        $db->query("INSERT INTO ".CM_TABLE_PREFIX."_subscribers (sub_id, sub_email, sub_first_name, sub_last_name, sub_profile) VALUES (".$recId.", '".$address."', '".addslashes($firstName)."', '".addslashes($lastName)."', '".md5($recId.'#'.$address.'#'.time())."')");
				$nbSub++;
	        }
			if (isset($lists)) {
				reset($lists);
				foreach($lists as $listId) {
			        if ($db->getOne("SELECT COUNT(*) FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE lst_id = ".$listId." AND sub_id = ".$recId) == 0) {
			            // New subscription
			            $actionId = md5('subscribe#'.$listId.'#'.$recId.'#'.time());
						$db->query("INSERT INTO ".CM_TABLE_PREFIX."_lists_subscribers (lst_id, sub_id, lsr_mode, lsr_id) VALUES (".$listId.", ".$recId.", ".$_POST['cm_mode'].", '".$actionId."')");
			        }
				}
			}
	    } elseif (trim($subscriber) != '') {
			echo '<span class="error">Error: '.$subscriber.'</span><br />';
		}
	}
	echo '<span class="noerror">'.($nbSub > 0 ? $nbSub : 'No').' new subscriber'.($nbSub > 1 ? 's' : '').' added</span></p>';
}
?>

<table width="100%" class="form">
<form enctype="multipart/form-data" action="subscribers_new.php" method="post">
<tr>
	<td class="label">Upload CSV file:</td>
	<td class="field">
		<input type="file" name="cm_file" /><br />
		<span class="tips">CSV format: user@example.com[;last name[;first name]]</span>
	</td>
</tr>
<tr>
	<td class="label">Type addresses:</td>
	<td class="field">
		<textarea name="cm_subs" cols="50" rows="10" wrap="virtual"></textarea><br />
		<span class="tips">Format: user@example.com[;last name[;first name]]</span>
	</td>
</tr>
<tr>
	<td class="label">Subscribe to lists:</td>
	<td class="field">
		<select name="cm_lists[]" multiple="multiple">
			<?php
			$lists = $db->query("SELECT lst_id, lst_name FROM ".CM_TABLE_PREFIX."_lists ORDER BY lst_name");
			while ($list = $lists->fetchRow()) {
				echo '<option value="'.$list['lst_id'].'">'.$list['lst_name'].'</option>';
			}
			?>
		</select>
	</td>
</tr>
    <tr>
        <td class="label">Mode:</td>
        <td class="field">
            <input type="radio" name="cm_mode" value="1" checked="checked" /> HTML<br />
            <input type="radio" name="cm_mode" value="0" /> Text<br />
        </td>
    </tr>
<tr>
	<td colspan="2">
		<input type="submit" value="Import" />
	</td>
</tr>
</form>
</table>
</div>

<?php
require_once 'design/bottom.php';
?>
