<?php
require_once 'include/settings.php';
require_once 'design/top.php';

// Defines help presented in the right column
define('CM_COLUMN_RIGHT', "
<h2>Remove</h2>
<p>You can remove subscribers...</p>
");
?>
<div class="content">
<h1>Remove subscribers</h1>
<?php
$data = array();
if (isset($_FILES['cm_file']) && is_uploaded_file($_FILES['cm_file']['tmp_name'])) {
	$data = array_merge($data, file($_FILES['cm_file']['tmp_name']));
}

if (isset($_POST['cm_subs']) && strlen($_POST['cm_subs']) > 0) {
	$subString = ereg_replace("(\n|\r)+", "#", $_POST['cm_subs']);
	$subArray = explode('#', $subString);
	$data = array_merge($data, $subArray);
}

if (count($data) > 0) {
	if (isset($_POST['cm_lists']) && is_array($_POST['cm_lists'])) {
		$lists = $_POST['cm_lists'];
	}
	echo '<p>Removing subscribers:</p><p>';
	$nbSub = 0;
	foreach($data as $address) {
		$address = trim($address);
		if (ereg("^([^@ ]+@[^@ ]+\.[^@.; ]+)$", $address)) {
			// format: user@example.com
		    if ($subId = $db->getOne("SELECT sub_id FROM ".CM_TABLE_PREFIX."_subscribers WHERE sub_email='".$address."'")) {
				$db->query("DELETE FROM ".CM_TABLE_PREFIX."_lists_subscribers WHERE sub_id = ".$subId);
	        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_subscribers WHERE sub_id = ".$subId);
	        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_pending WHERE sub_id = ".$subId);
	        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_queued WHERE sub_id = ".$subId);
	        	$db->query("DELETE FROM ".CM_TABLE_PREFIX."_posts_done WHERE sub_id = ".$subId);
				$nbSub++;
	        }
	    } elseif ($address != '') {
			echo '<span class="error">Error: '.$address.'</span><br />';
		}
	}
	echo '<span class="noerror">'.($nbSub > 0 ? $nbSub : 'No').' subscriber'.($nbSub > 1 ? 's' : '').' removed</span></p>';
}
?>

<table width="100%" class="form">
<form enctype="multipart/form-data" action="subscribers_remove.php" method="post">
<tr>
	<td class="label">Upload CSV file:</td>
	<td class="field">
		<input type="file" name="cm_file" /><br />
		<span class="tips">Line format: user@example.com</span>
	</td>
</tr>
<tr>
	<td class="label">Type addresses:</td>
	<td class="field">
		<textarea name="cm_subs" cols="50" rows="10" wrap="virtual"></textarea><br />
		<span class="tips">Line format: user@example.com</span>
	</td>
</tr>
<tr>
	<td colspan="2">
		<input type="submit" value="Remove" />
	</td>
</tr>
</form>
</table>
</div>

<?php
require_once 'design/bottom.php';
?>
