<?php
//This class provides a simple yet fast
//date manipultation routines
//Heavily inspired by PEAR::Date, but it manipulates
//the php timestamps only.

// ATTENTION : ces constantes doivent etre les meme que Date.php de PEAR

/**@#+
 * Output formats.  Pass this to getDate().
 */
/**
 * "YYYY-MM-DD HH:MM:SS"
 */
if (!defined('DATE_FORMAT_ISO'))  
define('DATE_FORMAT_ISO', 1);
/**
 * "YYYYMMSSTHHMMSS(Z|(+/-)HHMM)?"
 */
 if (!defined('DATE_FORMAT_ISO'))
define('DATE_FORMAT_ISO_BASIC', 2);
/**
 * "YYYY-MM-SSTHH:MM:SS(Z|(+/-)HH:MM)?"
 */
 if (!defined('DATE_FORMAT_ISO_EXTENDED'))
define('DATE_FORMAT_ISO_EXTENDED', 3);
/**
 * "YYYY-MM-SSTHH:MM:SS(.S*)?(Z|(+/-)HH:MM)?"
 */
 if (!defined('DATE_FORMAT_ISO_EXTENDED_MICROTIME'))
define('DATE_FORMAT_ISO_EXTENDED_MICROTIME', 6);
/**
 * "YYYYMMDDHHMMSS"
 */
 if (!defined('DATE_FORMAT_TIMESTAMP'))
define('DATE_FORMAT_TIMESTAMP', 4);
/**
 * long int, seconds since the unix epoch
 */
 if (!defined('DATE_FORMAT_UNIXTIME'))
define('DATE_FORMAT_UNIXTIME', 5);
/**@#-*/




if (!class_exists ( 'Date')) {
    class Date
    {
    	var $_date;

        /**
         * Constructor
         *
         * Creates a new Date Object initialized to the current date/time in the
         * system-default timezone by default.  A date optionally
         * passed in may be in the UNIXTIME format.
         * If no date is passed, the current date/time is used.
         *
         * @access public
         * @see setDate()
         * @param mixed $date optional - date/time to initialize
         * @return object Date the new Date object
         */
		function Date($date = null)
		{
			//spip_log('Maciek: trying to create date for "'.$date.'"');

			//Regexp cheerfully stolen from PEAR::Date
			if (preg_match('/^(\d{4})-?(\d{2})-?(\d{2})([T\s]?(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?(Z|[\+\-]\d{2}:?\d{2})?)?$/i', $date, $regs))
			{
				$year       = $regs[1];
				$month      = $regs[2];
				$day        = $regs[3];
				$hour       = isset($regs[5])?$regs[5]:0;
				$minute     = isset($regs[6])?$regs[6]:0;
				$second     = isset($regs[7])?$regs[7]:0;
				$partsecond = isset($regs[8])?(float)$regs[8]:(float)0;

				if (($hour < 0) || ($minute < 0) || ($second < 0) || ($month < 0) || ($day < 0) || ($year < 0))
					$this->_date = 0;
				elseif (($hour == 0) and ($minute == 0) and ($second == 0) and ($month == 1) and ($day == 1) and ($year == 1970))
					$this->_date = 0;
				else
					$this->_date = mktime($hour, $minute, $second , $month, $day, $year);
			}
			else if (is_numeric($date))
			{
				$this->_date = $date;
			}
			else  if (is_string($date) and !empty($date))//try to parse the date
			{
                 $this->_date = strtotime($date);
			}
			else if (is_object($date))//copy constructor simulation
			{
				$this->_date = $date->_date;
			}
			else
			{
				$this->_date = time();
			}
			//spip_log('Maciek: parsed date was '.date('Y-m-d\THis\Z', $this->_date));
		}

        /**
         * Get a string (or other) representation of this date
         *
         * Get a string (or other) representation of this date in the
         * format specified by the DATE_FORMAT_* constants.
         *
         * @access public
         * @param int $format format constant (DATE_FORMAT_*) of the output date
         * @return string the date in the requested format
         */
        function getDate($format = DATE_FORMAT_ISO)
        {

            switch ($format) {
            case DATE_FORMAT_ISO:
                return $this->format('%Y-%m-%d %T');
                break;
            case DATE_FORMAT_TIMESTAMP:
                return $this->format('%Y%m%d%H%M%S');
                break;
            case DATE_FORMAT_UNIXTIME:
                return $this->_date;
                break;
            }
        }

        function getSecond()
        {
        	return intval( date( 's', $this->_date ) );
        }

        function getMinute()
        {
        	return intval( date( 'i', $this->_date ) );
        }

        function getHour()
        {
        	return intval( date( 'G', $this->_date ) );
        }

        function getDay()
        {
        	return intval( date( 'j', $this->_date ) );
        }

        function getMonth()
        {
    		return intval( date( 'm', $this->_date ) );
        }

        function getYear()
        {
        	return intval( date( 'Y', $this->_date ) );
        }


        function setSecond($value)
        {
    		//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($this->getHour(), $this->getMinute(), $value,
        					$this->getMonth(), $this->getDay(), $this->getYear());
        	$this->_date = $date;
        }

        function setMinute($value)
        {
    		//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($this->getHour(), $value, $this->getSecond(),
        					$this->getMonth(), $this->getDay(), $this->getYear());
        	$this->_date = $date;
        }
        function setHour($value)
        {
    		//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($value, $this->getMinute(), $this->getSecond(),
        					$this->getMonth(), $this->getDay(), $this->getYear());
        	$this->_date = $date;
        }

        /** It's a little bit tricky thus slow. You have been warned. */
        function setDay($value)
        {
        	//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($this->getHour(), $this->getMinute(), $this->getSecond(),
        					$this->getMonth(), $value, $this->getYear());
        	$this->_date = $date;
        }

        function setMonth($value)
        {
    		//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($this->getHour(), $this->getMinute(), $this->getSecond(),
        					$value, $this->getDay(), $this->getYear());
        	$this->_date = $date;
        }

        function setYear($value)
        {
    		//attention, it's the american notation (MONTH/DAY/YEAR)
        	$date = mktime($this->getHour(), $this->getMinute(), $this->getSecond(),
        					$this->getMonth(), $this->getDay(), $value);
        	$this->_date = $date;
        }

        /**
         * Copy values from another Date object
         *
         * Makes this Date a copy of another Date object.
         *
         * @access public
         * @param object Date $date Date to copy from
         */
        function copy($date)
        {
            $this->_date = $date->_date;
        }

        /**
         *  Date pretty printing, IDENTICAL to strftime()
         *
         * @access public
         * @param string format the format string for returned date/time
         * @return string date/time in given format
         */
        function format($format)
        {
        	return strftime($format, $this->_date);
        }

        /**
         * Get this date/time in Unix time() format
         *
         * Get a representation of this date in Unix time() format.  This may only be
         * valid for dates from 1970 to ~2038.
         *
         * @access public
         * @return int number of seconds since the unix epoch
         */
        function getTime()
        {
            return $this->_date;
        }

        /**
         * Adds a given number of seconds to the date
         *
         * Adds a given number of seconds to the date
         *
         * @access public
         * @param int $sec the number of seconds to add
         */
        function addSeconds($sec)
        {
        	$this->_date = 	$this->_date + $sec;
        }

        /**
         * Subtract a given number of seconds from the date
         *
         * Subtract a given number of seconds from the date
         *
         * @access public
         * @param int $sec the number of seconds to subtract
         */
        function subtractSeconds($sec)
        {
        	$this->_date = $this->_date - $sec;
        }

        /**
         * Compares two dates
         *
         * Compares two dates.  Suitable for use
         * in sorting functions.
         *
         * @access public
         * @param mixed Date $d1 the first date
         * @param mixed Date $d2 the second date
         * @return int 0 if the dates are equal, -1 if d1 is before d2, 1 if d1 is after d2
         */
        function compare($d1, $d2)
        {
		if (is_object($d1))
			$date1 = $d1->getTime();
		else
			$date1 = $d1;

		if (is_object($d2))
			$date2 = $d2->getTime();
		else
			$date2 = $d2;

		if ($date1 < $date2)
			return -1;
		if ($date1 > $date2)
			return 1;

		return 0;
        }
    } // Date
}

//
// END
?>
