<?php
/** 
 * @version  $Id$
 * @author   trivoallan
 */


/** 
 * Renderer de diffs pour Spip-agora.
 * Bas sur Diff_Renderer_Inline
 * 
 * @package Text_Diff
 */

require_once 'Text/Diff/Renderer.php';

class Text_Diff_Renderer_spip extends Text_Diff_Renderer {

    /**
     * Number of leading context "lines" to preserve.
     */
    var $_leading_context_lines = 10000;

    /**
     * Number of trailing context "lines" to preserve.
     */
    var $_trailing_context_lines = 10000;

    /**
     * Prefix for inserted text.
     */
    var $_ins_prefix = '<ins>';

    /**
     * Suffix for inserted text.
     */
    var $_ins_suffix = '</ins>';

    /**
     * Prefix for deleted text.
     */
    var $_del_prefix = '<del>';

    /**
     * Suffix for deleted text.
     */
    var $_del_suffix = '</del>';

    /**
     * Header for each change block.
     */
    var $_block_header = '';

    /**
     * What are we currently splitting on? Used to recurse to show word-level
     * changes.
     */
    var $_split_level = 'lines';

    /** 
     * Type de texte trait (permet de choisir un formatage)
     */
    var $_type_data = 'texte';

    function _lines($lines, $mode = 'context', $prefix = ' ')
    {
        //    $line_pattern = '<tr class="diff-%s"><td>%s</td><td>%s</td></tr>' . "\n";
        $line_pattern = '<tr class="diff-%s"><td>%s</td></tr>' . "\n";
        $open_line_pattern =  '<tr class="diff-%s"><td>%s';
        $in_words_pattern = '%s';
        
        if ($this->_split_level == 'words') {
            $html = $this->_getFormat( propre(implode(" ", $lines)), $GLOBALS['sa_type_data'] );

            // open
            if ( ! $flag =& $GLOBALS['sa_diff_word_flag'] ) {
                $pattern_name = 'open_line_pattern';
                $flag = 'open';
                echo sprintf( $$pattern_name, 'changed', $html );
            }

            // print words
            else { 
                $pattern_name = 'in_words_pattern'; 
                echo sprintf( $$pattern_name, $html );
            }
            
           
        } else {
            if ( $GLOBALS['sa_diff_word_flag'] == 'open' ) { echo '</td></tr>' . "\n"; unset($GLOBALS['sa_diff_word_flag']); }
            $html = $this->_getFormat( propre(implode("\n", $lines)), $GLOBALS['sa_type_data'] );
            echo sprintf( $line_pattern, $mode, $html );
        }
    }

    function _getFormat( $data, $type ) {
        $patterns = array( 'texte' => '%s',
                           'surtitre' => '<font face="arial,helvetica" size="3"><b>%s</b></font>',
                           'soustitre' => '<font face="arial,helvetica" size="3"><b>%s</b></font>',
                           'titre' => '<br /><span style="border-bottom: 1px dashed rgb(56, 116, 176);"><font color="#3874b0" face="Verdana,Arial,Sans,sans-serif" size="4"><b>%s</b></font></span>',
                           'descriptif' => '<div style="border: 1px dashed rgb(170, 170, 170); padding: 5px; background-color: rgb(228, 228, 228);"><font face="Verdana,Arial,Sans,sans-serif" size="2"><strong class="spip">Descriptif : </strong>%s</font>',
                           'site' => '<br /><font face="Verdana,Arial,Sans,sans-serif" size="2"><strong class="spip">Lien hypertexte : </strong>%s</font></div>',
                           'chapo' => '<strong>%s</strong>',
                           'ps' => '<font size="2" face="Verdana,Arial,Sans,sans-serif"><strong>PS : </strong>&nbsp;%s</font>'
                           );

        if ( ! isset($patterns[$type]) ) { $type = 'texte'; };
        return sprintf( $patterns[$type], $data );
    }

    function _blockHeader($xbeg, $xlen, $ybeg, $ylen)
    {
        return $this->_block_header;
    }

    function _startBlock($header)
    {
        echo $header;
    }

    function _added($lines)
    {
        array_unshift($lines, $this->_ins_prefix);
        array_push($lines, $this->_ins_suffix);
        $this->_lines($lines, 'added');
    }

    function _deleted($lines)
    {
        array_unshift($lines, $this->_del_prefix);
        array_push($lines, $this->_del_suffix);
        $this->_lines($lines, 'deleted');
    }

    function _modified( $orig, $final ) {
        
    }

    function _changed($orig, $final)
    {
        /* If we've already split on words, don't try to do so again - just
         * display. */
        if ($this->_split_level == 'words') {
            $this->_deleted( $orig );
            $this->_added( $final );
            echo "\n";
            return;
        }

        $text1 = implode("\n", $orig);
        $text2 = implode("\n", $final);

        /* Pad to make sure we can split on word boundaries. */
        $text1 = str_replace("\n", " \n", $text1);
        $text2 = str_replace("\n", " \n", $text2);

        /* Non-printing newline marker. */
        $nl = "\0";

        /* Save newlines. */
        $text1 = str_replace("\n", $nl, $text1);
        $text2 = str_replace("\n", $nl, $text2);

        /* Create the diff, splitting on word boundaries (loosely defined as
         * spaces). */
        $diff = &new Text_Diff(explode(' ', $text1),
                               explode(' ', $text2));

        /* Get the diff in inline format.
         * FIXME: should propogate other parameters here too. */
        $renderer = &new Text_Diff_Renderer_Spip(array('split_level' => 'words'));

        /* Restore newlines and display the result. */
        echo str_replace($nl, "\n", $renderer->render($diff));
    }

    /*
  function _startDiff() {}

  function _endDiff() {
    return $this->_str;
  }
    */
}

?>