<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com                  |
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");
require_once (dirname(__FILE__)."/../bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/inc_dxs_factory.php");

/**
 * The DXS representation of a SPIP-Agora article.
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */
class DXS_Article extends DXS_Object {
    

	// {{{ properties
	  
	/**
	* The corresponding agora article business object.
	* @var     BD_article
	* @access  private
	*/  
	var $agoraArticle;

	var $dateCreation;
	var $dateModification;
	

	/**
	* The list of items pointing to all the attachements
        * of this article.
        * XXX TODO We will probably need to inherit the DXS_Item
        * class with the data proper to an article attachement (think size of vignette)
	* @var     array of DXS_Item
	* @access  private
	*/  
	var $attachements;
        

	// }}}
	
	// {{{ constructor
	
	/**
	* DXS_Article constructor.
	* @access public
	*/
	function DXS_Article($feeder)
	{
                    $this->DXS_Object(&$feeder);
                    $this->attachements = array();
	}
	// }}}
	
	// {{{ getAgoraEntity()
	/**
	* Fetches, parses and constructs an object BD_Article 
	* using the data of the item's url.
	* @access public	
	*/
	function getAgoraEntity($item)
	{
		if ($this->initFromItem($item, new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "article")))
		{
			$this->parseArticle();
		}
		return $this->agoraArticle;
	}
	// }}}
		
	// {{{ parseArticle()
	/**
	* Helper function to parse the tree, create
	* the article buisiness object and extract the actual data.
	* Warning, no error checking is performed in this method.
	* @access  private
	*/
	function parseArticle()
	{
		$this->agoraArticle = &recuperer_instance_article();
		$this->agoraArticle->setLang($this->xmlTree->root->getAttribute("lang"));
		
		$max_child = count($this->xmlTree->root->children);
		
		for($i = 0;  $i < $max_child; $i++) 
		{
			switch ($this->xmlTree->root->children[$i]->name)
			{
				case "item" : {
					$anItem = new DXS_Item();
					if ($anItem->initItem($this->xmlTree->root->children[$i]))
					{
						if ($anItem->_itemType == "spipdocument" || $anItem->_itemType == "spiplogo")
						{
							array_push($this->attachements, $anItem);
						}
						else
						{
							if ($this->showErrors)
							{
								echo "<p>Item type '".$anItem->_itemType."' not supported yet!</p>";
								echo '<hr>';
							}
						}
					}

					break;
				}
				case "source" : {
					if ($this->showErrors)
					{
						echo "<p> source child tag not supported yet!</p>";
					}
					break;
				}
				case "pubDate" : {
					$datetime = iso_datetime_xml($this->xmlTree->root->children[$i]->content);
					$this->dateCreation = $datetime;
					break;
				}
				case "updateDate" : {
					$datetime = iso_datetime_xml($this->xmlTree->root->children[$i]->content);
					$this->dateModification = $datetime;
					break;
				}
				case "expDate" : {
					$datetime = iso_datetime_xml($this->xmlTree->root->children[$i]->content);
					$this->agoraArticle->setExpirationDate($datetime);
					break;
				}
				case "surtitre" : {
					$this->agoraArticle->setSurtitre($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "titre" : {
					$this->agoraArticle->setTitre($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "soustitre" : {
					$this->agoraArticle->setSoustitre($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "descriptif" : {
					$this->agoraArticle->setDescriptif($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "chapo" : {
					$this->agoraArticle->setChapo($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "texte" : {
					$this->agoraArticle->setTexte($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "postscriptum" : {
					$this->agoraArticle->setPs($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "" :  break; //XXX BUG in the xml parser
				default : {
					if ($this->showErrors)
					{
						echo "<p> '".$this->xmlTree->root->children[$i]->name."' not supported yet!</p>";
					}
					break;
				}
			}
		}
	
	}

	// }}}


	// {{{ parseAttachments
	/**
	 * Create agora document for article and links them together.
	 * @access public
	 */
	function parseAttachements()
	{
		$attachementReplace = array();

		$factory = & new DXS_Factory();

		foreach ($this->attachements as $item)
		{
			$dxsObject = & $factory->createObject($item, & $this->feeder);
			
			if ( isset($dxsObject) )
			{
		
				$oldId = $dxsObject->getAgoraId();

				if( $this->agoraArticle->getArticleId() )
				{
					$newId = $dxsObject->import($this->agoraArticle->getArticleId());
				}
				else
				{
					$newId = $dxsObject->import();
				}
				if ( $oldId != null && $newId != null) {
					$attachementsReplace[$oldId] = $newId;
				}
			}
		}	

		if ( count($attachementsReplace) > 0 ){
			$tags = array('doc','emb','img');
			$sides = array('left', 'right', 'center');
			foreach ($attachementsReplace as $oldId => $newId) {
				foreach ($tags as $tag ) {
					foreach ($sides as $side)
					{
						$this->agoraArticle->setTexte(
							str_replace('<'.$tag.$oldId.'|'.$side.'>','<'.$tag.$newId.'|'.$side.'>',
								$this->agoraArticle->getTexte()));


						$this->agoraArticle->setTexte(
							str_replace('->>doc'.$oldId.']','->>doc'.$newId.']', $this->agoraArticle->getTexte()));
					}
				}
			}
		}
		
	}
		
	
	// }}}

	// {{{ import()
	/**
	* Import agora Article object into database.
	* @access public	
	*/
	function import($idRubrique = null)
	{
		if ( !isset($this->agoraArticle) )
		{
			$this->parseArticle();
		}
		$agoraArticle = & $this->agoraArticle;

		if ($agoraArticle->getStatut() == '') {
			$agoraArticle->setStatut('prepa');
		}

		if ( !is_null($idRubrique) )
		{
			$agoraArticle->setRubriqueId($idRubrique);
		}

		$agoraArticle->create();
		$agoraArticle->addAuteur($GLOBALS['connect_id_auteur']);

                if( count($this->attachements) )
		{
			$this->parseAttachements();
		}

		$agoraArticle->setDate($this->dateCreation);
		$agoraArticle->setModificationDate($this->dateModification);

		$agoraArticle->update();

		return $agoraArticle->getArticleId();
	}
	// }}}





	// {{{ getAgoraObject()

	function getAgoraObject() {
		return $this->agoraArticle;
	}

	// }}}


	// {{{ getAgoraId()

	function getAgoraId() {
		return $this->agoraArticle->getArticleId();
	}

	// }}}	



	// {{{ export()

	function export(){
		$xml.= preg_replace('/(<url>)(http:\/\/)/i','\1file://',$this->feeder->getFeed());

		if( count($this->attachements) )
		{
			$factory = & new DXS_Factory();
			foreach ($this->attachements as $item)
			{
				$i++;
				$dxsObject = & $factory->createObject($item);
			
				if ( isset($dxsObject) )
				{	$xml.=  $dxsObject->export();
				}
			}	
		}
		return $xml;
	}
	// }}}

}

?>
