<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                      |
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");
require_once (dirname(__FILE__)."/../bd/inc_rubrique_factory.php");


/**
 * The DXS representation of a container.
 * For now, we only support the SPIP-Agora rubrique containers.
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @access	public
 */
class DXS_Container extends DXS_Object {
    

	// {{{ properties
	  
	/**
	* The corresponding agora "rubrique" business object.
	* @var     BD_rubrique
	* @access  private
	*/  
	var $agoraContainer;
	
	/**
	* This container items list.
	* @var     array
	* @access  private
	*/  
	var $items;
	
	// }}}
	
	// {{{ constructor
	
	/**
	* DXS_Container constructor.
	* @access public
	*/
	function DXS_Container()
	{
		
	}
	// }}}
	
	// {{{ getAgoraEntity()
	/**
	* Fetches, parses and constructs an object BD_rubrique 
	* using the data found at the URL $url.
	* Returns a null pointer if the operation failed. After a failed
	* operation, the "initOK" state flag is put to false.
	* XXX What about container (generic) vs rubrique (bound to spip-agora) ?
	* @access public	
	*/
	function getAgoraEntity($item)
	{
		///XXX FIXME:
		$url = $item->_url;
		if (isset($this->agoraContainer))
			unset($this->agoraContainer);
			
		if ($this->initFromFile($url, new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.1", "container")))
		{
			$this->parseRubrique();
		}
		//else
		//	echo "<p>DXS_Container: initFromFile failed</p>";
		return $this->agoraContainer;
	}
	// }}}
		
	// {{{ parseRubrique()
	/**
	* Helper function to parse the tree, create
	* the article buisiness object and extract the actual data.
	* XXX Warning, no error checking is performed in this method.
	* @access  private
	*/
	function parseRubrique()
	{
		$this->agoraContainer = &recuperer_instance_rubrique();
		$this->items = array();
		$this->agoraContainer->setRubriqueId($this->xmlTree->root->getAttribute("id"));
		$lang = $this->xmlTree->root->getAttribute("lang");
		if ($lang !== "")
			$this->agoraContainer->setLang($lang);
		
		$max_child = count($this->xmlTree->root->children);
		//echo "<p>DXS_Article:parseArticle we have $max_child children</p>";
		
		for($i = 0;  $i < $max_child; $i++) 
		{
			//echo '<p>DXS_Article: child: '.$this->xmlTree->root->children[$i]->name.' Value: ';
			//echo $this->xmlTree->root->children[$i]->content.'</p>';
			switch ($this->xmlTree->root->children[$i]->name)
			{
				case "item" : {
					//echo '<p>DXS_Article: new item of type '.$this->xmlTree->root->children[$i]->getAttribute("type").'</p>';
					
					$anItem = new DXS_Item();
					if ($anItem->initItem($this->xmlTree->root->children[$i]))
						array_push($this->items, $anItem);
					else
					{
						$this->debugLastError = "300/BAD ITEM";
					}
					break;
				}
				

				case "creationdate" : {
					$this->agoraContainer->setDate($this->xmlTree->root->children[$i]->content);
					break;
				}
				
				case "name" : {
					$this->agoraContainer->setTitre($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "description" : {
					$this->agoraArticle->setTexte($this->xmlTree->root->children[$i]->content);
					break;
				}
                                case "" :  break; //XXX BUG in the xml parser
                                default : {
                                    echo "<p> '".$this->xmlTree->root->children[$i]->name."' not supported yet!</p>";
                                    break;
                                }
			}
		}
	
	}
	
	// }}}



	// {{{

	function getAgoraObject() {
		return $this->agoraContainer;
	}

	// }}}


	// {{{

	function getAgoraId() {
		return $this->agoraContainer->getRubriqueId();
	}

	// }}}	

}

?>
