<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com                  |
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");

require_once (dirname(__FILE__).'/../bd/inc_document_factory.php');


/**
 * The DXS representation of a SPIP-Agora attached document.
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */
class DXS_Document extends DXS_Object {
    

	// {{{ properties
	  
	/**
	* The corresponding document business object.
	* @var     BD_article
	* @access  private
	*/  
	var $agoraDocument;
	// }}}
	
	// {{{ constructor
	
	/**
	* DXS_Document constructor.
	* @access public
	*/
	function DXS_Document($feeder)
	{
		$this->DXS_Object(&$feeder);
	}
	// }}}
	
	// {{{ getAgoraEntity()
	/**
	* Fetches, parses and constructs an object BD_Document 
	* using the data of the $item's url
	* @access public	
	*/
	function getAgoraEntity($item)
	{
		if ($this->initFromItem($item, new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "spipdocument")))
		{
			$this->parseDocument();
		}
		else
			echo "<h2>DXS_Document: initfromitem failed</h2>";
		return $this->agoraDocument;
	}
	// }}}
		
	// {{{ parseDocument()
	/**
	* Helper function to parse the tree, create
	* the document buisiness object and extract the actual data.
	* Warning, no error checking is performed in this method.
	* @access  private
	*/
	function parseDocument()
	{
		$this->agoraDocument = &recuperer_instance_document();
		$max_child = count($this->xmlTree->root->children);
		
		for($i = 0;  $i < $max_child; $i++) 
		{
			switch ($this->xmlTree->root->children[$i]->name)
			{
				case "source" : {
					if ($this->showErrors)
					{
						echo "<p> source child tag not supported yet!</p>";
					}
					break;
				}
				case "data" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->agoraDocument->setFichierContenuBase64($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "uri" : {
					//XXX This is a bug: sometimes "uri" contains the complete URL and not only the /IMG/ part
					$content = $this->xmlTree->root->children[$i]->content;
					if (substr($content, 0, 5) == 'http:') {
						preg_match('/IMG\/.+\/([^\/]+)/', $content, $res);
						$content = '/'.$res[0];
					}
					$this->agoraDocument->setFichier($content);
					break;
				}
                                case "type" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->agoraDocument->setTypeId($this->xmlTree->root->children[$i]->content);
					break;
				}
                                case "mode" : {
					$this->agoraDocument->setMode($this->xmlTree->root->children[$i]->content);
					//echo "<p> mode: ".$this->xmlTree->root->children[$i]->content."</p>";
					break;
				}
                                case "titre" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->agoraDocument->setTitre($this->xmlTree->root->children[$i]->content);
					break;
				}
                                case "descriptif" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->agoraDocument->setDescriptif($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "width" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					if ( $this->xmlTree->root->children[$i]->content > 0 )
						$this->agoraDocument->setLargeur($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "height" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					if ( $this->xmlTree->root->children[$i]->content > 0 )
						$this->agoraDocument->setHauteur($this->xmlTree->root->children[$i]->content);
					break;
				}
                                case "id" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->agoraDocument->setDocumentId($this->xmlTree->root->children[$i]->content);
					break;
				}

				case "" :  break; //XXX BUG in the xml parser
				default : {
					if ($this->showErrors)
					{
						echo "<p> '".$this->xmlTree->root->children[$i]->name."' not supported yet!</p>";
					}
					break;
				}
			}
		}
	}
	
	// }}}

	// {{{
	/**
	 * Import document into agora db and if needed
	 * link it with given article.
	 * @access public
	 */
	function import($idArticle = null)
	{
		if ( !isset($this->agoraDocument) )
		{
			$this->parseDocument();
		}

		$this->agoraDocument->create();
		if ( !is_null($idArticle) )
		{
			$this->agoraDocument->saveData();
			$this->agoraDocument->linkToObject($idArticle, 'article');
		}

		return $this->agoraDocument->getDocumentId();;
	}

	// }}}



	// {{{ export

	function export()
	{
		return $this->feeder->getFeed();
	}
	// }}}



	// {{{

	function getAgoraObject() {
		return $this->agoraDocument;
	}

	// }}}



	// {{{

	function getAgoraId() {
		return $this->agoraDocument->getDocumentId();
	}

	// }}}	
}

?>
