<?php
//
// +----------------------------------------------------------------------+
// | SPIP-Agora XML Layer                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com                        |
// +----------------------------------------------------------------------+
//

//we are waiting for a solution of the bug:
//    http://pear.php.net/bugs/bug.php?id=1238
require_once 'PEARTree.php';

class DXS_TrivialValidatorData {
    var $_namespace;
    var $_rootElement;
    
    function DXS_TrivialValidatorData($space, $root)
    {
        $this->_namespace = $space;
        $this->_rootElement = $root;
    }
}


/**
 * Clever-Age XMLTree class is a base class for every XML representation 
 * of Agora data (through DXS).
 * @package	XML
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */
class DXS_Object
{
	// {{{ properties
	  
	/**
	* The PEAR xml tree.
	* @var     XML_Tree
	* @access  private
	*/  
	var $xmlTree;
	
	/**
	* The feeder is responsible in getting the raw XML data and parsing it to the xml tree.
	*/
	var $feeder;

	// }}}
	    
	    
	// {{{ constructor

	/**
	* DXS_Object constructor.
	*
	* @access public
	*/    
	function DXS_Object(&$feeder)
	{
            $this->feeder = &$feeder;
	}
	
	// }}}
	
	// {{{ getInitOK()
	/** @access public
	*/
	function getInitOK()
	{
		return (isset($this->xmlTree));
	}
 
	// }}}

	// {{{ getXMLTree()
	/** @access public
	*/
	function getXMLTree()
	{
		return $this->xmlTree;
	}
 
	// }}}
        
	// {{{ handleCDATA()

	/** There is a special feature in the DXS project: in any CDATA tags, if an "escape"
	* argument is present, every occurence of the value
	* of this argument is replaced by "]]>" (the end of the CDATA section).
	* That means it is possible to send virtually EVERY string
	* using that class, even those that contain the "]]>" substring (normally
	* forbidden in the CDATA sections, of course). <br/>
	* For performance reasons, this treatement is not made automaticaly
	* (and what's more, from time to time, one needs to avoid that).
	* That's why this method exists. It takes a tag and if needed (if "escape"
	* is present), it handles the content of the tag. No treatment is performed
	* on the children.
	* <b>Remember to pass the $xmlCDATATag by reference</b>
	* @access public
	*/
	function handleCDATA($xmlCDATATag)
	{
	        $escapeStr = $xmlCDATATag->getAttribute("escape");
		if ($escapeStr != "")
		{
			$content = str_replace($escapeStr, "]]>", $xmlCDATATag->content);
			$xmlCDATATag->content = $content;
		}
	}
		
		
	
	// }}}
	
	

	// {{{ initFromItem
	/** Returns false if something went wrong or the xmlTree object in case of success
	*/
	function initFromItem($item, $validatorData)
	{
		$this->xmlTree = $this->feeder->getXMLTree($item, $validatorData);
		return (isset($this->xmlTree));
	}

	// {{{ initToFile()



	// {{{ getAgoraEntity()
	
	/**
	* Fetches, parses and constructs an object "metier"
	* using the data found in the url attribute of the given item
	* @access public	
	*/
	function getAgoraEntity($item) { /* PSEUDO ABSTRACT */ }
	
	// }}}



	// {{{ getAgoraObject()

	/**
	* Fetches agora object withour any other action.
	* @access public	
	*/
	function getAgoraObject() { /* PSEUDO ABSTRACT */ }

	// }}}




	//{{{ getAgoraId()

	/**
	* Fetches agora object id.
	* @access public	
	*/
	function getAgoraId() { /* PSEUDO ABSTRACT */ }

	// }}}



	// {{{ import()
	
	/**
	 * Import agora object into database;
	 * @access public	
	 */
	function import() { /* PSEUDO ABSTRACT */ }
		
	// }}}



	// {{{ export()
	
	/**
	 * Export agora object;
	 * @access public	
	 */
	function export() { /* PSEUDO ABSTRACT */ }
		
	// }}}


}

?>