<?php
//
// +----------------------------------------------------------------------+
// | SPIP-Agora XML Layer                                                 |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com		  |
// +----------------------------------------------------------------------+
//

/**
 * Clever-Age Feeder class is a base class for every XML representation
 * of Agora data in string(through DXS).
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */

class Feeder
{

	/**
	 * Content from which we create/get xmlTree;
	 * @var     String
	 * @access  private
	 */
	var $feed;

	// {{{ Feeder
	/**
	 * Constructor
	 */
	function &Feeder(){


	}

	// }}}




	// {{{ feed()
	/**
	 * Feed object with data string from which
	 * later we will create xmlTree for variuos
	 * DXS objects.
	 * @param	Strning
	 * @access public
	 */
	function feed($feed){
		$this->feed = $feed;
	}

	// }}}



	// {{ getObjectData

	/**
	 * Constructor of xml tree from DXS Objects. It gets its content
	 * cirectly from file or from previous read data.
	 * @param 	 object		Simple XML validator
	 * @param	 object		Item from which we create DXS object
	 * @access public
	 */
	function getXMLTree($item, $validatorData){
		spip_debug('Feeder: getXMLTree for url='.$item->_url);
		if( $item->_url != ''){

			preg_match('/([a-zA-Z]+):\/\/.+\/([^\/]+)/', $item->_url, $source);

			// Type of searched tag
			$name = $item->_itemType;

			// id of searched tag
			$id = $source[2];

 			// file://, http://
			$source = $source[1];

			spip_debug('Feeder: source is '.$source);
			switch ($source)
			{
				case 'file' : {
					if( !isset($this->feed))
					{
						spip_debug('Feeder: getting from file');
						return $this->getFromFile($item, $validatorData);
					}
					else
					{
						spip_debug('Feeder: getting from feed');
						return $this->getFromString($this->feed, $validatorData, $id);
					}
					break;
				}

				case 'http' : {
					return $this->getFromFile($item, $validatorData);
					break;
				}

				default : {
				}
			}
		}
		else
		{
			return $this->getFromString($this->feed, $validatorData);
		}

	}

	// }}}



	// {{{ getFromFile()

	/**  This function behaves like getFromString, but
	* reads the data to parse from the file $item->_url.
	* If allow_url_fopen is On in php.ini, you can also use URLs.
	* @access public
	*/
	function getFromFile($item, $validatorData)
	{
		$fileName = $item->_url;
		//reading the file
		$this->feed = '';
		$fp = @fopen($fileName, "r");
		if (!is_resource($fp))
		{
			return NULL;
		}
		//flock($fp, LOCK_SH);
		while(!feof($fp)) 
		{
			$this->feed .= fgets($fp, 1024);
		}
		//flock($fp, LOCK_UN);
		fclose($fp);

		return $this->getFromString($this->feed, $validatorData);

	}


	// {{{ getFromString()

	/** Initializes this object from an xml string.
	* This version of xml tree is only able to verify
	* whether the root element and namespace are those specified 
        * by TrivialValidatorData $validatorData.
	* Future versions will hopefully support the full XMLSchema validation.
	*
	* If id param is not null it will create xmlTree from tag with given id.
	*
	* @access public
	*/
	function getFromString($xmlContent, $validatorData, $id = null)
	{
		$xmlTree = & new XML_Tree();
		$err = $xmlTree->getTreeFromString($xmlContent);

		if (!PEAR::isError($err))
		{
			if( $id != null )
			{
				$max_child = count($xmlTree->root->children);
				for($i = 0;  $i < $max_child; $i++)
				{
					if( htmlspecialchars($id) == htmlspecialchars($xmlTree->root->children[$i]->getAttribute('id')))
					{
						$xmlTreeById = & new XML_Tree();
						$root = & $xmlTreeById->addRoot($xmlTree->root->children[$i]->name);
						$root->setAttribute('lang', $xmlTree->root->children[$i]->getAttribute("lang"));
						$root->setAttribute('xmlns', $xmlTree->root->children[$i]->getAttribute("xmlns"));
						foreach($xmlTree->root->children[$i]->children as $child)
						{
							$root->addChild($child->clone());
						}
						break;
					}
				}
				$xmlTree = & $xmlTreeById;
			}
			//very simple validation...
			if (($xmlTree->root->name == $validatorData->_rootElement)
				&& ($xmlTree->root->getAttribute('xmlns') == $validatorData->_namespace))
			{
				return $xmlTree;
			}
		}
		
		return NULL;
	}
	// }}}



	// {{{ getFeed()
	/** 
	* @access public
	*/
	function getFeed()
	{
		if (isset($this->feed))
			return $this->feed;
	}
	// }}}



}

?>