<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com>                 |
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");
require_once (dirname(__FILE__)."/../bd/inc_rubrique_factory.php");


/**
 * The DXS representation of a file (container). It is only use to export article
 * in only one XML file with its logo, documents.
 * For now, we only support the SPIP-Agora rubrique containers.
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com
 * @access	public
 */
class DXS_File extends DXS_Object {
    

	// {{{ properties
	  
	/**
	* This container items list.
	* @var     array
	* @access  private
	*/  
	var $items;

	var $article;


	var $agoraFile;
	// }}}
	
	// {{{ constructor
	
	/**
	* DXS_File constructor.
	* @access public
	*/
	function DXS_File($feeder)
	{
		$this->feeder = & $feeder;
	}
	// }}}



	// {{{ getAgoraEntity()
	/**
	* @access public
	*/
	function getAgoraEntity($item)
	{
		if ($this->initFromItem($item, new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "file")))
		{
			$this->parseFile();
		}
		return $this->agoraFile;
	}
	// }}}


	
	// {{{ parseFile()
	/**
	* @access  private
	*/
	function parseFile()
	{
		$max_child = count($this->xmlTree->root->children);
		
		for($i = 0;  $i < $max_child; $i++) 
		{
			switch ($this->xmlTree->root->children[$i]->name)
			{
				case "article" : {
					$this->article = & new DXS_Article(&$this->feeder);

					$this->article->xmlTree = & new XML_Tree();
					$root = & $this->article->xmlTree->addRoot('article');
					$root->setAttribute('lang', $this->xmlTree->root->children[$i]->getAttribute("lang"));
					$root->setAttribute('xmlns', $this->xmlTree->root->children[$i]->getAttribute("xmlns"));
					foreach($this->xmlTree->root->children[$i]->children as $child)
					{
						$root->addChild($child);
					}

					
					break;
				}
				case "" :  break; //XXX BUG in the xml parser
				default : {
					if ($this->showErrors)
					{
						echo "<p> '".$this->xmlTree->root->children[$i]->name."' not supported yet!</p>";
					}
					break;
				}
			}
		}
	}
	
	// }}}


	function import($idRubrique = null){
		return $this->article->import($idRubrique);
	}




	// {{{ export

	function export($dxsObjects = array())
	{
		if( count($dxsObjects))
		{
			foreach($dxsObjects as $dxsObject)
			{
				$this->content.= $dxsObject->export();
			}
		}
		$this->content = preg_replace('/<\?xml(\s)+version="[0-9].[0.9]"(\s)*\?>/i','',$this->content);

		return "<file xmlns=\"http://www.clever-age.com/DXS:1.2\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"
		xsi:schemaLocation=\"xmlns=http://www.clever-age.com/DXS:1.2 schema-spiparticle.xml\">".$this->content."</file>";


	}




}

?>
