<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/feeder.php");
require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");
require_once (dirname(__FILE__)."/article.php");
require_once (dirname(__FILE__)."/document.php");
require_once (dirname(__FILE__)."/logo.php");
require_once (dirname(__FILE__)."/file.php");
require_once (dirname(__FILE__)."/../bd/inc_article_factory.php");

//XXX BUG dans Agora:
//require_once (dirname(__FILE__)."../../../mes_options.php3");


/**
 * The factory class aims at become the central point
 * of the DXS API.
 * Its usage is meant to be quite simple: 
 * 1. You must have an initial item treeNode from somewhere else
 * (for example from a prodig rss channel)
 * 2. With the xml node, you get an real DXS Item object
 * 3. With the item object, you get the real DXS Object pointed
 * by the item. 
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */
class DXS_Factory {

    // {{{ properties
    /** The validator data used to verify the object.s
    * @access private
    */
    var $xmlValidator;
    
    // }}}
    
    // {{{ constructor
    
    /**
    * DXS_Article constructor.
    * @access public
    */
    function DXS_Factory()
    {
        $this->xmlValidator = new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.1","XXX");
    }
    // }}}


   // {{{ newItem()
    /** XXX This is temporary
    * @access public
    */
    function newItem($url, $type)
    {
        $item = new DXS_Item();
	$item->_url = $url;
	$item->_itemType = $type;
        return $item;
    }
    // }}}

   
    // {{{ createItem()
    /** Creates the item from the xml tree node.
    * @access public
    */
    function createItem($itemNode)
    {
        $item = new DXS_Item();
        if ($item->initItem($itemNode))
        {
            return $item;
        }
        else
        {
            return NULL;
        }
    }
    // }}}

    // {{{ itemTypeSupported()
    /** Returns true if this factory is able
    * to handle the object type referenced
    * by the item.
    * XXX This function could also handle namespaces, but how?
    * @access public
    */
    function itemTypeSupported($item)
    {
        switch ($item->_itemType)
        {
            case "file" :
            case "container" :
            case "spipdocument" :
            case "spiplogo" :
            case "spiparticle" : {
                return TRUE;
            }
        }
        
        return FALSE;
    }

                
    // {{{ createObject()
    /** Creates and initializes the object of appropriate type
    * Downloads the data pointed by the item.
    * If anything goes wrong, returns an unset pointer.
    * @access public
    */
    function createObject($item, $feeder = null)
    {

	if (!isset($feeder) || $feeder == null)
	{
		$feeder = & new Feeder();
	}

        $object = NULL;
        switch ($item->_itemType)
        {
            case "file" : {
                $object = new DXS_File(&$feeder);
                $object->getAgoraEntity($item);
                if (!$object->getInitOK())
                {
                    //var_dump($object);
                    unset($object);
                }
                break;
            }

            case "spiparticle" : {
                $object = new DXS_Article(&$feeder);
                $object->getAgoraEntity($item);
                if (!$object->getInitOK())
                {
                    //var_dump($object);
                    unset($object);
                }
                break;
            }
	    case "spipdocument" : {
                $object = new DXS_Document(&$feeder);
                $object->getAgoraEntity($item);
                if (!$object->getInitOK())
                {
                    //var_dump($object);
                    unset($object);
                }
                break;
            }
            case "spiplogo" : {
                $object = new DXS_Logo(&$feeder);
                $object->getAgoraEntity($item);
                if (!$object->getInitOK())
                {
                    //var_dump($object);
                    unset($object);
                }
                break;
            }
            case "container" : {
                $object = new DXS_Container(&$feeder);
                $object->getAgoraEntity($item);
                if (!$object->getInitOK())
                {
                    //var_dump($object);
                    unset($object);
                }
                break;
            }
	

	}
        return $object;
    }
    // }}}
    
}

?>
