<?php
//
// +----------------------------------------------------------------------+
// | Document eXchange System                                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Maciek Borowka <maciek@clever-age.com                        |
// | Author: Lukasz Zachulski <lzachulski@clever-age.com                  |
// +----------------------------------------------------------------------+
//

require_once (dirname(__FILE__)."/dxs_object.php");
require_once (dirname(__FILE__)."/item.php");

require_once (dirname(__FILE__).'/../bd/inc_document_factory.php');


/**
 * The DXS representation of a SPIP-Agora article's logo.
 * It doesn't contain SPIP-Agora object as many others DXS Object,
 * but it keep logo data insied in variables.
 * You can call it pseudo DXS Object;)
 * @package	DXS
 * @author Maciek Borowka <maciek@clever-age.com>
 * @author Lukasz Zachulski <lzachulski@clever-age.com>
 * @access	public
 */
class DXS_Logo extends DXS_Object {
    

	/**
	 * XXX : It would be the best to create
	 * class which will contain logo object.
	 */	
	var $agoraLogo;

	var $logoType;
	var $logoUri;
	var $logoData;

	/**
	* DXS_Logo constructor.
	* @access public
	*/
	function DXS_Logo($feeder)
	{
                    $this->DXS_Object(&$feeder);
	}
	// }}}


	
	// {{{ getAgoraEntity()
	/** 
	* @access public
	*/
	function getAgoraEntity($item)
	{
		if ($this->initFromItem($item, new DXS_TrivialValidatorData("http://www.clever-age.com/DXS:1.2", "spiplogo")))
		{
			$this->parseLogo();
		}
		else
			echo "<h2>DXS_Logo: initfromitem failed</h2>";
	}
	// }}}


		
	// {{{ parseLogo()
	/**
	* @access  private
	*/
	function parseLogo()
	{
                $max_child = count($this->xmlTree->root->children);
		
		for($i = 0;  $i < $max_child; $i++) 
		{
			switch ($this->xmlTree->root->children[$i]->name)
			{
				case "source" : {
					if ($this->showErrors)
					{
						echo "<p> source child tag not supported yet!</p>";
					}
					break;
				}
				case "data" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
 					$this->logoData = base64_decode($this->xmlTree->root->children[$i]->content);
					break;
				}
				case "uri" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->logoUri = $this->xmlTree->root->children[$i]->content;
					break;
				}
                                case "type" : {
					//echo "<p>".strlen($this->xmlTree->root->children[$i]->content)." of bytes of data received. </p>";
					$this->logoType = $this->xmlTree->root->children[$i]->content;
					break;
				}

				case "" :  break; //XXX BUG in the xml parser
				default : {
					if ($this->showErrors)
					{
						echo "<p> '".$this->xmlTree->root->children[$i]->name."' not supported yet!</p>";
					}
					break;
				}
			}
		}
	
	}
	
	// }}}



	// {{{ import
	/**
	 * Import logo on hd.
	 * @access public
	 */
	function import($idArticle = null)
	{
		$mode = 'w';

		if( $idArticle ){
			$this->logoUri = preg_replace('/[0-9]+/',$idArticle, $this->logoUri);
		}
        	if ( strlen($this->logoData) ) {
			if ( $fhandler = fopen('../'.$this->logoUri, $mode) ){
				flock($fhandler, LOCK_EX);

				fwrite($fhandler, $this->logoData);

				flock($fhandler, LOCK_UN);
			} else {
                		return false;
			}	
			fclose($fhandler);
		} else {
			return false;
        	}
	}

	// }}}





	// {{{ getAgoraObject()

	function getAgoraObject() {
		return null;
	}

	// }}}



	// {{{ getAgpraId()

	function getAgoraId() {
		return null;
	}

	// }}}	



	// {{{ export

	function export()
	{
		return $this->feeder->getFeed();
	}
	// }}}



}

?>
