<?php
define('EMBARGOFILENAME', dirname(__FILE__).'/../../data/embargo.php');

function writeEmbargo($date, $id_article) {
	$embargos = array(); 
	if (file_exists(EMBARGOFILENAME)) {
		$embargos = file(EMBARGOFILENAME);
	}
	
    // lock 
    
	$embargos[] = $date.'|'.$id_article;
	$embargos = array_unique($embargos);
	if ($f = fopen(EMBARGOFILENAME, 'w')) {
        while (!flock($f, LOCK_EX)); // boucle d'attente 
		fwrite($f, implode("\n", $embargos));
        flock($f, LOCK_UN); // libre le verrou
		fclose($f);
	}

    // unlock
}

function removeEmbargo($dateIdarticle) {

	if (file_exists(EMBARGOFILENAME)) {
		$embargos = file(EMBARGOFILENAME);
	}
	if ( !is_null( $key = array_search($dateIdarticle, $embargos) ) ) {
		unset($embargos[$key]);
	}
	
	// TODO : 
    // consolider le fichier, au moins gicler les lignes vides, au mieux gicler les trucs qui sont pas des dates  
    
    // lock 
    
	if ($f = fopen(EMBARGOFILENAME, 'w')) {
        while (!flock($f, LOCK_EX)); // boucle d'attente 
		fwrite($f, implode("\n", $embargos));
		flock($f, LOCK_UN); // libre le verrou
        fclose($f);
	}
    
    // unlock

}

function readNextEmbargo() {
	
	if (file_exists(EMBARGOFILENAME)) {
        // on accede pas au fichier plus de 4 fois par minutes
        if ( (time() - fileatime(EMBARGOFILENAME)) > 15 ) {
		  $embargos = file(EMBARGOFILENAME);
          if (count($embargos) == 0 ) { // plus rien a traiter
            unlink (EMBARGOFILENAME);
          } else {
            touch (EMBARGOFILENAME); // on a traiter le fichier donc on update sa date
          }
        }
	}
	if ($embargos) {
        asort($embargos);
        return $embargos[0];
    } else {
        return false;
    }
	

}

function clearCache($fonds) {
	require_once dirname(__FILE__)."/../date.php";
	
	if ( ($nextEmbargo = readNextEmbargo()) != false ) {
		$now = new Date();

		// on spare la date et l'id_article
		list($date, $id_article) = explode("|", $nextEmbargo);
        $nextEmbargoDate = new Date($date);

		if (Date::compare($nextEmbargoDate->getDate(), $now->getDate()) <= 0) {
			include_once (dirname(__FILE__) . '/../cacheHTML/inc_cacheHTML_factory.php');
            if (!file_exists( dirname(__FILE__) . '/embargo.conf.php' )) die ('embargo ... je ne trouve pas mon fichier de conf : embargo.conf.php'); 
            require (dirname(__FILE__) . '/embargo.conf.php');
			while ( list(, $fond) = each($fonds) ) {
				$cacheHTML = &recuperer_instance_cacheHTML($fond, null, null, null);    
				$cacheHTML->destroyAllCache();
			}
			removeEmbargo($nextEmbargo);
			
			include_once (dirname(__FILE__) . '/../bd/inc_article_factory.php');
			$article = &recuperer_instance_article();
			$loadOk = $article->load($id_article);
			if ( !PEAR::isError($loadOk) ) {
				if ($article->isExpired()) {
					include_once (dirname(__FILE__) . '/../bd/inc_rubrique_factory.php');
					$rubriqueMetier = &recuperer_instance_rubrique();
					$rubriqueMetier->load($article->getRubriqueId());
					if ( $rubriqueMetier->checkForExpired() ) {
						$update = $rubriqueMetier->update();
						if ( PEAR::isError($update) ) {         
							PEAR::raiseError("Rubrique::update $id error".$update->getMessage(), PEAR_LOG_ERR); 
						}
					}
				}
			}
		}
	}
}
?>