<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer
// $Id$

require_once dirname(__FILE__)."/../bd/inc_index_dico_factory.php";
require_once dirname(__FILE__)."/Indexer_Utils.php";


class Indexer {
    
    // {{{ properties

    /**
     * type of Indexation.
     * @var     String
     * @access  private
     */
    var $_type;
    
    /**
     * $mots contains (hash, mot).
     * @var     Array
     * @access  private
     */
    var $_mots;

    /**
     * $index contains (hash, poids).
     * @var     Array
     * @access  private
     */
    var $_index;
    
    /**
     * $poids contains the definition of weight.
     * @var     Array
     * @access  private
     */
    var $_poids;
    
    /**
     * $full is a flag to index more data.
     * @var     Array
     * @access  private
     */
    var $_full = true;    

    // }}}

	// {{{ getFull()
	
	function getFull() {
		return $this->_full;
	}

	// }}}
	
	// {{{ setFull($full)
	
	function setFull($full) {
		$this->_full = $full;
	}
	
	// }}}
	
    // {{{ factory($typeIndexer)
    
    /**
     * Indexer Factory.
     *
     * @access public
     */
    function &factory($typeIndexer) {
		
        // inclusion de mes_options.php3 ou le type_indexation peut tre defini
        if (file_exists(dirname(__FILE__)."/../../mes_options.php3")) {
            include_once (dirname(__FILE__)."/../../mes_options.php3" );
        }
        
        
		if(!file_exists(dirname(__FILE__).'/'.$GLOBALS['type_indexation'].'/Indexer_'.$typeIndexer.'_'.$GLOBALS['type_indexation'].'.php')) {
            include_once(dirname(__FILE__).'/common/Indexer_'.$typeIndexer.'_common.php');
            $classname = 'Indexer_'.$typeIndexer.'_common';
        }
        else {
            include_once(dirname(__FILE__).'/'.$GLOBALS['type_indexation'].'/Indexer_'.$typeIndexer.'_'.$GLOBALS['type_indexation'].'.php');
            $classname = 'Indexer_'.$typeIndexer."_".$GLOBALS['type_indexation'];
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", PEAR_LOG_ALERT,
                                    null, null, null, null, false);
        }
		
        $obj = & new $classname();
        
        return $obj;

    }

    // }}}

	// {{{ constructor

    /**
     * Indexer constructor.
     *
     * @access public
     */

    function Indexer() {
    }

    // }}}

    // {{{ index($id_objet, $forcer_reset = true, $full = true)

    /**
     * index an object
     * @param $id_objet
     * @param $forcer_reset
     * @param $full
     * @access public
     */

    function index($id_objet, $forcer_reset = true) {
    
    	if (!$id_objet OR (!$forcer_reset AND $this->alreadyIndex($id_objet))) return;
		
    	if (function_exists(spip_log)) {
    		spip_log("indexation " . $this->_type . " $id_objet");
    	}
    	
    	$this->_index = array();
				
		$indexDicoMetier = &recuperer_instance_index_dico();
		
		$this->_indexData($id_objet);
		
        if (count($this->_index) > 0) {
			
		    $indexDicoMetier->addDico($this->_mots);

			reset($this->_index);
			
			$this->_createIndex($id_objet);

		}

    }

    // }}}
    
    // {{{ _indexer_chaine($texte, $val = 1, $min_long = 3)

	function _indexer_chaine($texte, $val = 1, $min_long = 3, $emplacement = 'none') {
        if ($val == 0) { // pas d'indexation pour un poids de zro
            return;
        } 

        /* FAIT PAR fabriquer_chaine_indexation
		// Nettoyer les tags, entites HTML, signes diacritiques...
		$texte = ' '.ereg_replace("<[^>]*>"," ",$texte).' ';
		$texte = Indexer_Utils::nettoyer_chaine_indexation($texte);

		// Nettoyer les caracteres non-alphanumeriques
		$regs = Indexer_Utils::separateurs_indexation();
		$texte = strtr($texte, $regs, ereg_replace('.', ' ', $regs));

		// Cas particulier : sigles d'au moins deux lettres
		// $texte = ereg_replace(" ([A-Z][0-9A-Z]{1,".($min_long - 1)."}) ", ' \\1___ ', $texte);
		$texte = strtolower($texte);
        */

        $texte = Indexer_Utils::fabriquer_chaine_indexation($texte);
		// Separer les mots
		$table = Indexer_Utils::spip_split(" +", $texte);

		while (list(, $mot) = each($table)) {
			if (strlen($mot) >= $min_long) {
				$h = substr(md5($mot), 0, 16);
				//$this->_index[$h] += $val;
				$this->_index[$h][$emplacement]['points'] += $val;
                $this->_index[$h][$emplacement]['emplacement'] = $emplacement;
				$this->_mots[] = array("hash"=>"0x$h", "dico"=>$mot);				
			}
		}
	}
    
    // }}}
    
    // {{{ alreadyIndex($id_objet)

    /**
     * check id an object is indexed.
     * @param $id_objet
     * @access public
     */
     
	function alreadyIndex($id_objet) {
        // TODO : raiseError
	}

    // {{{ _indexData($id_objet)

    /**
     * this method initialses this attributes 'mots' and 'index' 
     * @param $id_objet
     * @access private
     */

    function _indexData($id_object) {
        // TODO : raiseError
    }

    // }}}

    // {{{ _createIndex($id_objet)

    /**
     * this method create indexation data 
     * @param $id_objet
     * @access private
     */

    function _createIndex($id_object) {
        $tmp = split ('_', get_class($this));
        $classname = strtolower($tmp[1]).'s';
        $indexMetier = call_user_func ('recuperer_instance_index_'.$classname);
        
        if (is_object($indexMetier)) {
        // while (list($hash, $points) = each($this->_index)) {
            foreach ($this->_index as $hash => $info1) {
                foreach ($info1 as $emplacement => $info) {
                    $indexMetier->setHash("0x$hash");
                    //$indexArticleCreateMetier->setPoints("$points");
                    $indexMetier->setPoints($info['points']);
                    $indexMetier->setEmplacement($emplacement);
                    $indexMetier->setId($id_object);
                    $create_ok = $indexMetier->create();
                    if (PEAR::isError($create_ok)) {
                        return PEAR::raiseError("[".get_class($this)."] creating index ".$create_ok->getMessage(), PEAR_LOG_ERR,null, null, null, null, false);
                    }
                }
            }
        } else {
            PEAR::raiseError("[".get_class($this)."] creating index non object returned", PEAR_LOG_CRIT,null, null, null, null, false);
        }
    }

    // }}}
    
    
    // {{{ _findConfigFile($type_indexation)
    
    /**
    * trouve le fichier de conf
    * @param string type_indexation le type d'indexation
    * @return string chemin du fichier de conf
    **/
    
    function _findConfigFile($name_file, $type_indexation) {
        if(file_exists(dirname(__FILE__)."/".$type_indexation.'/'.$name_file.'_'.$type_indexation.".php")) {
            return dirname(__FILE__)."/".$type_indexation.'/'.$name_file.'_'.$type_indexation.".php";
        } elseif (file_exists(dirname(__FILE__)."/common/".$name_file."_common.php")) {
	       return dirname(__FILE__)."/common/".$name_file."_common.php";
        } else {
            PEAR::raiseError("[".get_class($this)."] can't find my configfile $name_file $type_indexation", PEAR_LOG_CRIT,null, null, null, null, false);
        }
    
    }
    
    // }}}


    // {{{ _setPoids ($configfile)
    
    /**
    * positionne les poids ($this->_poids)
    * @param chemin du fichier de conf
    * 
    **/
    
    function _setPoids ($configfile) {
        include ($configfile);
        $this->_poids = $poids;
    } 
    
    
    // }}}

}

?>
