<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Useful methods for the indexing
// $Id$
// TO DO:
// Attention ces fonctions sont des copies des fonctions dfinies dans ecrire/inc_index.php3 
// Il reste  se dtacher de inc_version.php3 (Penser  un module de gestion des mtas) pour rendre le module "Indexer" indpendant



// TODO phpdoc

require_once (dirname(__FILE__)."/../../inc_charsets.php3");
require_once (dirname(__FILE__)."/../utils/meta.php");

class Indexer_Utils {

	function nettoyer_chaine_indexation($texte) {
		
		$texte = translitteration($texte);

		if (lire_meta('langue_site') == 'vi')
			$texte = strtr($texte, "'`?~.^+(-", "123456789");

		return $texte;
		
	}
	
	function separateurs_indexation($requete = false) {
	
		// Merci a Herve Lefebvre pour son apport sur cette fonction
		$liste = "],:;*\"!\r\n\t\\/){}[|@<>$%";
	
		// en vietnamien ne pas eliminer les accents de translitteration
		if (!(lire_meta('langue_site') == 'vi' AND $requete))
			$liste .= "'`?\~.^+(-";
	
		// windowzeries iso-8859-1
		$charset = lire_meta('charset');
		if ($charset == 'iso-8859-1')
			$liste .= chr(187).chr(171).chr(133).chr(145).chr(146).chr(180).chr(147).chr(148);
	
		return $liste;
	
	}

	function spip_split($reg, $texte) {
		
		global $flag_pcre;
		if ($flag_pcre)
			return preg_split("/$reg/", $texte);
		
		else
			return split($reg, $texte);
			
	}
    
    function suppress_short_word ($string, $min_long = 3) {
        if (!is_int($min_long)) $min_long = 3;
        $tab = explode (' ', $string);
        foreach ($tab as $key => $word) {
            if (strlen($word) < $min_long) {
                unset ($tab[$key]); 
            }
        }
        return implode(' ', $tab);
    }
    
    function suppress_stop_words ($string) {
        include_once (dirname(__FILE__)."/../../mes_options.php3");
        if (isset($GLOBALS['stop_words'])) {
            foreach ($GLOBALS['stop_words'] as $stop) {
                $string = str_replace ($stop, '', $string);
            }
        } 
        return $string;
    }
    
    function fabriquer_chaine_indexation ($rech) {

        // Nettoyer les tags, entites HTML, signes diacritiques...
        $rech = ' '.ereg_replace("<[^>]*>"," ",$rech).' ';
        
        $rech = Indexer_Utils::nettoyer_chaine_indexation($rech);
        $regs = Indexer_Utils::separateurs_indexation(true)." ";
        $rech = strtr($rech, $regs, ereg_replace('.', ' ', $regs));
        // suppresion des mots courts
        include_once (dirname(__FILE__)."/../../mes_options.php3");
        $rech =  Indexer_Utils::suppress_short_word($rech, $GLOBALS['recherche_min_long']);
        $rech =  strtolower($rech);
        // suppression des stop words
        $rech = Indexer_Utils::suppress_stop_words ($rech);
        
        return $rech;
    
    }

}

?>