<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Article.
// $Id$

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_article_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_mot_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_auteur_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_articles_factory.php";


/**
 * Indexer_Article_common is an implementation for Common of article indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Article_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Article_common() {
		
		/*$poids = array();
		include(dirname(__FILE__)."/configurationArticlePoids_common.php");
		if(file_exists(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation'].".php")) {
			include(dirname(__FILE__)."/configurationArticlePoids_".$GLOBALS['type_indexation'].".php");
       	}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationArticlePoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationArticlePoids_".$GLOBALS['type_indexation'].".php");
        }*/
        $this->_setPoids($this->_findConfigFile('configurationArticlePoids', $GLOBALS['type_indexation']) );
		
		
		$this->_full = false;
		
		$this->_type = 'article';
		
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexArticleMetier = &recuperer_instance_index_articles();
		return ( $indexArticleMetier->howManyIndexArticleForArticleId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {

        include_once (dirname(__FILE__).'/../../bd/inc_article_factory.php');
		$articleMetier = &recuperer_instance_article();
		$loadOk = $articleMetier->load($id_objet);
		if (!PEAR::isError($loadOk)) {
		    $this->_indexer_chaine($articleMetier->getTitre(), $this->_poids['article']['titre'], $this->_minlong, 'titre');
			$this->_indexer_chaine($articleMetier->getSoustitre(), $this->_poids['article']['soustitre'],$this->_minlong,  'soustitre');
			$this->_indexer_chaine($articleMetier->getSurtitre(), $this->_poids['article']['surtitre'], $this->_minlong, 'surtitre');
			$this->_indexer_chaine($articleMetier->getDescriptif(), $this->_poids['article']['descriptif'], $this->_minlong, 'descriptif');
			if ($this->_full) {
                $this->_indexer_chaine($articleMetier->getChapo(), $this->_poids['article']['chapo'], $this->_minlong, 'chapo');
                $this->_indexer_chaine($articleMetier->getTexte(), $this->_poids['article']['texte'], $this->_minlong, 'texte');
                $this->_indexer_chaine($articleMetier->getPs(), $this->_poids['article']['ps'], $this->_minlong, 'ps');
                $this->_indexer_chaine($articleMetier->getNomSite(), $this->_poids['article']['nom_site'], $this->_minlong, 'nom_site');
                $this->_indexer_chaine($articleMetier->getUrlSite(), $this->_poids['article']['url_site'], $this->_minlong, 'url_site');
			}
		} else {
            PEAR::raiseError("indexer article $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }

        include_once (dirname(__FILE__).'/../../bd/inc_rubrique_factory.php');
        $rubriqueMetier = &recuperer_instance_rubrique();
        $loadOk = $rubriqueMetier->load($articleMetier->getRubriqueId());
        if (!PEAR::isError($loadOk)) {
            if ($this->_full) {
                $this->_indexer_chaine($rubriqueMetier->getTitre(), $this->_poids['rubrique']['titre'], $this->_minlong, 'titre_rubrique');
                $this->_indexer_chaine($rubriqueMetier->getDescriptif(), $this->_poids['rubrique']['descriptif'], $this->_minlong, 'descriptif_rubrique');
            }
        } else {
            PEAR::raiseError("indexer article $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }

        include_once (dirname(__FILE__).'/../../bd/inc_mot_factory.php');
	    $motMetier = &recuperer_instance_mot();
	    
		$allMots = $motMetier->getAllFromMotsAndAnotherTable("articles", "id_article", $id_objet);
		if(!PEAR::isError($allMots)) {
			while (list(,$motMetier) = each($allMots)) {
	    		$this->_indexer_chaine($motMetier->getTitre(), $this->_poids['mot']['titre'], $this->_minlong, 'titre_mot');
				$this->_indexer_chaine($motMetier->getDescriptif(), $this->_poids['mot']['descriptif'], $this->_minlong, 'descriptif_mot');
			}
		} else {
            PEAR::raiseError("indexer article $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }

        include_once (dirname(__FILE__).'/../../bd/inc_document_factory.php');
        $documentMetier = &recuperer_instance_document();
        $idDocs = $documentMetier->getAlldocumentIdsForArticleId($id_objet);
        if(!PEAR::isError($idDocs)) {
            while (list(,$idDoc) = each($idDocs)) {
                $loadOK = $documentMetier->load($idDoc);
                if(!PEAR::isError($loadOK)) {
                    $this->_indexer_chaine($documentMetier->getTitre(), $this->_poids['document']['titre'], $this->_minlong, 'titre_document');
                    $this->_indexer_chaine($documentMetier->getDescriptif(), $this->_poids['document']['descriptif'], $this->_minlong, 'descriptif_document');
                } else {
                    PEAR::raiseError("indexer article $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
                }
                //$this->_indexer_chaine($motMetier->getTitre(), $this->_poids['mot']['titre'], $this->_minlong, 'titre_mot');
                //$this->_indexer_chaine($motMetier->getDescriptif(), $this->_poids['mot']['descriptif'], $this->_minlong, 'descriptif_mot');
            }
        } else {
            PEAR::raiseError("indexer article $id_object : ".$idDocs->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }

    	$articleMetier = &recuperer_instance_article();
		$allAuteurs = $articleMetier->getAuteursForArticleId($id_objet);
		while (list(,$monAuteur) = each($allAuteurs)) {
 	   		$this->_indexer_chaine($monAuteur->getNom(), $this->_poids['auteur']['nom'], $this->_minlong, 'nom_auteur');
    	}

		$indexArticleMetier = &recuperer_instance_index_articles();
    	$indexArticleMetier->deleteIndexArticleForArticleId($id_objet);
    	
    }

    // }}}
	
	// {{{ 

    /*
    function _createIndex($id_objet) {
    	
    	$indexArticleCreateMetier = &recuperer_instance_index_articles();
		
		// while (list($hash, $points) = each($this->_index)) {
        foreach ($this->_index as $hash => $info1) {
            foreach ($info1 as $emplacement => $info) {
    	    	$indexArticleCreateMetier->setHash("0x$hash");
    	    	//$indexArticleCreateMetier->setPoints("$points");
                $indexArticleCreateMetier->setPoints($info['points']);
                $indexArticleCreateMetier->setEmplacement($emplacement);
    	    	$indexArticleCreateMetier->setArticleId("$id_objet");
            	$indexArticleCreateMetier->create();
            }
		}
    	
    }
*/
    // }}}

}

?>
