<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Auteur.
// $Id$

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_auteur_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_auteurs_factory.php";

/**
 * Indexer_Auteur_common is an implementation for Common of auteur indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Auteur_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Auteur_common() {
		
		/*$poids = array();
		include(dirname(__FILE__)."/configurationAuteurPoids_common.php");
		if(file_exists(dirname(__FILE__)."/configurationAuteurPoids_".$GLOBALS['type_indexation'].".php")) {
			include(dirname(__FILE__)."/configurationAuteurPoids_".$GLOBALS['type_indexation'].".php");
       	}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationAuteurPoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationAuteurPoids_".$GLOBALS['type_indexation'].".php");
        }*/
        $this->_setPoids($this->_findConfigFile('configurationAuteurPoids', $GLOBALS['type_indexation']) );
		
		$this->_full = false;
		
		$this->_type = 'auteur';
        
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexAuteurMetier = &recuperer_instance_index_auteurs();
		return ( $indexAuteurMetier->howManyIndexAuteurForAuteurId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {
    	include_once (dirname(__FILE__).'/../../bd/inc_auteur_factory.php');
        $auteurMetier = &recuperer_instance_auteur();
		$loadOK = $auteurMetier->load($id_objet);
		if(PEAR::isError($loadOK)) {
			//die($loadOK->getMessage());
             PEAR::raiseError("indexer auteur $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
		}
		else {
    		$this->_indexer_chaine($auteurMetier->getNom(), $this->_poids['auteur']['nom'], $this->_minlong, 'nom');
            if ($this->_full) {
            	$this->_indexer_chaine($auteurMetier->getBio(), $this->_poids['auteur']['bio'], $this->_minlong, 'bio');
			}
		}
                                                                                                                                              
        $indexAuteurMetier = &recuperer_instance_index_auteurs();
        $indexAuteurMetier->deleteIndexAuteurForAuteurId($id_objet);
        
    }

    // }}}
	
	// {{{ 
/*
    function _createIndex($id_objet) {
    	
		$indexAuteurCreateMetier = &recuperer_instance_index_auteurs();
		
		//while (list($hash, $points) = each($this->_index)) {
        foreach ($this->_index as $hash => $info1) {
            foreach ($info1 as $emplacement => $info) {
                $indexAuteurCreateMetier->setHash("0x$hash");
                //$indexArticleCreateMetier->setPoints("$points");
                $indexAuteurCreateMetier->setPoints($info['points']);
                $indexAuteurCreateMetier->setAuteurId("$id_objet");
                $indexAuteurCreateMetier->setEmplacement($info['emplacement']);
                $indexAuteurCreateMetier->create();
		  }                
        }
    	
    }
*/
    // }}}

}

?>
