<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Breve.
// $Id$

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_breve_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_breves_factory.php";

/**
 * Indexer_Breve_common is an implementation for Common of breve indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Breve_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Breve_common() {
		
		/*$poids = array();
		include(dirname(__FILE__)."/configurationBrevePoids_common.php");
		if(file_exists(dirname(__FILE__)."/configurationBrevePoids_".$GLOBALS['type_indexation'].".php")) {
			include(dirname(__FILE__)."/configurationBrevePoids_".$GLOBALS['type_indexation'].".php");
       	}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationBrevePoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationBrevePoids_".$GLOBALS['type_indexation'].".php");
        }
        */
		$this->_setPoids($this->_findConfigFile('configurationBrevePoids', $GLOBALS['type_indexation']) );
		
		$this->_full = false;
		
		$this->_type = 'breve';
        
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexBreveMetier = &recuperer_instance_index_breves();
		return ( $indexBreveMetier->howManyIndexBreveForBreveId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {
    	include_once (dirname(__FILE__).'/../../bd/inc_breve_factory.php');
        $breveMetier = &recuperer_instance_breve();
        $loadOk = $breveMetier->load($id_objet);
                                                                                                                                      
        if (PEAR::isError($loadOk)) {
    		//die($loadOk->getMessage());
             PEAR::raiseError("indexer breve $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
		}
		else {
            $this->_indexer_chaine($breveMetier->getTitre(), $this->_poids['breve']['titre'], $this->_minlong, 'titre');
        	if ($this->_full) {
                $this->_indexer_chaine($breveMetier->getTexte(), $this->_poids['breve']['texte'], $this->_minlong, 'texte');
			}
		}
                                                                                                                                      
        $indexBreveMetier = &recuperer_instance_index_breves();
		$indexBreveMetier->deleteIndexBreveForBreveId($id_objet);
		
    }

    // }}}
	
	// {{{ 
/*
    function _createIndex($id_objet) {
    	
		$indexBreveCreateMetier = &recuperer_instance_index_breves();
                                                                                                                                              
       foreach ($this->_index as $hash => $info1) {
           foreach ($info1 as $emplacement => $info) {
                $indexBreveCreateMetier->setHash("0x$hash");
                //$indexArticleCreateMetier->setPoints("$points");
                $indexBreveCreateMetier->setPoints($info['points']);
                $indexBreveCreateMetier->setBreveId($id_objet);
                $indexBreveCreateMetier->setEmplacement($info['emplacement']);
                $createOK = $indexBreveCreateMetier->create();
            }
    	}
    }
*/
    // }}}

}

?>
