<?php
//
// +----------------------------------------------------------------------+
// |                                      |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour               |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Document.


require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_index_documents_factory.php";

/**
 * Indexer_Document_common is an implementation for Common of article indexer.
 * @package	indexer/common
 * @author 	Olivier Mansour 
 * @access	public
 */
class Indexer_Document_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Document_common() {
		
        
        $this->_setPoids($this->_findConfigFile('configurationDocumentPoids', $GLOBALS['type_indexation']) );
		
		
		$this->_full = false;
		
		$this->_type = 'document';
		
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexDocMetier = &recuperer_instance_index_documents();
		return ( $indexDocMetier->howManyIndexDocumentForDocumentId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {

        include_once (dirname(__FILE__).'/../../bd/inc_document_factory.php');
        $documentMetier = &recuperer_instance_document();
        
        $loadOk = $documentMetier->load($id_objet);
        if (!PEAR::isError($loadOk)) {
            // indexation du doc
            $this->_indexer_chaine($documentMetier->getTitre(), $this->_poids['document']['titre'], $this->_minlong, 'titre'); 
            if ($this->_full) {
                $this->_indexer_chaine($documentMetier->getDescriptif(), $this->_poids['document']['descriptif'], $this->_minlong, 'descriptif'); 
            }
        
        } else {
            PEAR::raiseError("indexer document $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }
        
                
        $indexDocumentMetier = &recuperer_instance_index_documents();
        $indexDocumentMetier->deleteIndexDocumentForDocumentId($id_objet);
        
    }

    // }}}
	
	

}

?>
