<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Mot.
// $Id$

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_mot_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_mots_factory.php";

/**
 * Indexer_Mot_common is an implementation for Common of mot indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Mot_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Mot_common() {
		
		/*
        $poids = array();
		include(dirname(__FILE__)."/configurationMotPoids_common.php");
		if(file_exists(dirname(__FILE__)."/configurationMotPoids_".$GLOBALS['type_indexation'].".php")) {
			include(dirname(__FILE__)."/configurationMotPoids_".$GLOBALS['type_indexation'].".php");
       	}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationMotPoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationMotPoids_".$GLOBALS['type_indexation'].".php");
        }
        */
        $this->_setPoids($this->_findConfigFile('configurationMotPoids', $GLOBALS['type_indexation']) );
		
		$this->_full = false;
		
		$this->_type = 'mot';
        
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexMotMetier = &recuperer_instance_index_mots();
		return ( $indexMotMetier->howManyIndexMotForMotId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {
    	include_once (dirname(__FILE__).'/../../bd/inc_mot_factory.php');
		$motMetier = recuperer_instance_mot();
        $loadOK = $motMetier->load($id_objet);
        if(PEAR::isError($loadOK)) {
            //die($loadOK->getMessage());
             PEAR::raiseError("indexer mot $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
        }
        else {
            $this->_indexer_chaine($motMetier->getTitre(), $this->_poids['mot']['titre'], $this->_minlong, 'titre');
            $this->_indexer_chaine($motMetier->getDescriptif(), $this->_poids['mot']['descriptif'], $this->_minlong, 'descriptif');
            if ($this->_full) {
            	$this->_indexer_chaine($motMetier->getTexte(), $this->_poids['mot']['texte'], $this->_minlong, 'texte');
			}
		}
		
		$indexMotMetier = &recuperer_instance_index_mots();
        $indexMotMetier->deleteIndexMotForMotId($id_objet);

    }

    // }}}
	
	// {{{ 
/*
    function _createIndex($id_objet) {
    	
		$indexMotCreateMetier = &recuperer_instance_index_mots();
                                                                                                                                              
        foreach ($this->_index as $hash => $info1) {
            foreach ($info1 as $emplacement => $info) {
                $indexMotCreateMetier->setHash("0x$hash");
                //$indexArticleCreateMetier->setPoints("$points");
                $indexMotCreateMetier->setPoints($info['points']);
                $indexMotCreateMetier->setMotId($id_objet);
                $indexMotCreateMetier->setEmplacement($info['emplacement']);
                $createOK = $indexMotCreateMetier->create();
            }
    	}
    }
*/
    // }}}

}

?>
