<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever-Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Indexer_Rubrique.
// $Id$

require_once dirname(__FILE__)."/../Indexer.php";
require_once dirname(__FILE__)."/../../bd/inc_rubrique_factory.php";
require_once dirname(__FILE__)."/../../bd/inc_index_rubriques_factory.php";

/**
 * Indexer_Rubrique_common is an implementation for Common of rubrique indexer.
 * @package	indexer/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class Indexer_Rubrique_common extends Indexer {
    
    
	// {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function Indexer_Rubrique_common() {
		
		/*$poids = array();
		include(dirname(__FILE__)."/configurationRubriquePoids_common.php");
		if(file_exists(dirname(__FILE__)."/configurationRubriquePoids_".$GLOBALS['type_indexation'].".php")) {
			include(dirname(__FILE__)."/configurationRubriquePoids_".$GLOBALS['type_indexation'].".php");
       	}
        if(file_exists(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationRubriquePoids_".$GLOBALS['type_indexation'].".php")) {
            include(dirname(__FILE__)."/../".$GLOBALS['type_indexation']."/configurationRubriquePoids_".$GLOBALS['type_indexation'].".php");
        }
        */
        $this->_setPoids($this->_findConfigFile('configurationRubriquePoids', $GLOBALS['type_indexation']) );
		
		$this->_full = false;
		
		$this->_type = 'rubrique';
        
        $this->_minlong = $min_long;
		
    }

    // }}}

	// {{{
	
	function alreadyIndex($id_objet) {

		$indexRubriqueMetier = &recuperer_instance_index_rubriques();
		return ( $indexRubriqueMetier->howManyIndexRubriqueForRubriqueId($id_objet) > 0 );
	
	}
		
	// }}}
    
    // {{{

    function _indexData($id_objet) {
        include_once (dirname(__FILE__).'/../../bd/inc_rubrique_factory.php');
		$rubriqueMetier = &recuperer_instance_rubrique();
		$loadOk = $rubriqueMetier->load($id_objet);
		if (PEAR::isError($loadOk)) {
		    //die($loadOk->getMessage());
             PEAR::raiseError("indexer rubrique $id_object : ".$loadOk->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
		}
		else {
		    $this->_indexer_chaine($rubriqueMetier->getTitre(), $this->_poids['rubrique']['titre'], $this->_minlong, 'titre');
		    $this->_indexer_chaine($rubriqueMetier->getDescriptif(), $this->_poids['rubrique']['descriptif'], $this->_minlong, 'descriptif');
			if ($this->_full) {
		    	$this->_indexer_chaine($rubriqueMetier->getTexte(), $this->_poids['rubrique']['texte'], $this->_minlong, 'texte');
			}
		}
		
    }

    // }}}
	
	// {{{ 
/*
    function _createIndex($id_objet) {
    	
		$indexRubriqueCreateMetier = &recuperer_instance_index_rubriques();
                                                                                                                                              
        foreach ($this->_index as $hash => $info1) {
            foreach ($info1 as $emplacement => $info) {
                $indexRubriqueCreateMetier->setHash("0x$hash");
                //$indexArticleCreateMetier->setPoints("$points");
                $indexRubriqueCreateMetier->setPoints($info['points']);
                $indexRubriqueCreateMetier->setRubriqueId($id_objet);
                $indexRubriqueCreateMetier->setEmplacement($info['emplacement']);
                $createOK = $indexRubriqueCreateMetier->create();
            }
        }
    	
    }
*/
    // }}}

}

?>
